/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.editor.options.MIMEProcessor;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class MIMEOptionFile {
    protected BaseOptions base;
    protected MIMEProcessor processor;
    protected Document dom;
    protected Map properties;
    private boolean loaded = false;
    private boolean wasSaved = false;
    private ModuleInfo editorMI;
    private final FileChangeListener fileListener = new FileChangeAdapter(){

        public void fileChanged(FileEvent fe) {
            MIMEOptionFile.this.reloadSettings();
        }
    };
    private final PropertyChangeListener moduleListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if (!"enabled".endsWith(evt.getPropertyName())) {
                return;
            }
            if (!(evt.getSource() instanceof ModuleInfo)) {
                return;
            }
            if ((ModuleInfo)evt.getSource() != null && !((ModuleInfo)evt.getSource()).isEnabled()) {
                MIMEOptionFile.this.editorUninstalled();
            }
        }
    };
    private final ErrorCatcher ERROR_CATCHER = new ErrorCatcher();
    static /* synthetic */ Class class$org$openide$modules$ModuleInfo;

    public MIMEOptionFile(BaseOptions base, Object proc) {
        this.base = base;
        this.processor = (MIMEProcessor)proc;
        try {
            this.properties = new HashMap();
            this.dom = this.processor.getXMLDataObject().getDocument();
            this.processor.getXMLDataObject().getPrimaryFile().addFileChangeListener(this.fileListener);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.addEditorModuleListener();
    }

    private void addEditorModuleListener() {
        Lookup.Template templ = new Lookup.Template(class$org$openide$modules$ModuleInfo == null ? (class$org$openide$modules$ModuleInfo = MIMEOptionFile.class$("org.openide.modules.ModuleInfo")) : class$org$openide$modules$ModuleInfo);
        Lookup.Result result = Lookup.getDefault().lookup(templ);
        Collection modules = result.allInstances();
        Iterator iter = modules.iterator();
        while (iter.hasNext()) {
            ModuleInfo curInfo = (ModuleInfo)iter.next();
            if (!"org.netbeans.modules.editor".equals(curInfo.getCodeNameBase())) continue;
            curInfo.addPropertyChangeListener(this.moduleListener);
            this.editorMI = curInfo;
            break;
        }
    }

    private void editorUninstalled() {
        this.processor.getXMLDataObject().getPrimaryFile().removeFileChangeListener(this.fileListener);
        try {
            this.processor.getXMLDataObject().setValid(false);
        }
        catch (PropertyVetoException pve) {
            ErrorManager.getDefault().notify(1, (Throwable)pve);
        }
        this.editorMI.removePropertyChangeListener(this.moduleListener);
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    protected void setLoaded(boolean load) {
        this.loaded = load;
    }

    public synchronized void reloadSettings() {
        if (this.wasSaved) {
            this.wasSaved = false;
            return;
        }
        Document oldDoc = this.dom;
        this.setLoaded(false);
        try {
            String loc = this.processor.getXMLDataObject().getPrimaryFile().getURL().toExternalForm();
            this.dom = XMLUtil.parse((InputSource)new InputSource(loc), (boolean)true, (boolean)false, (ErrorHandler)this.ERROR_CATCHER, (EntityResolver)EntityCatalog.getDefault());
            this.loadSettings();
        }
        catch (SAXException saxe) {
            this.dom = oldDoc;
            saxe.printStackTrace();
        }
        catch (IOException ioe) {
            this.dom = oldDoc;
            ioe.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void saveSettings(Document doc) {
        try {
            FileLock lock = this.processor.getXMLDataObject().getPrimaryFile().lock();
            try {
                try {
                    block11: {
                        OutputStream os = this.processor.getXMLDataObject().getPrimaryFile().getOutputStream(lock);
                        try {
                            try {
                                this.wasSaved = true;
                                XMLUtil.write((Document)doc, (OutputStream)os, null);
                                os.flush();
                            }
                            catch (Exception e) {
                                this.wasSaved = false;
                                e.printStackTrace();
                                Object var6_7 = null;
                                os.close();
                                break block11;
                            }
                            Object var6_6 = null;
                        }
                        catch (Throwable throwable) {
                            Object var6_8 = null;
                            os.close();
                            throw throwable;
                        }
                        os.close();
                    }
                    Object var8_11 = null;
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    Object var8_12 = null;
                    lock.releaseLock();
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var8_13 = null;
                lock.releaseLock();
                throw throwable;
            }
            lock.releaseLock();
            return;
        }
        catch (IOException ioexc) {
            ioexc.printStackTrace();
        }
    }

    protected abstract void loadSettings(boolean var1);

    protected void loadSettings() {
        this.loadSettings(true);
    }

    protected abstract void updateSettings(Map var1);

    public Map getAllProperties() {
        if (!this.isLoaded()) {
            this.loadSettings(false);
        }
        return this.properties;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ErrorCatcher
    implements ErrorHandler {
        ErrorCatcher() {
        }

        private void message(String level, SAXParseException e) {
            System.err.println("Error level:" + level);
            System.err.println("Line number:" + e.getLineNumber());
            System.err.println("Column number:" + e.getColumnNumber());
            System.err.println("Public ID:" + e.getPublicId());
            System.err.println("System ID:" + e.getSystemId());
            System.err.println("Error message:" + e.getMessage());
        }

        public void error(SAXParseException e) {
            this.message("ERROR", e);
        }

        public void warning(SAXParseException e) {
            this.message("WARNING", e);
        }

        public void fatalError(SAXParseException e) {
            this.message("FATAL", e);
        }
    }
}

