/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.editor.Settings;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.editor.options.MIMEOptionFile;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class MacrosMIMEOptionFile
extends MIMEOptionFile {
    public static final String TAG_ROOT = "macros";
    public static final String TAG_MACRO = "macro";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_REMOVE = "remove";
    public static final String ATTR_XML_SPACE = "xml:space";
    public static final String VALUE_XML_SPACE = "preserve";
    static final String FILENAME = "macros";

    public MacrosMIMEOptionFile(BaseOptions base, Object proc) {
        super(base, proc);
    }

    protected synchronized void loadSettings(boolean propagate) {
        Document doc = this.dom;
        Element rootElement = doc.getDocumentElement();
        if (!"macros".equals(rootElement.getTagName())) {
            return;
        }
        HashMap mapa = new HashMap((Map)Settings.getValue(this.base.getKitClass(), "macro-map"));
        this.properties.clear();
        NodeList mcr = rootElement.getElementsByTagName(TAG_MACRO);
        int i = 0;
        while (i < mcr.getLength()) {
            Node node = mcr.item(i);
            Element FCElement = (Element)node;
            if (FCElement != null) {
                Node subNode;
                NodeList textList;
                String key = FCElement.getAttribute(ATTR_NAME);
                String delete = FCElement.getAttribute(ATTR_REMOVE);
                String action = "";
                if (!Boolean.valueOf(delete).booleanValue() && (textList = FCElement.getChildNodes()).getLength() > 0 && (subNode = textList.item(0)) instanceof Text) {
                    Text textNode = (Text)subNode;
                    action = textNode.getData();
                }
                this.properties.put(key, action);
            }
            ++i;
        }
        if (this.properties.size() > 0) {
            mapa.putAll(this.properties);
            Iterator i2 = this.properties.keySet().iterator();
            while (i2.hasNext()) {
                String key = (String)i2.next();
                if (((String)this.properties.get(key)).length() != 0) continue;
                mapa.remove(key);
            }
            if (propagate) {
                this.base.setMacroMap(mapa, false);
            }
        }
        if (propagate) {
            this.setLoaded(true);
        }
    }

    protected synchronized void updateSettings(Map changedProp) {
        this.properties.putAll(changedProp);
        Document doc = XMLUtil.createDocument((String)"macros", null, (String)this.processor.getPublicID(), (String)this.processor.getSystemID());
        Element rootElem = doc.getDocumentElement();
        ArrayList<String> removed = new ArrayList<String>();
        HashMap defaultMacros = this.base.getDefaultMacrosMap();
        if (defaultMacros == null) {
            defaultMacros = new HashMap();
        }
        Iterator i = this.properties.keySet().iterator();
        while (i.hasNext()) {
            String defValue;
            String key = (String)i.next();
            if (!(this.properties.get(key) instanceof String)) continue;
            String action = (String)this.properties.get(key);
            if (action.length() == 0) {
                if (!defaultMacros.containsKey(key)) {
                    removed.add(key);
                    continue;
                }
            } else if (defaultMacros.containsKey(key) && (defValue = (String)defaultMacros.get(key)).equals(action)) {
                removed.add(key);
                continue;
            }
            Element macroElem = doc.createElement(TAG_MACRO);
            macroElem.setAttribute(ATTR_NAME, key);
            if (action.length() == 0) {
                macroElem.setAttribute(ATTR_REMOVE, Boolean.TRUE.toString());
            } else {
                macroElem.setAttribute(ATTR_XML_SPACE, VALUE_XML_SPACE);
                macroElem.appendChild(doc.createTextNode(action));
            }
            rootElem.appendChild(macroElem);
        }
        int i2 = 0;
        while (i2 < removed.size()) {
            this.properties.remove(removed.get(i2));
            ++i2;
        }
        doc.getDocumentElement().normalize();
        this.saveSettings(doc);
    }
}

