/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.editor.Settings;
import org.netbeans.modules.editor.EditorModule;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.options.SystemOption;
import org.openide.util.NbBundle;

public class OptionSupport
extends SystemOption {
    static final long serialVersionUID = 2002899758839584077L;
    static final String OPTIONS_PREFIX = "OPTIONS_";
    private Class kitClass;
    private String typeName;
    private HashMap initializerValuesMap;
    private transient SettingsInitializer settingsInitializer;
    private static final HashMap kitClass2Type = new HashMap();
    static /* synthetic */ Class class$org$netbeans$modules$editor$options$OptionSupport;

    public OptionSupport(Class kitClass, String typeName) {
        this.kitClass = kitClass;
        this.typeName = typeName;
        this.initializerValuesMap = new HashMap();
        kitClass2Type.put(kitClass, typeName);
    }

    public Class getKitClass() {
        return this.kitClass;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public static String getTypeName(Class kitClass) {
        return (String)kitClass2Type.get(kitClass);
    }

    public String displayName() {
        return this.getString(OPTIONS_PREFIX + this.typeName);
    }

    Settings.KitAndValue[] getSettingValueHierarchy(String settingName) {
        return Settings.getValueHierarchy(this.kitClass, settingName);
    }

    public Object getSettingValue(String settingName) {
        EditorModule.init();
        return Settings.getValue(this.kitClass, settingName);
    }

    protected final boolean getSettingBoolean(String settingName) {
        Boolean val = (Boolean)this.getSettingValue(settingName);
        return val != null ? val : false;
    }

    protected final int getSettingInteger(String settingName) {
        Integer val = (Integer)this.getSettingValue(settingName);
        return val != null ? val : 0;
    }

    public void setSettingValue(String settingName, Object newValue) {
        this.setSettingValue(settingName, newValue, settingName);
    }

    public void setSettingValue(String settingName, Object newValue, String propertyName) {
        this.initializerValuesMap.put(settingName, newValue);
        Object oldValue = this.getSettingValue(settingName);
        if (oldValue == null && newValue == null || oldValue != null && oldValue.equals(newValue)) {
            return;
        }
        Settings.setValue(this.kitClass, settingName, newValue);
        if (propertyName != null) {
            // empty if block
        }
    }

    public void doSetSettingValue(String settingName, Object newValue, String propertyName) {
        this.initializerValuesMap.put(settingName, newValue);
        Settings.setValue(this.kitClass, settingName, newValue);
    }

    protected void setSettingBoolean(String settingName, boolean newValue, String propertyName) {
        this.setSettingValue(settingName, newValue ? Boolean.TRUE : Boolean.FALSE, propertyName);
    }

    protected void setSettingInteger(String settingName, int newValue, String propertyName) {
        this.setSettingValue(settingName, new Integer(newValue));
    }

    protected String getString(String s) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$editor$options$OptionSupport == null ? (class$org$netbeans$modules$editor$options$OptionSupport = OptionSupport.class$("org.netbeans.modules.editor.options.OptionSupport")) : class$org$netbeans$modules$editor$options$OptionSupport), (String)s);
    }

    public static String[] mergeStringArrays(String[] a1, String[] a2) {
        return NbEditorUtilities.mergeStringArrays(a1, a2);
    }

    public boolean isGlobal() {
        return true;
    }

    protected String getSettingsInitializerName() {
        return this.getTypeName() + "-options-initalizer";
    }

    protected void updateSettingsMap(Class kitClass, Map settingsMap) {
        if (kitClass == this.getKitClass()) {
            settingsMap.putAll(this.initializerValuesMap);
        }
    }

    Settings.Initializer getSettingsInitializer() {
        if (this.settingsInitializer == null) {
            this.settingsInitializer = new SettingsInitializer();
        }
        return this.settingsInitializer;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class SettingsInitializer
    implements Settings.Initializer {
        String name;

        SettingsInitializer() {
        }

        public String getName() {
            if (this.name == null) {
                this.name = OptionSupport.this.getSettingsInitializerName();
            }
            return this.name;
        }

        public void updateSettingsMap(Class kitClass, Map settingsMap) {
            OptionSupport.this.updateSettingsMap(kitClass, settingsMap);
        }
    }
}

