/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.editor.options.ScrollInsetsEditor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ScrollInsetsCustomEditor
extends JPanel
implements EnhancedCustomPropertyEditor {
    static final long serialVersionUID = -1472891501739636852L;
    private static final String HELP_ID = "editing.scrollinsets";
    private ScrollInsetsEditor editor;
    private JLabel topLabel;
    private JTextField topField;
    private JLabel leftLabel;
    private JTextField leftField;
    private JPanel jPanel2;
    private JLabel rightLabel;
    private JLabel bottomLabel;
    private JTextField rightField;
    private JTextField bottomField;
    static /* synthetic */ Class class$org$netbeans$modules$editor$options$ScrollInsetsCustomEditor;

    public ScrollInsetsCustomEditor(ScrollInsetsEditor editor) {
        this.initComponents();
        this.editor = editor;
        Insets insets = (Insets)editor.getValue();
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        this.getAccessibleContext().setAccessibleDescription(this.getBundleString("ACSD_SICE"));
        this.topLabel.setDisplayedMnemonic(this.getBundleString("SICE_Top_Mnemonic").charAt(0));
        this.bottomLabel.setDisplayedMnemonic(this.getBundleString("SICE_Bottom_Mnemonic").charAt(0));
        this.leftLabel.setDisplayedMnemonic(this.getBundleString("SICE_Left_Mnemonic").charAt(0));
        this.rightLabel.setDisplayedMnemonic(this.getBundleString("SICE_Right_Mnemonic").charAt(0));
        this.topField.setText(ScrollInsetsCustomEditor.int2percent(insets.top));
        this.leftField.setText(ScrollInsetsCustomEditor.int2percent(insets.left));
        this.bottomField.setText(ScrollInsetsCustomEditor.int2percent(insets.bottom));
        this.rightField.setText(ScrollInsetsCustomEditor.int2percent(insets.right));
        this.topField.getAccessibleContext().setAccessibleDescription(this.getBundleString("ACSD_SICE_Top"));
        this.leftField.getAccessibleContext().setAccessibleDescription(this.getBundleString("ACSD_SICE_Left"));
        this.bottomField.getAccessibleContext().setAccessibleDescription(this.getBundleString("ACSD_SICE_Bottom"));
        this.rightField.getAccessibleContext().setAccessibleDescription(this.getBundleString("ACSD_SICE_Right"));
        HelpCtx.setHelpIDString((JComponent)this, (String)HELP_ID);
        this.setPreferredSize(new Dimension(320, this.getPreferredSize().height));
    }

    private String getBundleString(String s) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$editor$options$ScrollInsetsCustomEditor == null ? (class$org$netbeans$modules$editor$options$ScrollInsetsCustomEditor = ScrollInsetsCustomEditor.class$("org.netbeans.modules.editor.options.ScrollInsetsCustomEditor")) : class$org$netbeans$modules$editor$options$ScrollInsetsCustomEditor), (String)s);
    }

    public Object getPropertyValue() throws IllegalStateException {
        try {
            return this.getValue();
        }
        catch (NumberFormatException e) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)this.getBundleString("SIC_InvalidValue"), 0));
            throw new IllegalStateException();
        }
    }

    public static String int2percent(int i) {
        if (i < 0) {
            return "" + -i + "%";
        }
        return "" + i;
    }

    private int percent2int(String val) throws NumberFormatException {
        if ((val = val.trim()).endsWith("%")) {
            return -Math.abs(Integer.parseInt(val.substring(0, val.length() - 1)));
        }
        return Integer.parseInt(val);
    }

    Insets getValue() throws NumberFormatException {
        int top = this.percent2int(this.topField.getText());
        int left = this.percent2int(this.leftField.getText());
        int bottom = this.percent2int(this.bottomField.getText());
        int right = this.percent2int(this.rightField.getText());
        return new Insets(top, left, bottom, right);
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.topLabel = new JLabel();
        this.topField = new JTextField();
        this.leftLabel = new JLabel();
        this.leftField = new JTextField();
        this.bottomLabel = new JLabel();
        this.bottomField = new JTextField();
        this.rightLabel = new JLabel();
        this.rightField = new JTextField();
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(new EmptyBorder(new Insets(12, 12, 11, 11)));
        this.jPanel2.setLayout(new GridBagLayout());
        this.topLabel.setLabelFor(this.topField);
        this.topLabel.setText(this.getBundleString("SICE_Top"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 12);
        this.jPanel2.add((Component)this.topLabel, gridBagConstraints);
        this.topField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScrollInsetsCustomEditor.this.updateInsets(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.topField, gridBagConstraints);
        this.leftLabel.setLabelFor(this.leftField);
        this.leftLabel.setText(this.getBundleString("SICE_Left"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 12);
        this.jPanel2.add((Component)this.leftLabel, gridBagConstraints);
        this.leftField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScrollInsetsCustomEditor.this.updateInsets(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel2.add((Component)this.leftField, gridBagConstraints);
        this.bottomLabel.setLabelFor(this.bottomField);
        this.bottomLabel.setText(this.getBundleString("SICE_Bottom"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 12);
        this.jPanel2.add((Component)this.bottomLabel, gridBagConstraints);
        this.bottomField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScrollInsetsCustomEditor.this.updateInsets(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel2.add((Component)this.bottomField, gridBagConstraints);
        this.rightLabel.setLabelFor(this.rightField);
        this.rightLabel.setText(this.getBundleString("SICE_Right"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 0, 0, 12);
        this.jPanel2.add((Component)this.rightLabel, gridBagConstraints);
        this.rightField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScrollInsetsCustomEditor.this.updateInsets(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel2.add((Component)this.rightField, gridBagConstraints);
        this.add(this.jPanel2);
    }

    private void updateInsets(ActionEvent evt) {
        try {
            this.editor.setValue(this.getValue());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

