/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javahelp;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.javahelp.Help;
import org.netbeans.modules.javahelp.Installer;
import org.openide.cookies.InstanceCookie;
import org.openide.loaders.XMLDataObject;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.WeakListener;
import org.xml.sax.AttributeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public final class HelpCtxProcessor
implements XMLDataObject.Processor,
InstanceCookie.Of {
    private XMLDataObject xml;
    private Action p;
    static /* synthetic */ Class class$org$netbeans$api$javahelp$Help;
    static /* synthetic */ Class class$org$netbeans$modules$javahelp$HelpCtxProcessor$ShortcutAction;
    static /* synthetic */ Class class$javax$swing$Action;

    private static Help findHelp() {
        return (Help)Lookup.getDefault().lookup(class$org$netbeans$api$javahelp$Help == null ? (class$org$netbeans$api$javahelp$Help = HelpCtxProcessor.class$("org.netbeans.api.javahelp.Help")) : class$org$netbeans$api$javahelp$Help);
    }

    public void attachTo(XMLDataObject xml) {
        this.xml = xml;
        Installer.err.log("processing help context ref: " + xml.getPrimaryFile());
    }

    public Class instanceClass() throws IOException, ClassNotFoundException {
        return class$org$netbeans$modules$javahelp$HelpCtxProcessor$ShortcutAction == null ? (class$org$netbeans$modules$javahelp$HelpCtxProcessor$ShortcutAction = HelpCtxProcessor.class$("org.netbeans.modules.javahelp.HelpCtxProcessor$ShortcutAction")) : class$org$netbeans$modules$javahelp$HelpCtxProcessor$ShortcutAction;
    }

    public String instanceName() {
        return "org.netbeans.modules.javahelp.HelpCtxProcessor$ShortcutAction";
    }

    public boolean instanceOf(Class type) {
        return type == (class$javax$swing$Action == null ? (class$javax$swing$Action = HelpCtxProcessor.class$("javax.swing.Action")) : class$javax$swing$Action);
    }

    public Object instanceCreate() throws IOException, ClassNotFoundException {
        if (this.p != null) {
            return this.p;
        }
        Installer.err.log("creating help context presenter from " + this.xml.getPrimaryFile());
        EntityResolver resolver = new EntityResolver(){

            public InputSource resolveEntity(String pubid, String sysid) {
                return new InputSource(new ByteArrayInputStream(new byte[0]));
            }
        };
        HandlerBase handler = new HandlerBase(){

            public void startElement(String name, AttributeList amap) throws SAXException {
                if ("helpctx".equals(name)) {
                    String id = amap.getValue("id");
                    String showmaster = amap.getValue("showmaster");
                    if (id != null && !"".equals(id)) {
                        HelpCtxProcessor.this.p = new ShortcutAction(HelpCtxProcessor.this.xml, id, Boolean.valueOf(showmaster));
                    }
                }
            }
        };
        Parser parser = XMLDataObject.createParser();
        parser.setEntityResolver(resolver);
        parser.setDocumentHandler(handler);
        try {
            parser.parse(new InputSource(this.xml.getPrimaryFile().getInputStream()));
        }
        catch (SAXException saxe) {
            IOException ioe = new IOException(saxe.toString());
            Installer.err.annotate((Throwable)ioe, (Throwable)saxe);
            throw ioe;
        }
        if (this.p == null) {
            throw new IOException("No <helpctx> element in " + this.xml.getPrimaryFile());
        }
        return this.p;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class ShortcutAction
    extends AbstractAction
    implements HelpCtx.Provider,
    NodeListener,
    ChangeListener {
        private final XMLDataObject obj;
        private String helpID;
        private boolean showmaster;

        public ShortcutAction(XMLDataObject obj, String helpID, boolean showmaster) {
            Help h;
            this.obj = obj;
            this.helpID = helpID;
            this.showmaster = showmaster;
            Installer.err.log("new ShortcutAction: " + obj + " " + helpID + " showmaster=" + showmaster);
            this.updateText();
            this.updateIcon();
            this.updateEnabled();
            if (obj.isValid()) {
                Node n = obj.getNodeDelegate();
                n.addNodeListener(WeakListener.node((NodeListener)this, (Object)n));
            }
            if ((h = HelpCtxProcessor.findHelp()) != null) {
                h.addChangeListener(WeakListener.change((ChangeListener)this, (Object)h));
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Help h = HelpCtxProcessor.findHelp();
            if (h != null) {
                Installer.err.log("ShortcutAction.actionPerformed: " + this.helpID + " showmaster=" + this.showmaster);
                h.showHelp(new HelpCtx(this.helpID), this.showmaster);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("ide.welcome");
        }

        public void stateChanged(ChangeEvent e) {
            this.updateEnabled();
        }

        public void propertyChange(PropertyChangeEvent ev) {
            String prop = ev.getPropertyName();
            if (!this.obj.isValid()) {
                return;
            }
            if (prop == null || prop.equals("name") || prop.equals("displayName")) {
                this.updateText();
            }
            if (prop == null || prop.equals("icon")) {
                this.updateIcon();
            }
        }

        private void updateText() {
            String text = this.obj.isValid() ? this.obj.getNodeDelegate().getDisplayName() : "dead";
            this.putValue("Name", text);
        }

        private void updateIcon() {
            if (this.obj.isValid()) {
                this.putValue("SmallIcon", new ImageIcon(this.obj.getNodeDelegate().getIcon(1)));
            }
        }

        private void updateEnabled() {
            Boolean valid;
            Help h = HelpCtxProcessor.findHelp();
            Boolean bl = valid = h == null ? Boolean.FALSE : h.isValidID(this.helpID, false);
            if (valid != null) {
                this.setEnabled(valid);
            }
            Installer.err.log("enabled: xml=" + this.obj.getPrimaryFile() + " id=" + this.helpID + " enabled=" + valid);
        }

        public void nodeDestroyed(NodeEvent ev) {
            this.setEnabled(false);
            this.updateText();
        }

        public void childrenAdded(NodeMemberEvent ev) {
        }

        public void childrenRemoved(NodeMemberEvent ev) {
        }

        public void childrenReordered(NodeReorderEvent ev) {
        }
    }
}

