/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javahelp;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.MissingResourceException;
import org.netbeans.modules.javahelp.Installer;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class NbDocsStreamHandler
extends URLStreamHandler {
    NbDocsStreamHandler() {
    }

    protected URLConnection openConnection(URL u) throws IOException {
        if (u.getProtocol().equals("nbdocs")) {
            return new NbDocsURLConnection(u);
        }
        throw new IOException("mismatched protocol");
    }

    private static final class NbDocsURLConnection
    extends URLConnection {
        private URLConnection real = null;
        private IOException exception = null;
        static /* synthetic */ Class class$org$netbeans$modules$javahelp$NbDocsStreamHandler;

        public NbDocsURLConnection(URL u) {
            super(u);
        }

        public synchronized void connect() throws IOException {
            if (this.exception != null) {
                IOException e = this.exception;
                this.exception = null;
                throw e;
            }
            if (!this.connected) {
                URL target;
                String basename;
                String ext;
                int index;
                String resource = this.url.getFile();
                if (resource.startsWith("/")) {
                    resource = resource.substring(1);
                }
                if ((index = resource.lastIndexOf(46)) != -1 && index > resource.lastIndexOf(47)) {
                    ext = resource.substring(index + 1);
                    basename = resource.substring(0, index).replace('/', '.');
                } else {
                    ext = null;
                    basename = resource.replace('/', '.');
                }
                try {
                    target = NbBundle.getLocalizedFile((String)basename, (String)ext);
                }
                catch (MissingResourceException mre) {
                    File f = InstalledFileLocator.getDefault().locate("docs/" + resource, null, true);
                    if (f != null) {
                        target = Utilities.toURL((File)f);
                    }
                    IOException ioe = new IOException("cannot connect to " + this.url + ": " + mre);
                    Installer.err.annotate((Throwable)ioe, NbBundle.getMessage((Class)(class$org$netbeans$modules$javahelp$NbDocsStreamHandler == null ? (class$org$netbeans$modules$javahelp$NbDocsStreamHandler = NbDocsURLConnection.class$("org.netbeans.modules.javahelp.NbDocsStreamHandler")) : class$org$netbeans$modules$javahelp$NbDocsStreamHandler), (String)"EXC_nbdocs_cannot_connect", (Object)this.url));
                    Installer.err.annotate((Throwable)ioe, (Throwable)mre);
                    throw ioe;
                }
                this.real = target.openConnection();
                this.real.connect();
                this.connected = true;
            }
        }

        private void tryToConnect() {
            if (this.connected || this.exception != null) {
                return;
            }
            try {
                this.connect();
            }
            catch (IOException ioe) {
                this.exception = ioe;
            }
        }

        public String getHeaderField(int n) {
            this.tryToConnect();
            if (this.connected) {
                return this.real.getHeaderField(n);
            }
            return null;
        }

        public String getHeaderFieldKey(int n) {
            this.tryToConnect();
            if (this.connected) {
                return this.real.getHeaderFieldKey(n);
            }
            return null;
        }

        public String getHeaderField(String key) {
            this.tryToConnect();
            if (this.connected) {
                return this.real.getHeaderField(key);
            }
            return null;
        }

        public InputStream getInputStream() throws IOException {
            this.connect();
            return this.real.getInputStream();
        }

        public OutputStream getOutputStream() throws IOException {
            this.connect();
            return this.real.getOutputStream();
        }

        public String getContentType() {
            this.tryToConnect();
            if (this.connected) {
                return this.real.getContentType();
            }
            return "application/octet-stream";
        }

        public int getContentLength() {
            this.tryToConnect();
            if (this.connected) {
                return this.real.getContentLength();
            }
            return 0;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static final class Factory
    implements URLStreamHandlerFactory {
        public URLStreamHandler createURLStreamHandler(String protocol) {
            if (protocol.equals("nbdocs")) {
                return new NbDocsStreamHandler();
            }
            return null;
        }
    }
}

