/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat.tomcat40.runtime;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspEngineContext;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.JspCompiler;
import org.apache.jasper.logging.Logger;
import org.apache.jasper.servlet.JasperLoader;
import org.apache.jasper.servlet.JspServlet;
import org.netbeans.modules.tomcat.tomcat40.runtime.CompilationBridge;
import org.netbeans.modules.tomcat.tomcat40.runtime.CompilationFailedException;
import org.netbeans.modules.tomcat.tomcat40.runtime.IDEEmbeddedOptions;

public class IDEJspServlet
extends JspServlet {
    private static final boolean debug = false;
    private int internalPort;
    Hashtable loadedJSPTimes = new Hashtable();
    static /* synthetic */ Class class$org$apache$jasper$servlet$JasperLoader;
    static /* synthetic */ Class array$Ljava$net$URL;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$java$security$PermissionCollection;
    static /* synthetic */ Class class$java$security$CodeSource;
    static /* synthetic */ Class class$org$apache$jasper$servlet$JspServlet;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String internalPortString = config.getInitParameter("internalPort");
        this.internalPort = 8082;
        if (internalPortString != null) {
            try {
                this.internalPort = Integer.parseInt(internalPortString);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        try {
            this.options = new IDEEmbeddedOptions(this.options, this.context);
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void serviceJspFile(HttpServletRequest request, HttpServletResponse response, String jspUri, Throwable exception, boolean precompile) throws ServletException, IOException {
        boolean isErrorPage = exception != null;
        JspServletWrapper wrapper = (JspServletWrapper)this.jsps.get(jspUri);
        if (wrapper == null) {
            wrapper = new JspServletWrapper(jspUri, isErrorPage);
            this.jsps.put(jspUri, wrapper);
        }
        wrapper.service(request, response, precompile);
    }

    boolean preCompile(HttpServletRequest request) throws ServletException {
        String value;
        String queryString = request.getQueryString();
        if (queryString == null) {
            return false;
        }
        int start = queryString.indexOf("jsp_precompile");
        if (start < 0) {
            return false;
        }
        if ((queryString = queryString.substring(start + "jsp_precompile".length())).length() == 0) {
            return true;
        }
        if (queryString.startsWith("&")) {
            return true;
        }
        if (!queryString.startsWith("=")) {
            return false;
        }
        int limit = queryString.length();
        int ampersand = queryString.indexOf("&");
        if (ampersand > 0) {
            limit = ampersand;
        }
        if ((value = queryString.substring(1, limit)).equals("true")) {
            return true;
        }
        if (value.equals("false")) {
            return true;
        }
        throw new ServletException("Cannot have request parameter jsp_precompile set to " + value);
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            String includeUri = (String)request.getAttribute("javax.servlet.include.servlet_path");
            String jspUri = includeUri == null ? request.getServletPath() : includeUri;
            String jspFile = (String)request.getAttribute("org.apache.catalina.jsp_file");
            if (jspFile != null) {
                jspUri = jspFile;
            }
            boolean precompile = this.preCompile(request);
            Logger jasperLog = Constants.jasperLog;
            if (jasperLog != null && jasperLog.matchVerbosityLevel(3)) {
                jasperLog.log("JspEngine --> " + jspUri);
                jasperLog.log("\t     ServletPath: " + request.getServletPath());
                jasperLog.log("\t        PathInfo: " + request.getPathInfo());
                jasperLog.log("\t        RealPath: " + this.getServletConfig().getServletContext().getRealPath(jspUri));
                jasperLog.log("\t      RequestURI: " + request.getRequestURI());
                jasperLog.log("\t     QueryString: " + request.getQueryString());
                jasperLog.log("\t  Request Params: ");
                Enumeration e = request.getParameterNames();
                while (e.hasMoreElements()) {
                    String name = (String)e.nextElement();
                    jasperLog.log("\t\t " + name + " = " + request.getParameter(name));
                }
            }
            this.serviceJspFile(request, response, jspUri, null, precompile);
        }
        catch (CompilationFailedException e) {
            CompilationBridge.outputCompilationFailedPage(request, response);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (ServletException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServletException(e);
        }
    }

    public void destroy() {
        if (Constants.jasperLog != null) {
            Constants.jasperLog.log("JspServlet.destroy()", 3);
        }
        Enumeration servlets = this.jsps.elements();
        while (servlets.hasMoreElements()) {
            ((JspServletWrapper)servlets.nextElement()).destroy();
        }
    }

    boolean loadJSP(String jspUri, String classpath, boolean isErrorPage, HttpServletRequest req, HttpServletResponse res) throws JasperException, FileNotFoundException {
        Compiler compiler;
        boolean outDated;
        JspEngineContext ctxt;
        JspServletWrapper jsw;
        block22: {
            if (this.context.getResourceAsStream(jspUri) == null) {
                throw new FileNotFoundException(jspUri);
            }
            jsw = (JspServletWrapper)this.jsps.get(jspUri);
            if (jsw == null) {
                throw new JasperException("Can't happen - JspServletWrapper=null");
            }
            File outDir = null;
            try {
                URL outURL = this.options.getScratchDir().toURL();
                String outURI = outURL.toString();
                outURI = outURI.endsWith("/") ? outURI + jspUri.substring(1, jspUri.lastIndexOf("/") + 1) : outURI + jspUri.substring(0, jspUri.lastIndexOf("/") + 1);
                outURL = new URL(outURI);
                outDir = new File(outURL.getFile());
                if (!outDir.exists()) {
                    outDir.mkdirs();
                }
            }
            catch (Exception e) {
                throw new JasperException("No output directory: " + e.getMessage());
            }
            boolean firstTime = jsw.servletClass == null;
            ctxt = new JspEngineContext(this.parentClassLoader, classpath, this.context, jspUri, outDir.toString() + File.separator, isErrorPage, this.options, req, res);
            outDated = false;
            compiler = ctxt.createCompiler();
            try {
                Object jsp;
                if (compiler.isOutDated()) {
                    jsp = new File(ctxt.getJspFile());
                    String fileName = ctxt.getRealPath(((File)jsp).getPath());
                    if (fileName == null) {
                        throw new FileNotFoundException(((File)jsp).toString());
                    }
                    File jspReal = new File(fileName);
                    String compileResult = CompilationBridge.callCompilationServlet(jspReal.getAbsolutePath(), jspUri, this.internalPort);
                    if ("ERROR".equals(compileResult)) {
                        throw new CompilationFailedException();
                    }
                }
                outDated = compiler.compile();
                if (jsw.servletClass != null && !compiler.isOutDated()) break block22;
                jsp = this;
                synchronized (jsp) {
                    if (jsw.servletClass == null || compiler.isOutDated()) {
                        outDated = compiler.compile();
                    }
                }
            }
            catch (FileNotFoundException ex) {
                compiler.removeGeneratedFiles();
                throw ex;
            }
            catch (JasperException ex) {
                throw ex;
            }
            catch (CompilationFailedException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new JasperException(Constants.getString((String)"jsp.error.unable.compile"), (Throwable)ex);
            }
        }
        String nbClassName = ((JspCompiler)compiler).getClassFileName();
        File nbClassFile = new File(nbClassName);
        if (!outDated && jsw.servletClass != null) {
            outDated = this.checkIDEOutDated(jspUri, nbClassFile);
        }
        if (jsw.servletClass == null || outDated) {
            try {
                URL[] urls = new URL[1];
                File outputDir = new File(this.normalize(ctxt.getOutputDir()));
                urls[0] = outputDir.toURL();
                jsw.loader = this.createJasperLoader(urls, ctxt.getServletClassName(), this.parentClassLoader, this.getPermissionCollection(), this.getCodeSource());
                jsw.servletClass = jsw.loader.loadClass("org.apache.jsp." + ctxt.getServletClassName());
                this.loadedJSPTimes.put(jspUri, new Long(nbClassFile.lastModified()));
            }
            catch (ClassNotFoundException cex) {
                throw new JasperException(Constants.getString((String)"jsp.error.unable.load"), (Throwable)cex);
            }
            catch (MalformedURLException mue) {
                throw new JasperException(Constants.getString((String)"jsp.error.unable.load"), (Throwable)mue);
            }
        }
        return outDated;
    }

    public boolean checkIDEOutDated(String jspUri, File classFile) {
        Long jspClassTime = (Long)this.loadedJSPTimes.get(jspUri);
        if (!classFile.exists()) {
            new IllegalStateException().printStackTrace();
            return false;
        }
        if (jspClassTime == null) {
            new IllegalStateException().printStackTrace();
            return false;
        }
        return jspClassTime < classFile.lastModified();
    }

    public JasperLoader createJasperLoader(URL[] urls, String className, ClassLoader parent, PermissionCollection permissionCollection, CodeSource codeSource) {
        try {
            Class jl = class$org$apache$jasper$servlet$JasperLoader == null ? (class$org$apache$jasper$servlet$JasperLoader = IDEJspServlet.class$("org.apache.jasper.servlet.JasperLoader")) : class$org$apache$jasper$servlet$JasperLoader;
            Constructor constr = jl.getDeclaredConstructor(array$Ljava$net$URL == null ? (array$Ljava$net$URL = IDEJspServlet.class$("[Ljava.net.URL;")) : array$Ljava$net$URL, class$java$lang$String == null ? (class$java$lang$String = IDEJspServlet.class$("java.lang.String")) : class$java$lang$String, class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = IDEJspServlet.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader, class$java$security$PermissionCollection == null ? (class$java$security$PermissionCollection = IDEJspServlet.class$("java.security.PermissionCollection")) : class$java$security$PermissionCollection, class$java$security$CodeSource == null ? (class$java$security$CodeSource = IDEJspServlet.class$("java.security.CodeSource")) : class$java$security$CodeSource);
            ((AccessibleObject)constr).setAccessible(true);
            return (JasperLoader)constr.newInstance(urls, className, parent, permissionCollection, codeSource);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public PermissionCollection getPermissionCollection() {
        try {
            Class jspsCl = class$org$apache$jasper$servlet$JspServlet == null ? (class$org$apache$jasper$servlet$JspServlet = IDEJspServlet.class$("org.apache.jasper.servlet.JspServlet")) : class$org$apache$jasper$servlet$JspServlet;
            Field field = jspsCl.getDeclaredField("permissionCollection");
            ((AccessibleObject)field).setAccessible(true);
            return (PermissionCollection)field.get((Object)this);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
    }

    public CodeSource getCodeSource() {
        try {
            Class jspsCl = class$org$apache$jasper$servlet$JspServlet == null ? (class$org$apache$jasper$servlet$JspServlet = IDEJspServlet.class$("org.apache.jasper.servlet.JspServlet")) : class$org$apache$jasper$servlet$JspServlet;
            Field field = jspsCl.getDeclaredField("codeSource");
            ((AccessibleObject)field).setAccessible(true);
            return (CodeSource)field.get((Object)this);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class JspServletWrapper {
        Servlet theServlet;
        String jspUri;
        boolean isErrorPage;
        Class servletClass;
        URLClassLoader loader = null;

        JspServletWrapper(String jspUri, boolean isErrorPage) {
            this.jspUri = jspUri;
            this.isErrorPage = isErrorPage;
            this.theServlet = null;
        }

        private void load() throws JasperException, ServletException {
            try {
                this.destroy();
                this.theServlet = (Servlet)this.servletClass.newInstance();
            }
            catch (Exception ex) {
                throw new JasperException((Throwable)ex);
            }
            this.theServlet.init(IDEJspServlet.this.config);
        }

        private void loadIfNecessary(HttpServletRequest req, HttpServletResponse res) throws JasperException, ServletException, FileNotFoundException {
            String accordingto;
            String cp = (String)IDEJspServlet.this.context.getAttribute("org.apache.catalina.jsp_classpath");
            if (cp == null || cp.equals("")) {
                accordingto = "according to the init parameter";
                cp = IDEJspServlet.this.options.getClassPath();
            } else {
                accordingto = "according to the Servlet Engine";
            }
            Constants.message((String)"jsp.message.cp_is", (Object[])new Object[]{accordingto, cp == null ? "" : cp}, (int)3);
            if (IDEJspServlet.this.loadJSP(this.jspUri, cp, this.isErrorPage, req, res) || this.theServlet == null) {
                this.load();
            }
        }

        public void service(HttpServletRequest request, HttpServletResponse response, boolean precompile) throws ServletException, IOException, FileNotFoundException {
            block10: {
                try {
                    this.loadIfNecessary(request, response);
                    if (precompile) {
                        return;
                    }
                    if (this.theServlet instanceof SingleThreadModel) {
                        JspServletWrapper jspServletWrapper = this;
                        synchronized (jspServletWrapper) {
                            this.theServlet.service((ServletRequest)request, (ServletResponse)response);
                            break block10;
                        }
                    }
                    this.theServlet.service((ServletRequest)request, (ServletResponse)response);
                }
                catch (FileNotFoundException ex) {
                    String includeRequestUri = (String)request.getAttribute("javax.servlet.include.request_uri");
                    if (includeRequestUri != null) {
                        throw new ServletException((Throwable)ex);
                    }
                    try {
                        response.sendError(404, ex.getMessage());
                    }
                    catch (IllegalStateException ise) {
                        Constants.jasperLog.log(Constants.getString((String)"jsp.error.file.not.found", (Object[])new Object[]{ex.getMessage()}), (Throwable)ex, 1);
                    }
                    return;
                }
            }
        }

        public void destroy() {
            if (this.theServlet != null) {
                this.theServlet.destroy();
            }
        }
    }
}

