/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import org.openide.awt.StatusDisplayer;
import org.openide.compiler.Compiler;
import org.openide.compiler.CompilerJob;
import org.openide.compiler.CompilerTask;
import org.openide.cookies.CompilerCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.util.enum.AlterEnumeration;
import org.openide.util.enum.ArrayEnumeration;
import org.openide.util.enum.FilterEnumeration;
import org.openide.util.enum.QueueEnumeration;
import org.openide.util.enum.SequenceEnumeration;

public abstract class AbstractCompileAction
extends NodeAction {
    static final long serialVersionUID = 5089785814030008824L;
    static /* synthetic */ Class class$org$openide$loaders$DataObject$Container;
    static /* synthetic */ Class class$org$openide$compiler$Compiler;
    static /* synthetic */ Class class$org$openide$cookies$CompilerCookie$Compile;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$openide$cookies$CompilerCookie;
    static /* synthetic */ Class class$org$openide$actions$AbstractCompileAction$Cmp;

    protected void performAction(Node[] activatedNodes) {
        this.compileNodes2(activatedNodes);
    }

    protected boolean enable(Node[] arr) {
        if (arr.length == 0) {
            return false;
        }
        Class cookie = this.cookie();
        Compiler.Depth depth = this.depth();
        int i = 0;
        while (i < arr.length) {
            CompilerCookie cc = (CompilerCookie)arr[i].getCookie(cookie);
            if (cc == null ? depth.isLastDepth() || arr[i].getCookie(class$org$openide$loaders$DataObject$Container == null ? AbstractCompileAction.class$("org.openide.loaders.DataObject$Container") : class$org$openide$loaders$DataObject$Container) == null : !cc.isDepthSupported(depth)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected abstract Compiler.Depth depth();

    protected abstract Class cookie();

    protected String message() {
        return NbBundle.getMessage((Class)(class$org$openide$compiler$Compiler == null ? (class$org$openide$compiler$Compiler = AbstractCompileAction.class$("org.openide.compiler.Compiler")) : class$org$openide$compiler$Compiler), (String)"CTL_CompilationStarted");
    }

    public static boolean compileDataObjects(DataObject[] objects) {
        HashSet<CompilerCookie> compile = new HashSet<CompilerCookie>();
        int i = 0;
        while (i < objects.length) {
            CompilerCookie comp = (CompilerCookie)objects[i].getCookie(class$org$openide$cookies$CompilerCookie$Compile == null ? AbstractCompileAction.class$("org.openide.cookies.CompilerCookie$Compile") : class$org$openide$cookies$CompilerCookie$Compile);
            if (comp != null) {
                compile.add(comp);
            }
            ++i;
        }
        return AbstractCompileAction.compile(Collections.enumeration(compile), AbstractCompileAction.findName(objects));
    }

    public static boolean compileNodes(Node[] nodes) {
        HashSet<CompilerCookie> compile = new HashSet<CompilerCookie>();
        int i = 0;
        while (i < nodes.length) {
            CompilerCookie comp = (CompilerCookie)nodes[i].getCookie(class$org$openide$cookies$CompilerCookie$Compile == null ? AbstractCompileAction.class$("org.openide.cookies.CompilerCookie$Compile") : class$org$openide$cookies$CompilerCookie$Compile);
            if (comp != null) {
                compile.add(comp);
            }
            ++i;
        }
        return AbstractCompileAction.compile(Collections.enumeration(compile), AbstractCompileAction.findName(nodes));
    }

    void compileNodes2(Node[] nodes) {
        boolean useNodes;
        DataObject[] objects;
        CompilerJob job;
        StatusDisplayer.getDefault().setStatusText(this.message());
        try {
            job = new CompilerJob(this.depth());
            AbstractCompileAction.prepareJobFor(job, (Enumeration)new ArrayEnumeration((Object[])nodes), this.cookie(), this.depth());
            objects = new DataObject[nodes.length];
            useNodes = false;
            int i = 0;
            while (i < nodes.length) {
                objects[i] = (DataObject)nodes[i].getCookie(class$org$openide$loaders$DataObject == null ? AbstractCompileAction.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                if (objects[i] == null) {
                    useNodes = true;
                    break;
                }
                ++i;
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            StatusDisplayer.getDefault().setStatusText("");
            throw throwable;
        }
        StatusDisplayer.getDefault().setStatusText("");
        job.setDisplayName(useNodes ? AbstractCompileAction.findName(nodes) : AbstractCompileAction.findName(objects));
        job.start();
    }

    static String findName(Node[] nodes) {
        String name = "";
        if (nodes.length > 0) {
            Node n = nodes[0];
            Node.Cookie ck = null;
            do {
                if ((ck = n.getCookie(class$org$openide$loaders$DataObject == null ? AbstractCompileAction.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject)) == null) continue;
                DataObject d = (DataObject)ck;
                name = d.isValid() ? d.getNodeDelegate().getDisplayName() : "";
                break;
            } while ((n = n.getParentNode()) != null);
        }
        return NbBundle.getMessage((Class)(class$org$openide$compiler$Compiler == null ? (class$org$openide$compiler$Compiler = AbstractCompileAction.class$("org.openide.compiler.Compiler")) : class$org$openide$compiler$Compiler), (String)"FMT_Compile", (Object)new Integer(nodes.length), (Object)name);
    }

    static String findName(DataObject[] dataObjects) {
        return NbBundle.getMessage((Class)(class$org$openide$compiler$Compiler == null ? (class$org$openide$compiler$Compiler = AbstractCompileAction.class$("org.openide.compiler.Compiler")) : class$org$openide$compiler$Compiler), (String)"FMT_Compile", (Object)new Integer(dataObjects.length), (Object)(dataObjects.length > 0 && dataObjects[0].isValid() ? dataObjects[0].getNodeDelegate().getDisplayName() : ""));
    }

    public static CompilerJob createJob(Enumeration en, Compiler.Depth depth) {
        CompilerJob job = new CompilerJob(depth);
        AbstractCompileAction.prepareJobFor(job, en, class$org$openide$cookies$CompilerCookie == null ? (class$org$openide$cookies$CompilerCookie = AbstractCompileAction.class$("org.openide.cookies.CompilerCookie")) : class$org$openide$cookies$CompilerCookie, depth, null);
        return job;
    }

    public static boolean compile(Enumeration compileCookies, String name) {
        CompilerJob job = AbstractCompileAction.createJob(compileCookies, Compiler.DEPTH_ZERO);
        job.setDisplayName(name);
        if (!job.isUpToDate()) {
            CompilerTask task = job.start();
            return task.isSuccessful();
        }
        return true;
    }

    private static Node.Cookie findCookie(DataObject o, Class cookie) {
        if (!(class$org$openide$cookies$CompilerCookie == null ? (class$org$openide$cookies$CompilerCookie = AbstractCompileAction.class$("org.openide.cookies.CompilerCookie")) : class$org$openide$cookies$CompilerCookie).isAssignableFrom(cookie)) {
            throw new ClassCastException(cookie.getName());
        }
        Node.Cookie c = o.getCookie(cookie);
        if (c != null) {
            return c;
        }
        if (!(o instanceof DataObject.Container)) {
            return null;
        }
        if (!cookie.isAssignableFrom(class$org$openide$actions$AbstractCompileAction$Cmp == null ? (class$org$openide$actions$AbstractCompileAction$Cmp = AbstractCompileAction.class$("org.openide.actions.AbstractCompileAction$Cmp")) : class$org$openide$actions$AbstractCompileAction$Cmp)) {
            return null;
        }
        return new Cmp((DataObject.Container)o, cookie);
    }

    private static Node.Cookie findCookie(Node n, Class cookie) {
        if (!(class$org$openide$cookies$CompilerCookie == null ? (class$org$openide$cookies$CompilerCookie = AbstractCompileAction.class$("org.openide.cookies.CompilerCookie")) : class$org$openide$cookies$CompilerCookie).isAssignableFrom(cookie)) {
            throw new ClassCastException(cookie.getName());
        }
        Node.Cookie c = n.getCookie(cookie);
        if (c != null) {
            return c;
        }
        DataObject o = (DataObject)n.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = AbstractCompileAction.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
        if (o == null) {
            return null;
        }
        return AbstractCompileAction.findCookie(o, cookie);
    }

    public static void prepareJobFor(CompilerJob job, Enumeration en, Class type, Compiler.Depth depth) {
        AbstractCompileAction.prepareJobFor(job, en, type, depth, null);
    }

    private static void prepareJobFor(CompilerJob job, Enumeration en, Class type, Compiler.Depth depth, Object forObj) {
        HashSet<Object> processsedObjects = new HashSet<Object>(37);
        if (forObj != null) {
            processsedObjects.add(forObj);
        }
        FilterEnumeration cookies = new FilterEnumeration(AbstractCompileAction.enumerateForDepth(type, en, depth, processsedObjects));
        while (cookies.hasMoreElements()) {
            CompilerCookie cc = (CompilerCookie)cookies.nextElement();
            cc.addToJob(job, depth);
        }
    }

    private static Enumeration enumerateForDepth(Class cookie, Enumeration nodesOrDataObjects, Compiler.Depth depth, HashSet processedObjects) {
        QueueEnumeration queue = new QueueEnumeration();
        queue.put((Object)AbstractCompileAction.processArray(nodesOrDataObjects, cookie, queue, depth, processedObjects));
        return new SequenceEnumeration((Enumeration)queue);
    }

    private static Enumeration processArray(Enumeration en, final Class cookie, final QueueEnumeration queue, final Compiler.Depth depth, final HashSet processsedObjects) {
        return new AlterEnumeration(en){

            public Object alter(Object o) {
                return AbstractCompileAction.processObject(o, cookie, queue, depth, processsedObjects);
            }
        };
    }

    private static CompilerCookie processObject(Object obj, Class cookie, QueueEnumeration queue, Compiler.Depth depth, HashSet processsedObjects) {
        DataObject.Container cont;
        Cmp fc;
        if (processsedObjects.contains(obj)) {
            return null;
        }
        CompilerCookie c = (CompilerCookie)AbstractCompileAction.resolveCookie(obj, cookie);
        if (c != obj) {
            processsedObjects.add(obj);
        }
        if (c instanceof Cmp && (fc = (Cmp)c).wasCreatedFor(obj)) {
            c = null;
        }
        if (c != null) {
            if (processsedObjects.contains(c)) {
                return null;
            }
            processsedObjects.add(c);
            return c;
        }
        if (!depth.isLastDepth() && (cont = (DataObject.Container)AbstractCompileAction.resolveCookie(obj, class$org$openide$loaders$DataObject$Container == null ? (class$org$openide$loaders$DataObject$Container = AbstractCompileAction.class$("org.openide.loaders.DataObject$Container")) : class$org$openide$loaders$DataObject$Container)) != null) {
            Object[] arr = cont.getChildren();
            ArrayEnumeration en = new ArrayEnumeration(arr);
            queue.put((Object)AbstractCompileAction.processArray((Enumeration)en, cookie, queue, depth.nextDepth(), processsedObjects));
        }
        return null;
    }

    private static Object resolveCookie(Object obj, Class cookie) {
        Object res = null;
        if (obj instanceof DataObject) {
            res = ((DataObject)obj).getCookie(cookie);
        } else if (obj instanceof Node) {
            res = ((Node)obj).getCookie(cookie);
        } else if (cookie.isInstance(obj)) {
            res = obj;
        }
        return res;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class Cmp
    implements CompilerCookie.Compile,
    CompilerCookie.Build,
    CompilerCookie.Clean {
        private DataObject.Container folder;
        private Class cookieClass;

        public Cmp(DataObject.Container folder, Class cookieClass) {
            this.folder = folder;
            this.cookieClass = cookieClass;
        }

        public boolean isDepthSupported(Compiler.Depth depth) {
            return true;
        }

        public void addToJob(CompilerJob job, Compiler.Depth depth) {
            if (depth.isLastDepth()) {
                return;
            }
            depth = depth.nextDepth();
            AbstractCompileAction.prepareJobFor(job, (Enumeration)new ArrayEnumeration((Object[])this.folder.getChildren()), this.cookieClass, depth, this);
        }

        boolean wasCreatedFor(Object obj) {
            if (obj == this.folder) {
                return true;
            }
            return obj == ((DataObject)this.folder).getNodeDelegate();
        }

        public int hashCode() {
            return this.folder.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof Cmp) {
                Cmp c = (Cmp)o;
                return c.wasCreatedFor(this.folder);
            }
            return false;
        }
    }
}

