/*
 * Decompiled with CFR 0.152.
 */
package org.openide.compiler;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import org.openide.ErrorManager;
import org.openide.compiler.Compiler;
import org.openide.compiler.CompilerJob;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

public class ExternalCompiler
extends Compiler {
    private static ResourceBundle bundle;
    static final String SUN_ERROR_EXPR = "^([^ ][^\n]+):([0-9]+): (.*)";
    static final String MICROSOFT_ERROR_EXPR = "^([^\\(]+)\\(([0-9]+),([0-9]+)\\) : (.*)";
    static final String JIKES_ERROR_EXPR = "^([^ ]+):([0-9]+):([0-9]+):[0-9]+:[0-9]+:( |.*\n^)(.*)";
    public static final ErrorExpression JAVAC;
    public static final ErrorExpression JVC;
    public static final ErrorExpression JIKES;
    public static final Object COMPILE;
    public static final Object BUILD;
    public static final Object CLEAN;
    protected static final String CLASS_EXTENSION = "class";
    private FNP fileNameProducer;
    private NbProcessDescriptor nbDescriptor;
    private ErrorExpression errorExpression;
    private Object type;
    static /* synthetic */ Class class$org$openide$cookies$CompilerCookie$Compile;
    static /* synthetic */ Class class$org$openide$cookies$CompilerCookie$Build;
    static /* synthetic */ Class class$org$openide$cookies$CompilerCookie$Clean;
    static /* synthetic */ Class class$org$openide$compiler$ExternalCompiler;
    static /* synthetic */ Class class$org$openide$compiler$ExternalCompilerGroup;

    public ExternalCompiler(FileObject fo, Object type, NbProcessDescriptor nbDescriptor, ErrorExpression err) {
        this.init(fo, type, nbDescriptor, err);
    }

    public ExternalCompiler(CompilerJob job, FileObject fo, Object type, NbProcessDescriptor nbDescriptor, ErrorExpression err) {
        this.init(fo, type, nbDescriptor, err);
        job.add(this);
        this.registerInJob(job);
    }

    public ExternalCompiler(Compiler[] dependencies, FileObject fo, Object type, NbProcessDescriptor nbDescriptor, ErrorExpression err) {
        this.init(fo, type, nbDescriptor, err);
        this.dependsOn(Arrays.asList(dependencies));
        this.registerInJob(dependencies[0]);
    }

    public ExternalCompiler(final File file, Object type, NbProcessDescriptor nbDescriptor, ErrorExpression err) {
        if (file == null || type != COMPILE && type != BUILD || nbDescriptor == null || err == null) {
            throw new IllegalArgumentException();
        }
        this.fileNameProducer = new FNP(){

            public String getFileName() {
                return file.toString();
            }

            public FileObject getFileObject() {
                return null;
            }

            public boolean equalTo(FNP fnp) {
                return fnp.equalToFile(file);
            }

            public boolean equalToFile(File f) {
                return file.equals(f);
            }

            public boolean equalToResource(String res) {
                return false;
            }

            public boolean equalToResourceAndFS(String res, FileSystem fs) {
                return false;
            }

            public boolean equalToFileObject(FileObject obj) {
                return false;
            }
        };
        this.nbDescriptor = nbDescriptor;
        this.errorExpression = err;
        this.type = type;
    }

    public ExternalCompiler(final FileSystem fs, final String resourceName, Object type, NbProcessDescriptor nbDescriptor, ErrorExpression err) {
        if (fs == null || resourceName == null || type != COMPILE && type != BUILD || nbDescriptor == null || err == null) {
            throw new IllegalArgumentException();
        }
        this.fileNameProducer = new FNP(){

            public String getFileName() {
                FileObject fo = fs.findResource(resourceName);
                if (fo == null) {
                    return "";
                }
                File f = FileUtil.toFile((FileObject)fo);
                if (f == null) {
                    return "";
                }
                return f.toString();
            }

            public FileObject getFileObject() {
                return fs.findResource(resourceName);
            }

            public boolean equalTo(FNP fnp) {
                return fnp.equalToResourceAndFS(resourceName, fs);
            }

            public boolean equalToFile(File f) {
                return false;
            }

            public boolean equalToResource(String res) {
                return false;
            }

            public boolean equalToResourceAndFS(String res, FileSystem fileSystem) {
                return fs.equals(fileSystem) && res.equals(resourceName);
            }

            public boolean equalToFileObject(FileObject obj) {
                return false;
            }
        };
        this.nbDescriptor = nbDescriptor;
        this.errorExpression = err;
        this.type = type;
    }

    public ExternalCompiler(final String resourceName, Object type, NbProcessDescriptor nbDescriptor, ErrorExpression err) {
        if (resourceName == null || type != COMPILE && type != BUILD || nbDescriptor == null || err == null) {
            throw new IllegalArgumentException();
        }
        this.fileNameProducer = new FNP(){

            public String getFileName() {
                FileObject fo = FileSystemCapability.ALL.findResource(resourceName);
                if (fo == null) {
                    return "";
                }
                File f = FileUtil.toFile((FileObject)fo);
                if (f == null) {
                    return "";
                }
                return f.toString();
            }

            public FileObject getFileObject() {
                return FileSystemCapability.ALL.findResource(resourceName);
            }

            public boolean equalTo(FNP fnp) {
                return fnp.equalToResource(resourceName);
            }

            public boolean equalToFile(File f) {
                return false;
            }

            public boolean equalToResource(String res) {
                return res.equals(resourceName);
            }

            public boolean equalToResourceAndFS(String res, FileSystem fs) {
                return false;
            }

            public boolean equalToFileObject(FileObject obj) {
                return false;
            }
        };
        this.nbDescriptor = nbDescriptor;
        this.errorExpression = err;
        this.type = type;
    }

    private void init(final FileObject fo, Object type, NbProcessDescriptor nbDescriptor, ErrorExpression err) {
        if (fo == null || type != COMPILE && type != BUILD || nbDescriptor == null || err == null) {
            throw new IllegalArgumentException();
        }
        final File myFile = FileUtil.toFile((FileObject)fo);
        if (myFile == null) {
            IllegalArgumentException iae = new IllegalArgumentException("no such java.io.File: " + fo);
            ErrorManager em = ErrorManager.getDefault();
            try {
                em.annotate((Throwable)iae, NbBundle.getMessage((Class)(class$org$openide$compiler$ExternalCompiler == null ? (class$org$openide$compiler$ExternalCompiler = ExternalCompiler.class$("org.openide.compiler.ExternalCompiler")) : class$org$openide$compiler$ExternalCompiler), (String)"EXC_no_such_java_io_File", (Object)fo.getPath(), (Object)fo.getFileSystem().getDisplayName()));
                try {
                    fo.getInputStream().close();
                }
                catch (IOException ioe) {
                    em.annotate((Throwable)iae, (Throwable)ioe);
                }
            }
            catch (FileStateInvalidException fsie) {
                em.annotate((Throwable)iae, (Throwable)fsie);
            }
            throw iae;
        }
        this.fileNameProducer = new FNP(){

            public String getFileName() {
                return myFile.toString();
            }

            public FileObject getFileObject() {
                return fo;
            }

            public boolean equalTo(FNP fnp) {
                return fnp.equalToFileObject(fo);
            }

            public boolean equalToFile(File f) {
                return false;
            }

            public boolean equalToResource(String res) {
                return false;
            }

            public boolean equalToResourceAndFS(String res, FileSystem fs) {
                return false;
            }

            public boolean equalToFileObject(FileObject obj) {
                return obj.equals(fo);
            }
        };
        this.nbDescriptor = nbDescriptor;
        this.errorExpression = err;
        this.type = type;
    }

    public final NbProcessDescriptor getCompilerDescriptor() {
        return this.nbDescriptor;
    }

    public final ErrorExpression getErrorExpression() {
        return this.errorExpression;
    }

    protected final FileObject getFileObject() {
        return this.fileNameProducer.getFileObject();
    }

    public String getFileName() {
        return this.fileNameProducer.getFileName();
    }

    private static boolean isUpToDate(FileObject fo, Date[] dates) {
        try {
            DataObject dataobj = DataObject.find((FileObject)fo);
            Set files = dataobj.files();
            Iterator iter = files.iterator();
            int classfilescount = 0;
            while (iter.hasNext()) {
                FileObject clsfo = (FileObject)iter.next();
                if (!clsfo.getExt().equals(CLASS_EXTENSION)) continue;
                ++classfilescount;
                if (dates != null) {
                    dates[0] = clsfo.lastModified();
                }
                if (clsfo.lastModified().compareTo(fo.lastModified()) >= 0) continue;
                return false;
            }
            return classfilescount != 0;
        }
        catch (DataObjectNotFoundException e) {
            return false;
        }
    }

    protected boolean isUpToDate() {
        if (this.type == BUILD) {
            return false;
        }
        FileObject fo = this.getFileObject();
        return fo == null || ExternalCompiler.isUpToDate(fo, null);
    }

    protected Date getTimeStamp() {
        if (this.type == BUILD) {
            return null;
        }
        FileObject fo = this.getFileObject();
        if (fo == null) {
            return null;
        }
        Date[] dates = new Date[1];
        ExternalCompiler.isUpToDate(fo, dates);
        return dates[0];
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName());
        sb.append(" for ");
        sb.append(this.getFileName());
        sb.append(" ");
        if (this.type == COMPILE) {
            sb.append("COMPILE");
        } else {
            sb.append("BUILD");
        }
        return sb.toString();
    }

    public Class compilerGroupClass() {
        return class$org$openide$compiler$ExternalCompilerGroup == null ? (class$org$openide$compiler$ExternalCompilerGroup = ExternalCompiler.class$("org.openide.compiler.ExternalCompilerGroup")) : class$org$openide$compiler$ExternalCompilerGroup;
    }

    protected Object compilerType() {
        return this.nbDescriptor;
    }

    public Object compilerGroupKey() {
        ArrayList<Object> l = new ArrayList<Object>(3);
        l.add(super.compilerGroupKey());
        l.add(this.compilerType());
        l.add(this.errorExpression);
        return l;
    }

    public boolean equals(Object o) {
        if (o instanceof ExternalCompiler) {
            ExternalCompiler c = (ExternalCompiler)o;
            return this.fileNameProducer.equalTo(c.fileNameProducer) && this.compilerGroupKey().equals(c.compilerGroupKey());
        }
        return false;
    }

    public int hashCode() {
        String fn = this.getFileName();
        return fn == null ? 0 : fn.hashCode();
    }

    static String getLocalizedString(String s) {
        if (bundle == null) {
            bundle = NbBundle.getBundle((Class)(class$org$openide$compiler$ExternalCompiler == null ? (class$org$openide$compiler$ExternalCompiler = ExternalCompiler.class$("org.openide.compiler.ExternalCompiler")) : class$org$openide$compiler$ExternalCompiler));
        }
        return bundle.getString(s);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        JAVAC = new ErrorExpression("CTL_Sun", SUN_ERROR_EXPR, 1, 2, -1, 3, false);
        JVC = new ErrorExpression("CTL_Microsoft", MICROSOFT_ERROR_EXPR, 1, 2, 3, 4, false);
        JIKES = new ErrorExpression("CTL_Jikes", JIKES_ERROR_EXPR, 1, 2, 3, 5, false);
        COMPILE = class$org$openide$cookies$CompilerCookie$Compile == null ? (class$org$openide$cookies$CompilerCookie$Compile = ExternalCompiler.class$("org.openide.cookies.CompilerCookie$Compile")) : class$org$openide$cookies$CompilerCookie$Compile;
        BUILD = class$org$openide$cookies$CompilerCookie$Build == null ? (class$org$openide$cookies$CompilerCookie$Build = ExternalCompiler.class$("org.openide.cookies.CompilerCookie$Build")) : class$org$openide$cookies$CompilerCookie$Build;
        CLEAN = class$org$openide$cookies$CompilerCookie$Clean == null ? (class$org$openide$cookies$CompilerCookie$Clean = ExternalCompiler.class$("org.openide.cookies.CompilerCookie$Clean")) : class$org$openide$cookies$CompilerCookie$Clean;
    }

    static interface FNP {
        public String getFileName();

        public FileObject getFileObject();

        public boolean equalTo(FNP var1);

        public boolean equalToFile(File var1);

        public boolean equalToResource(String var1);

        public boolean equalToResourceAndFS(String var1, FileSystem var2);

        public boolean equalToFileObject(FileObject var1);
    }

    public static class ErrorExpression
    implements Serializable,
    Cloneable {
        private String name;
        private String errordesc;
        private int filepos;
        private int linepos;
        private int columnpos;
        private int descpos;
        private boolean resolved;
        static final long serialVersionUID = -2647801563993403964L;

        public ErrorExpression(String name, String errordesc, int filepos, int linepos, int columnpos, int descpos) {
            this(name, errordesc, filepos, linepos, columnpos, descpos, true);
        }

        ErrorExpression(String name, String errordesc, int filepos, int linepos, int columnpos, int descpos, boolean resolved) {
            this.name = name;
            this.errordesc = errordesc;
            this.filepos = filepos;
            this.linepos = linepos;
            this.columnpos = columnpos;
            this.descpos = descpos;
            this.resolved = resolved;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
        }

        public String getName() {
            if (!this.resolved) {
                this.name = ExternalCompiler.getLocalizedString(this.name);
                this.resolved = true;
            }
            return this.name;
        }

        public void setName(String d) {
            this.name = d;
        }

        public String getErrorExpression() {
            return this.errordesc;
        }

        public void setErrorExpression(String s) {
            this.errordesc = s;
        }

        public int getFilePos() {
            return this.filepos;
        }

        public void setFilePos(int i) {
            this.filepos = i;
        }

        public int getLinePos() {
            return this.linepos;
        }

        public void setLinePos(int i) {
            this.linepos = i;
        }

        public int getColumnPos() {
            return this.columnpos;
        }

        public void setColumnPos(int i) {
            this.columnpos = i;
        }

        public int getDescriptionPos() {
            return this.descpos;
        }

        public void setDescriptionPos(int i) {
            this.descpos = i;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof ErrorExpression)) {
                return false;
            }
            ErrorExpression him = (ErrorExpression)o;
            return this.getName().equals(him.getName()) && this.errordesc.equals(him.errordesc) && this.filepos == him.filepos && this.linepos == him.linepos && this.columnpos == him.columnpos && this.descpos == him.descpos;
        }

        public int hashCode() {
            return this.getName().hashCode();
        }
    }
}

