/*
 * Decompiled with CFR 0.152.
 */
package org.openide.compiler;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.regexp.CharacterIterator;
import org.apache.regexp.RE;
import org.apache.regexp.RECompiler;
import org.apache.regexp.REProgram;
import org.apache.regexp.RESyntaxException;
import org.apache.regexp.ReaderCharacterIterator;
import org.openide.ErrorManager;
import org.openide.compiler.Compiler;
import org.openide.compiler.CompilerExecutor;
import org.openide.compiler.CompilerGroup;
import org.openide.compiler.ErrorEvent;
import org.openide.compiler.ExternalCompiler;
import org.openide.compiler.IdSet;
import org.openide.execution.NbClassPath;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.EnvironmentNotSupportedException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ExternalCompilerGroup
extends CompilerGroup {
    private static final String META_CHARACTERS = "\\[](){}^$.|?*+";
    private static final char ESCAPE_CHAR = '\\';
    private Set compilers = new IdSet();
    private boolean dirty;
    private RE clsPath;
    static /* synthetic */ Class class$org$openide$compiler$ExternalCompilerType;

    public void add(Compiler c) throws IllegalArgumentException {
        if (!(c instanceof ExternalCompiler)) {
            throw new IllegalArgumentException();
        }
        this.compilers.add(c);
    }

    protected Process createProcess(NbProcessDescriptor desc, String[] files, Object compilerType) throws IOException {
        return this.createProcess(desc, files);
    }

    protected Process createProcess(NbProcessDescriptor desc, String[] files) throws IOException {
        return desc.exec((java.text.Format)((Object)new Format(files)));
    }

    protected Process createProcess(NbProcessDescriptor desc, String[] files, File cwd) throws IOException {
        return desc.exec((java.text.Format)((Object)new Format(files)), null, cwd);
    }

    protected String getStatusLineText() {
        FileObject fo;
        if (this.compilers.size() == 1 && (fo = this.getAllCompilers()[0].getFileObject()) != null) {
            String msg = MessageFormat.format(ExternalCompilerGroup.getString("CTL_FMT_CompilingMessage"), fo.getPath());
            return msg;
        }
        return ExternalCompilerGroup.getString("FMT_GenericCompilingMessage");
    }

    protected final ExternalCompiler[] getAllCompilers() {
        return this.compilers.toArray(new ExternalCompiler[this.compilers.size()]);
    }

    void fireErrEvent(ErrorEvent ev, boolean isWarning) {
        if (ev.getFile() != null && !isWarning) {
            this.dirty = true;
        }
        this.fireErrorEvent(ev);
    }

    protected Collection filterCompilers(Collection allCompilers) {
        HashMap<ExternalCompiler, ExternalCompiler> compilerMap = new HashMap<ExternalCompiler, ExternalCompiler>(allCompilers.size() * 4 / 3);
        Iterator it = allCompilers.iterator();
        while (it.hasNext()) {
            ExternalCompiler comp1 = (ExternalCompiler)it.next();
            ExternalCompiler comp2 = compilerMap.put(comp1, comp1);
            if (comp2 == null || comp1 == comp2 || comp2.isUpToDate() || !comp1.isUpToDate()) continue;
            compilerMap.put(comp1, comp2);
        }
        return compilerMap.values();
    }

    public boolean start() {
        this.dirty = false;
        if (this.compilers.isEmpty()) {
            return true;
        }
        CompilerExecutor cexec = null;
        HashSet<FileObject> folders = new HashSet<FileObject>(7);
        Iterator it = this.filterCompilers(this.compilers).iterator();
        while (it.hasNext()) {
            FileObject folder;
            String name;
            ExternalCompiler c = (ExternalCompiler)it.next();
            if (cexec == null) {
                cexec = new CompilerExecutor(this, c.getCompilerDescriptor(), c.getErrorExpression(), c.compilerType());
            }
            if ((name = c.getFileName()) != null && !"".equals(name)) {
                cexec.addFile(name);
            }
            if ((folder = c.getFileObject()) == null) continue;
            if (folder.isData()) {
                folder = folder.getParent();
            }
            folders.add(folder);
        }
        try {
            int result = cexec.execute(null).result();
            this.dirty |= result != 0;
            if (!this.dirty) {
                it = folders.iterator();
                while (it.hasNext()) {
                    this.refreshPackage((FileObject)it.next());
                }
            }
            if (result == 97943) {
                ErrorEvent ev = new ErrorEvent(this, null, -1, -1, ExternalCompilerGroup.getString("CTL_Interrupted"), "");
                this.fireErrorEvent(ev);
            }
        }
        catch (IOException ioe) {
            StringWriter swriter = new StringWriter();
            PrintWriter pw = new PrintWriter(swriter);
            ioe.printStackTrace(pw);
            this.fireErrorEvent(new ErrorEvent(this, null, 0, 0, swriter.toString(), ""));
            this.dirty = true;
        }
        return !this.dirty;
    }

    private void refreshPackage(FileObject pfile) {
        pfile.refresh();
        FileObject[] contents = pfile.getChildren();
        int i = 0;
        while (i < contents.length) {
            FileObject f = contents[i];
            if ("class".equals(f.getExt())) {
                f.refresh();
            }
            ++i;
        }
    }

    private static String getString(String x) {
        return NbBundle.getMessage((Class)(class$org$openide$compiler$ExternalCompilerType == null ? (class$org$openide$compiler$ExternalCompilerType = ExternalCompilerGroup.class$("org.openide.compiler.ExternalCompilerType")) : class$org$openide$compiler$ExternalCompilerType), (String)x);
    }

    protected void parseErrors(ExternalCompiler.ErrorExpression err, Reader parsedReader) {
        RE errorPattern = ExternalCompilerGroup.getErrorPattern(err);
        ReaderCharacterIterator chi = new ReaderCharacterIterator(parsedReader);
        int idx = 0;
        while (errorPattern.match((CharacterIterator)chi, idx)) {
            String sg;
            int column;
            int line;
            if (err.getFilePos() < 0) {
                return;
            }
            int lowerBound = 0;
            int upperBound = errorPattern.getParenCount() - 1;
            String file = errorPattern.getParen(err.getFilePos());
            if (err.getLinePos() < lowerBound || err.getLinePos() > upperBound) {
                line = 1;
            } else {
                try {
                    line = Integer.parseInt(errorPattern.getParen(err.getLinePos()));
                }
                catch (NumberFormatException ex) {
                    line = 1;
                }
            }
            if (err.getColumnPos() < lowerBound || err.getColumnPos() > upperBound) {
                column = 1;
            } else {
                try {
                    column = Integer.parseInt(errorPattern.getParen(err.getColumnPos()));
                }
                catch (NumberFormatException ex) {
                    column = 1;
                }
            }
            String msg = err.getDescriptionPos() < lowerBound || err.getDescriptionPos() > upperBound ? "" : ((sg = errorPattern.getParen(err.getDescriptionPos())) == null ? "" : sg.trim());
            String refText = "";
            String rst = chi.substring(idx, errorPattern.getParenStart(0));
            if (!rst.equals("")) {
                this.notifyError(null, -1, -1, ExternalCompilerGroup.trimString(rst), null);
            }
            this.notifyError(file != null ? file.trim() : null, line, column, msg, refText);
            idx = errorPattern.getParenEnd(0);
        }
        String rst = chi.substring(idx);
        if (!rst.equals("")) {
            this.notifyError(null, 0, 0, ExternalCompilerGroup.trimString(rst), null);
        }
    }

    private static String trimString(String s) {
        char c;
        int idx = 0;
        int slen = s.length();
        if (slen == 0) {
            return s;
        }
        while (((c = s.charAt(idx++)) == '\n' || c == '\r') && idx < slen) {
        }
        --idx;
        if ((idx = (s = s.substring(idx)).length() - 1) < 0) {
            return s;
        }
        while (((c = s.charAt(idx--)) == '\n' || c == '\r') && idx >= 0) {
        }
        return s.substring(0, idx + 2);
    }

    protected void notifyError(String file, int line, int column, String message, String ref) {
        String warning = ExternalCompilerGroup.getString("FMT_Warning");
        boolean isWarning = message.toLowerCase().indexOf(warning) >= 0;
        FileObject fo = null;
        if (file != null) {
            fo = this.string2File(file);
            if (fo == null) {
                Object[] args = new Object[]{file.replace(File.separatorChar, '/'), new Integer(line), new Integer(column), message};
                message = ExternalCompilerGroup.getUnknownFile().format(args);
            }
        } else if (message.equals("")) {
            return;
        }
        ErrorEvent ev = new ErrorEvent(this, fo, line, column, message, ref);
        this.fireErrEvent(ev, isWarning);
    }

    private RE getClassPathEntries() {
        if (this.clsPath == null) {
            String repPath = NbClassPath.createRepositoryPath((FileSystemCapability)FileSystemCapability.COMPILE).getClassPath();
            if (repPath.charAt(0) == '\"') {
                repPath = repPath.substring(1, repPath.length() - 1);
            }
            try {
                RECompiler rec = new RECompiler();
                REProgram rep = rec.compile(ExternalCompilerGroup.sortAndMakeOr(ExternalCompilerGroup.escapeMetaCharacters(repPath)));
                this.clsPath = new RE(rep);
            }
            catch (RESyntaxException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        return this.clsPath;
    }

    private static RE getErrorPattern(ExternalCompiler.ErrorExpression err) {
        String regexp = err.getErrorExpression();
        try {
            RECompiler rec = new RECompiler();
            REProgram rep = rec.compile(regexp);
            RE errRE = new RE(rep, 2);
            return errRE;
        }
        catch (RESyntaxException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return null;
        }
    }

    static String sortAndMakeOr(String path) {
        int len = path.length() - 1;
        while (path.charAt(len--) == File.pathSeparatorChar) {
        }
        path = path.substring(0, len + 2);
        ArrayList<String> list = new ArrayList<String>(10);
        StringTokenizer stok = new StringTokenizer(path, File.pathSeparator);
        while (stok.hasMoreTokens()) {
            list.add(stok.nextToken());
        }
        if (list.size() > 0) {
            String[] a = new String[list.size()];
            a = list.toArray(a);
            Arrays.sort(a, new StringComparator());
            StringBuffer sb = new StringBuffer(300);
            int i = a.length - 1;
            while (i > 0) {
                sb.append(a[i]);
                sb.append('|');
                --i;
            }
            sb.append(a[0]);
            return sb.toString();
        }
        return path;
    }

    private static boolean isMetaCharacter(char c) {
        return META_CHARACTERS.indexOf(c) >= 0;
    }

    private static String escapeMetaCharacters(String s) {
        if (META_CHARACTERS.indexOf(File.pathSeparatorChar) != -1) {
            throw new IllegalStateException("org.openide.compiler.ErrorsParsingThread must be patched for this operating system");
        }
        StringBuffer buf = new StringBuffer(Math.max(1, s.length() * 2));
        int len = s.length();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (ExternalCompilerGroup.isMetaCharacter(c)) {
                buf.append('\\');
            }
            buf.append(c);
            ++i;
        }
        return buf.toString();
    }

    private FileObject string2File(String ffile) {
        ffile = ffile.replace('/', File.separatorChar);
        if (this.getClassPathEntries().match(ffile)) {
            String tmp = ffile.substring(this.getClassPathEntries().getParen(0).length());
            tmp = tmp.replace('\\', '/');
            Enumeration res = FileSystemCapability.COMPILE.findAllResources(tmp);
            FileObject first = null;
            String matchedEntry = ffile.substring(0, this.getClassPathEntries().getParen(0).length());
            try {
                OneItemEnv env = new OneItemEnv();
                while (res.hasMoreElements()) {
                    FileObject tmpfo = (FileObject)res.nextElement();
                    tmpfo.getFileSystem().prepareEnvironment((FileSystem.Environment)env);
                    String sysname = env.getClassPathEntry();
                    if (sysname.equals(matchedEntry)) {
                        return tmpfo;
                    }
                    if (first != null) continue;
                    first = tmpfo;
                }
            }
            catch (FileStateInvalidException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            catch (EnvironmentNotSupportedException e) {
                ErrorManager.getDefault().notify(4096, (Throwable)e);
            }
            return first;
        }
        return null;
    }

    private static MessageFormat getUnknownFile() {
        return new MessageFormat(ExternalCompiler.getLocalizedString("MSG_Unknown_file"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Format
    extends MapFormat {
        public static final String TAG_CLASSPATH = "classpath";
        public static final String TAG_BOOTCLASSPATH = "bootclasspath";
        public static final String TAG_REPOSITORY = "filesystems";
        public static final String TAG_LIBRARY = "library";
        public static final String TAG_FILES = "files";
        public static final String TAG_JAVAHOME = "java.home";
        public static final String TAG_JDKHOME = "jdk.home";
        public static final String TAG_SEPARATOR = "/";
        public static final String TAG_PATHSEPARATOR = ":";
        static final long serialVersionUID = -8630048144603405233L;
        static final int DEFAULT_FILELIST_THRESHOLD = 2048;
        static final String SYSPROP_FILELIST_THRESHOLD = "org.openide.compilers.filelistThreshold";
        private static final String PREFIX = "compilerparams";
        private static final String SUFFIX = ".pms";

        public Format(String[] files) {
            this(files, NbClassPath.createClassPath(), NbClassPath.createBootClassPath(), NbClassPath.createRepositoryPath((FileSystemCapability)FileSystemCapability.COMPILE), NbClassPath.createLibraryPath());
        }

        public Format(String[] files, NbClassPath classPath, NbClassPath bootClassPath, NbClassPath repository, NbClassPath library) {
            super((Map)Format.createMap7());
            Map map = this.getMap();
            map.put(TAG_CLASSPATH, classPath.getClassPath());
            map.put(TAG_BOOTCLASSPATH, bootClassPath.getClassPath());
            map.put(TAG_REPOSITORY, repository.getClassPath());
            map.put(TAG_LIBRARY, library.getClassPath());
            map.put(TAG_FILES, Format.asParameterString(files));
            map.put(TAG_JAVAHOME, System.getProperty(TAG_JAVAHOME));
            map.put(TAG_JDKHOME, System.getProperty(TAG_JDKHOME));
            map.put(TAG_SEPARATOR, File.separator);
            map.put(TAG_PATHSEPARATOR, File.pathSeparator);
        }

        public static String asParameterString(String[] files) {
            boolean vms = false;
            int nameThreshold = Integer.getInteger(SYSPROP_FILELIST_THRESHOLD, 2048);
            String filesValue = null;
            if (files.length > 10 && Utilities.isWindows() || (vms = Utilities.getOperatingSystem() == 8192) || (filesValue = Format.constructString(files, nameThreshold)) == null) {
                try {
                    boolean space;
                    File f = Format.constructFile(files, !vms);
                    StringBuffer sb = new StringBuffer(50);
                    String fname = f.toString();
                    boolean bl = space = fname.indexOf(32) >= 0;
                    if (space) {
                        sb.append('\"');
                    }
                    sb.append('@');
                    sb.append(fname);
                    if (space) {
                        sb.append('\"');
                    }
                    return sb.toString();
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify(4096, (Throwable)e);
                    return null;
                }
            }
            return filesValue;
        }

        private static HashMap createMap7() {
            return new HashMap(7);
        }

        /*
         * WARNING - void declaration
         */
        private static File constructFile(String[] files, boolean escape) throws IOException {
            File f = File.createTempFile(PREFIX, SUFFIX);
            f.deleteOnExit();
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(new FileOutputStream(f)));
            int i = 0;
            while (i < files.length) {
                String file = files[i];
                if (escape && file.indexOf(32) > -1) {
                    int pos;
                    StringBuffer sb = new StringBuffer();
                    sb.append('\"');
                    char[] content = file.toCharArray();
                    int lastPos = 0;
                    while ((pos = file.indexOf(92, lastPos)) > -1) {
                        void var8_8;
                        sb.append(content, lastPos, (int)(var8_8 - lastPos + true));
                        sb.append('\\');
                        lastPos = var8_8 + true;
                    }
                    if (lastPos < file.length()) {
                        sb.append(content, lastPos, file.length() - lastPos);
                    }
                    sb.append('\"');
                    file = sb.toString();
                }
                pw.println(file);
                ++i;
            }
            pw.close();
            return f;
        }

        private static String constructString(String[] files, int nameThreshold) {
            StringBuffer sb = new StringBuffer();
            String add = "";
            int i = 0;
            while (i < files.length) {
                sb.append(add);
                if (files[i].indexOf(32) >= 0) {
                    sb.append("\"");
                    sb.append(files[i]);
                    sb.append("\"");
                } else {
                    sb.append(files[i]);
                }
                add = " ";
                if (sb.length() > nameThreshold) {
                    return null;
                }
                ++i;
            }
            return sb.toString();
        }
    }

    static final class OneItemEnv
    extends FileSystem.Environment {
        String classPathEntry;

        OneItemEnv() {
        }

        public void addClassPath(String s) {
            this.classPathEntry = s;
        }

        public String getClassPathEntry() {
            return this.classPathEntry;
        }
    }

    static final class StringComparator
    implements Comparator {
        StringComparator() {
        }

        public int compare(Object o1, Object o2) {
            return o1.toString().length() - o2.toString().length();
        }
    }
}

