/*
 * Decompiled with CFR 0.152.
 */
package org.openide.compiler;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.openide.compiler.Compilable;
import org.openide.compiler.Compiler;
import org.openide.compiler.DependencyException;
import org.openide.compiler.IdSet;
import org.openide.util.enum.QueueEnumeration;

final class Graph {
    private HashMap vertex = new HashMap(31);
    private List levels;

    public Graph(Compilable c) {
        Enumeration en = Graph.compilables(c);
        while (en.hasMoreElements()) {
            Compilable com = (Compilable)en.nextElement();
            Vertex v = (Vertex)this.vertex.get(com);
            if (v == null) {
                v = new Vertex();
                this.vertex.put(com, v);
            }
            v.add(com);
        }
        this.addDeps();
    }

    public boolean isUpToDate(Date date) {
        Iterator it = this.vertex.values().iterator();
        while (it.hasNext()) {
            Vertex v = (Vertex)it.next();
            if (v.isUpToDate(date)) continue;
            return false;
        }
        return true;
    }

    public synchronized List getLevels() throws DependencyException {
        if (this.levels != null) {
            return this.levels;
        }
        List cycle = this.depth();
        if (cycle == null) {
            return this.levels;
        }
        ListIterator it = cycle.listIterator();
        while (it.hasNext()) {
            Vertex v = (Vertex)it.next();
            it.set(v.compilables.iterator().next());
        }
        Compilable[] arr = new Compilable[cycle.size()];
        cycle.toArray(arr);
        throw new DependencyException(arr);
    }

    private void addDeps() {
        Iterator it = this.vertex.values().iterator();
        while (it.hasNext()) {
            Vertex v = (Vertex)it.next();
            this.addDeps(v);
        }
    }

    private void addDeps(Vertex v) {
        Iterator it = v.compilables.iterator();
        while (it.hasNext()) {
            Compilable c = (Compilable)it.next();
            Iterator di = c.dependsOn().iterator();
            while (di.hasNext()) {
                Compilable dc = (Compilable)di.next();
                this.addCompilerDep(null, c.compilers(), dc.compilers());
            }
            this.addCompilerDep(v, c.compilers(), null);
        }
    }

    private void addCompilerDep(Vertex compOwner, Collection col, Collection col2) {
        Iterator it = col.iterator();
        while (it.hasNext()) {
            Compiler c = (Compiler)it.next();
            Vertex cv = (Vertex)this.vertex.get(c);
            if (col2 != null) {
                Iterator it2 = col2.iterator();
                while (it2.hasNext()) {
                    Vertex v = (Vertex)this.vertex.get(it2.next());
                    if (v == cv) continue;
                    cv.addDep(v);
                }
            }
            if (compOwner == null || compOwner == cv) continue;
            compOwner.addDep(cv);
        }
    }

    private List depth() {
        Iterator it = this.vertex.values().iterator();
        int max = -1;
        while (it.hasNext()) {
            Vertex v = (Vertex)it.next();
            if (v.depth > 0) continue;
            LinkedList cycle = Graph.computeDepth(v);
            if (cycle != null) {
                return cycle;
            }
            if (v.depth <= max) continue;
            max = v.depth;
        }
        Set[] arr = new Set[max];
        it = this.vertex.values().iterator();
        while (it.hasNext()) {
            Vertex v = (Vertex)it.next();
            int indx = v.depth - 1;
            if (arr[indx] == null) {
                arr[indx] = new IdSet();
            }
            Graph.addCompilersFrom(arr[indx], v.compilables);
        }
        this.levels = Arrays.asList(arr);
        return null;
    }

    private static void addCompilersFrom(Collection compilers, Collection compilables) {
        Iterator it = compilables.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof Compiler)) continue;
            compilers.add(o);
        }
    }

    private static LinkedList computeDepth(Vertex v) {
        if (v.dependsOn == null) {
            v.depth = 1;
            return null;
        }
        if (v.depth == -1) {
            LinkedList<Vertex> ll = new LinkedList<Vertex>();
            ll.add(v);
            return ll;
        }
        v.depth = -1;
        int max = -1;
        Iterator it = v.dependsOn.iterator();
        while (it.hasNext()) {
            Vertex child = (Vertex)it.next();
            LinkedList ll = Graph.computeDepth(child);
            if (ll != null) {
                if (ll.size() == 1 || ll.getFirst() != ll.getLast()) {
                    ll.add(v);
                }
                return ll;
            }
            if (child.depth <= max) continue;
            max = child.depth;
        }
        v.depth = max == -1 || v.anyCompiler() != null ? max + 1 : max;
        return null;
    }

    private static Enumeration compilables(Compilable c) {
        QueueEnumeration en = new QueueEnumeration(){
            private IdSet set = new IdSet();

            public void process(Object o) {
                Compilable comp = (Compilable)o;
                this.set.add(comp);
                LinkedList ll = new LinkedList(comp.compilers());
                ll.addAll(comp.dependsOn());
                ll.removeAll(this.set);
                this.put(ll.toArray());
            }
        };
        en.put((Object)c);
        return en;
    }

    private static final class Vertex {
        public Collection compilables = new IdSet();
        public Collection dependsOn;
        public int depth;
        private static int count;
        private int cnt = ++count;

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("Vertex ");
            sb.append(this.cnt);
            sb.append(" (");
            sb.append(this.compilables);
            sb.append(", ");
            if (this.dependsOn == null) {
                sb.append("null, ");
            } else {
                sb.append("{");
                Iterator it = this.dependsOn.iterator();
                Vertex v = (Vertex)it.next();
                sb.append(v.cnt);
                while (it.hasNext()) {
                    sb.append(", ");
                    Vertex vx = (Vertex)it.next();
                    sb.append(vx.cnt);
                }
                sb.append("}, ");
            }
            sb.append(this.depth);
            sb.append(")");
            return sb.toString();
        }

        public void add(Compilable c) {
            this.compilables.add(c);
        }

        public void addDep(Vertex v) {
            if (this.dependsOn == null) {
                this.dependsOn = new IdSet();
            }
            this.dependsOn.add(v);
        }

        public Compiler anyCompiler() {
            Iterator it = this.compilables.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof Compiler)) continue;
                return (Compiler)o;
            }
            return null;
        }

        public boolean isUpToDate(Date date) {
            Iterator it = this.compilables.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof Compiler)) continue;
                Compiler c = (Compiler)o;
                if (!c.isUpToDate()) {
                    return false;
                }
                if (date == null || c.getTimeStamp() != null && c.getTimeStamp().compareTo(date) <= 0) continue;
                return false;
            }
            return true;
        }
    }
}

