/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import org.openide.ServiceType;
import org.openide.actions.AbstractCompileAction;
import org.openide.compiler.Compiler;
import org.openide.compiler.CompilerJob;
import org.openide.compiler.CompilerType;
import org.openide.cookies.CompilerCookie;
import org.openide.loaders.DataObject;
import org.openide.loaders.Environment;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class CompilerSupport
implements CompilerCookie {
    private static final String EA_COMPILER_MANAGER = "NetBeansAttrDataObjectCompilerManager";
    public static final String PROP_COMPILER_TYPE = "compiler";
    private MultiDataObject.Entry entry;
    private Class cookie;
    private static final String READONLY_ATTRIBUTES = "readOnlyAttrs";
    static /* synthetic */ Class class$org$openide$compiler$CompilerType;
    static /* synthetic */ Class class$org$openide$compiler$Compiler;

    protected CompilerSupport(MultiDataObject.Entry entry, Class cookie) {
        this.entry = entry;
        this.cookie = cookie;
    }

    public boolean isDepthSupported(Compiler.Depth depth) {
        return Compiler.DEPTH_ONE == depth;
    }

    public void addToJob(CompilerJob job, Compiler.Depth depth) {
        CompilerType comp = CompilerSupport.getCompilerType(this.entry);
        if (comp == null) {
            comp = this.defaultCompilerType();
        }
        if (comp == null) {
            throw new IllegalStateException(this.getClass().getName() + ".defaultCompilerType returned null");
        }
        comp.prepareJob(job, this.cookie, (DataObject)this.entry.getDataObject());
    }

    protected CompilerType defaultCompilerType() {
        return CompilerType.getDefault();
    }

    public static void setCompilerType(MultiDataObject.Entry entry, CompilerType man) throws IOException {
        entry.getFile().setAttribute(EA_COMPILER_MANAGER, (Object)(man == null ? null : new ServiceType.Handle((ServiceType)man)));
    }

    public static CompilerType getCompilerType(MultiDataObject.Entry entry) {
        Object man = entry.getFile().getAttribute(EA_COMPILER_MANAGER);
        if (man == null || !(man instanceof ServiceType.Handle)) {
            return null;
        }
        ServiceType type = ((ServiceType.Handle)man).getServiceType();
        if (type instanceof CompilerType) {
            return (CompilerType)type;
        }
        Lookup l = Environment.find((DataObject)entry.getDataObject());
        return (CompilerType)((Object)l.lookup(class$org$openide$compiler$CompilerType == null ? (class$org$openide$compiler$CompilerType = CompilerSupport.class$("org.openide.compiler.CompilerType")) : class$org$openide$compiler$CompilerType));
    }

    public void addProperties(Sheet.Set set) {
        set.put((Node.Property)this.createCompilerProperty());
    }

    public static void prepareJob(CompilerJob job, Enumeration en, Class type, Compiler.Depth depth) {
        AbstractCompileAction.prepareJobFor(job, en, type, depth);
    }

    private PropertySupport createCompilerProperty() {
        return new PropertySupport.ReadWrite(PROP_COMPILER_TYPE, class$org$openide$compiler$CompilerType == null ? (class$org$openide$compiler$CompilerType = CompilerSupport.class$("org.openide.compiler.CompilerType")) : class$org$openide$compiler$CompilerType, NbBundle.getMessage((Class)(class$org$openide$compiler$Compiler == null ? (class$org$openide$compiler$Compiler = CompilerSupport.class$("org.openide.compiler.Compiler")) : class$org$openide$compiler$Compiler), (String)"PROP_compilerType"), NbBundle.getMessage((Class)(class$org$openide$compiler$Compiler == null ? (class$org$openide$compiler$Compiler = CompilerSupport.class$("org.openide.compiler.Compiler")) : class$org$openide$compiler$Compiler), (String)"HINT_compilerType")){

            public Object getValue() {
                CompilerType ct = CompilerSupport.getCompilerType(CompilerSupport.this.entry);
                if (ct == null) {
                    return CompilerSupport.this.defaultCompilerType();
                }
                return ct;
            }

            public void setValue(Object val) throws InvocationTargetException {
                try {
                    CompilerSupport.setCompilerType(CompilerSupport.this.entry, (CompilerType)((Object)val));
                }
                catch (IOException ex) {
                    throw new InvocationTargetException(ex);
                }
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
            }

            public boolean canWrite() {
                Boolean isReadOnly = (Boolean)CompilerSupport.this.entry.getFile().getAttribute(CompilerSupport.READONLY_ATTRIBUTES);
                return isReadOnly == null ? false : isReadOnly == false;
            }
        };
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Clean
    extends CompilerSupport
    implements CompilerCookie.Clean {
        static /* synthetic */ Class class$org$openide$cookies$CompilerCookie$Clean;

        public Clean(MultiDataObject.Entry entry) {
            super(entry, class$org$openide$cookies$CompilerCookie$Clean == null ? (class$org$openide$cookies$CompilerCookie$Clean = Clean.class$("org.openide.cookies.CompilerCookie$Clean")) : class$org$openide$cookies$CompilerCookie$Clean);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static class Build
    extends CompilerSupport
    implements CompilerCookie.Build {
        static /* synthetic */ Class class$org$openide$cookies$CompilerCookie$Build;

        public Build(MultiDataObject.Entry entry) {
            super(entry, class$org$openide$cookies$CompilerCookie$Build == null ? (class$org$openide$cookies$CompilerCookie$Build = Build.class$("org.openide.cookies.CompilerCookie$Build")) : class$org$openide$cookies$CompilerCookie$Build);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static class Compile
    extends CompilerSupport
    implements CompilerCookie.Compile {
        static /* synthetic */ Class class$org$openide$cookies$CompilerCookie$Compile;

        public Compile(MultiDataObject.Entry entry) {
            super(entry, class$org$openide$cookies$CompilerCookie$Compile == null ? (class$org$openide$cookies$CompilerCookie$Compile = Compile.class$("org.openide.cookies.CompilerCookie$Compile")) : class$org$openide$cookies$CompilerCookie$Compile);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

