/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashMap;
import org.netbeans.modules.debugger.CoreBreakpoint;

public abstract class BreakpointGroup
implements Serializable {
    static final long serialVersionUID = 3680012002191932551L;
    public static final String PROP_BREAKPOINTS = "breakpoints";
    public static final String PROP_GROUPS = "groups";
    public static final String PROP_NAME = "name";
    public static final String PROP_PARENT_GROUP = "parentGroup";
    protected transient PropertyChangeSupport pcs;
    private BreakpointGroup parent = null;
    private HashMap breakpoints = new HashMap();
    private CoreBreakpoint[] breakpointsCache;
    private HashMap groups = new HashMap();
    private BreakpointGroup[] groupsCache;
    private String name;

    public BreakpointGroup() {
        this.init();
    }

    protected void init() {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String newName) {
        if (newName == null) {
            newName = "";
        }
        String o = this.name;
        this.name = newName;
        this.firePropertyChange(PROP_NAME, o, this.name);
    }

    public BreakpointGroup getParentGroup() {
        return this.parent;
    }

    protected boolean setParentGroup(BreakpointGroup newParent) {
        if (this.parent == newParent) {
            return true;
        }
        BreakpointGroup old = this.parent;
        if (this.parent != null) {
            this.parent = null;
            if (!old.removeGroup(this)) {
                this.parent = old;
                return false;
            }
        }
        this.parent = newParent;
        if (newParent != null && !newParent.addGroup(this)) {
            this.parent = old;
            this.parent.addGroup(this);
            return false;
        }
        this.firePropertyChange(PROP_PARENT_GROUP, old, this.parent);
        return true;
    }

    public CoreBreakpoint[] getBreakpoints() {
        if (this.breakpointsCache != null) {
            return this.breakpointsCache;
        }
        this.breakpointsCache = new CoreBreakpoint[this.breakpoints.size()];
        this.breakpoints.keySet().toArray(this.breakpointsCache);
        return this.breakpointsCache;
    }

    public BreakpointGroup[] getGroups() {
        if (this.groupsCache != null) {
            return this.groupsCache;
        }
        this.groupsCache = new BreakpointGroup[this.groups.size()];
        this.groups.keySet().toArray(this.groupsCache);
        return this.groupsCache;
    }

    public boolean addBreakpoint(CoreBreakpoint breakpoint) {
        if (this.breakpoints.containsKey(breakpoint)) {
            return true;
        }
        BreakpointGroup oldG = breakpoint.getGroup();
        if (oldG != null) {
            breakpoint.setGroup(null);
            if (!oldG.removeBreakpoint(breakpoint)) {
                breakpoint.setGroup(oldG);
                return false;
            }
        }
        breakpoint.setGroup(this);
        this.breakpointsCache = null;
        this.breakpoints.put(breakpoint, breakpoint);
        this.firePropertyChange(PROP_BREAKPOINTS, null, breakpoint);
        return true;
    }

    public boolean removeBreakpoint(CoreBreakpoint breakpoint) {
        if (!this.breakpoints.containsKey(breakpoint)) {
            return true;
        }
        breakpoint.setGroup(null);
        this.breakpointsCache = null;
        this.breakpoints.remove(breakpoint);
        this.firePropertyChange(PROP_BREAKPOINTS, breakpoint, null);
        return true;
    }

    public boolean addGroup(BreakpointGroup group) {
        if (this.groups.containsKey(group)) {
            return true;
        }
        this.groups.put(group, group);
        if (!group.setParentGroup(this)) {
            this.groups.remove(group);
            return false;
        }
        this.groupsCache = null;
        this.firePropertyChange(PROP_GROUPS, null, group);
        return true;
    }

    public boolean removeGroup(BreakpointGroup group) {
        if (!this.groups.containsKey(group)) {
            return true;
        }
        this.groups.remove(group);
        if (!group.setParentGroup(null)) {
            this.groups.put(group, group);
            return false;
        }
        this.groupsCache = null;
        this.firePropertyChange(PROP_GROUPS, group, null);
        return true;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    protected void firePropertyChange(String name, Object o, Object n) {
        this.pcs.firePropertyChange(name, o, n);
    }
}

