/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.swing.JComponent;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.BreakpointGroup;
import org.netbeans.modules.debugger.BreakpointProducer;
import org.netbeans.modules.debugger.DebuggerImpl;
import org.netbeans.modules.debugger.EventsProducer;
import org.netbeans.modules.debugger.Register;
import org.openide.debugger.Breakpoint;
import org.openide.debugger.Debugger;
import org.openide.nodes.Node;
import org.openide.text.Line;
import org.openide.util.HelpCtx;

public abstract class CoreBreakpoint
extends Breakpoint
implements Serializable {
    static final long serialVersionUID = 3686204002781932191L;
    public static final String PROP_EVENT = "event";
    public static final String PROP_ACTIONS = "actions";
    public static final String PROP_HIDDEN = "hidden";
    private transient PropertyChangeSupport pcs;
    protected transient AbstractDebugger debugger;
    private Action[] actions;
    protected Event event;
    private BreakpointGroup group;

    public CoreBreakpoint() {
        this.init();
    }

    protected void init() {
        this.pcs = new PropertyChangeSupport(this);
        if (this.debugger == null) {
            this.debugger = Register.getCoreDebugger();
        }
        if (this.actions == null) {
            this.actions = new Action[0];
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
    }

    public Event getEvent(Debugger debugger) {
        if (debugger == this.debugger) {
            return this.event;
        }
        return null;
    }

    protected Event createEvent(AbstractDebugger debugger, String type) {
        DebuggerImpl impl = null;
        impl = debugger == Register.getCoreDebugger() ? Register.getDebuggerCoreImpl() : Register.getDebuggerImpl(debugger);
        if (!(impl instanceof EventsProducer)) {
            return null;
        }
        Event[] es = ((EventsProducer)((Object)impl)).getEvents();
        int k = es.length;
        int i = 0;
        while (i < k) {
            if (es[i].getTypeName().equals(type)) {
                try {
                    Event e = (Event)es[i].getClass().newInstance();
                    e.breakpoint = this;
                    e.debugger = debugger;
                    return e;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            ++i;
        }
        return null;
    }

    public Event getEvent() {
        AbstractDebugger d = Register.getCurrentDebugger();
        if (!(d instanceof BreakpointProducer)) {
            return this.event;
        }
        if (d != null) {
            return this.getEvent(d);
        }
        return this.event;
    }

    public synchronized void setEvent(Event e) {
        if (e != this.event) {
            Event old = this.event;
            if (e != null) {
                e.breakpoint = this;
            }
            this.event = e;
            this.firePropertyChange(PROP_EVENT, old, this.event);
            if (old != null) {
                old.dispose();
            }
            if (this.event != null) {
                this.setActions(this.event.getActions());
            }
        }
    }

    public Action[] getActions() {
        return this.actions;
    }

    public void setActions(Action[] act) {
        Action[] old = this.actions;
        this.actions = act;
        int k = this.actions.length;
        int i = 0;
        while (i < k) {
            this.actions[i].breakpoint = this;
            ++i;
        }
        i = 0;
        while (i < old.length) {
            old[i].dispose();
            ++i;
        }
        this.firePropertyChange(PROP_ACTIONS, old, this.actions);
    }

    public abstract void setHidden(boolean var1);

    protected void perform(Event e) {
        int k = this.actions.length;
        int i = 0;
        while (i < k) {
            this.actions[i].perform(e);
            ++i;
        }
    }

    protected abstract void setValid(boolean var1);

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    protected void fireEventPropertyChange(Event e, String name, Object o, Object n) {
        this.firePropertyChange(name, o, n);
    }

    protected void firePropertyChange(String name, Object o, Object n) {
        this.pcs.firePropertyChange(name, o, n);
    }

    public void remove() {
        if (this.group != null) {
            this.group.removeBreakpoint(this);
        }
    }

    public BreakpointGroup getGroup() {
        return this.group;
    }

    void setGroup(BreakpointGroup group) {
        this.group = group;
    }

    public static abstract class Action
    implements Serializable {
        static final long serialVersionUID = 5993327662505228239L;
        private CoreBreakpoint breakpoint;

        protected abstract void perform(Event var1);

        public void dispose() {
        }

        public abstract Node.Property[] getProperties();

        public abstract JComponent getCustomizer();

        public CoreBreakpoint getBreakpoint() {
            return this.breakpoint;
        }

        protected void firePropertyChange(String name, Object o, Object n) {
            if (this.breakpoint != null) {
                this.breakpoint.firePropertyChange(name, o, n);
            }
        }
    }

    public static interface CompoundEvent {
        public static final String PROP_EVENTS = "event";

        public Event[] getEvents();
    }

    public static interface SessionEvent {
        public void synchronizeWith(Event var1);
    }

    public static interface AnnotatableEvent {
        public void annotate();
    }

    public static abstract class Event
    implements Serializable {
        static final long serialVersionUID = -4232563710736961248L;
        private CoreBreakpoint breakpoint;
        private Debugger debugger;

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.debugger = null;
        }

        public abstract boolean set();

        public abstract void remove();

        public void dispose() {
        }

        public abstract String getTypeName();

        public abstract String getTypeDisplayName();

        public String getCategoryDisplayName() {
            return null;
        }

        public boolean isDefault() {
            return false;
        }

        public abstract String getDisplayName();

        public String getIconBase() {
            return null;
        }

        public abstract Line[] getLines();

        public abstract Node.Property[] getProperties();

        public abstract JComponent getCustomizer();

        public Action[] getActions() {
            return new Action[0];
        }

        public CoreBreakpoint getBreakpoint() {
            return this.breakpoint;
        }

        public Debugger getDebugger() {
            if (this.debugger == null) {
                this.debugger = Register.getCoreDebugger();
            }
            return this.debugger;
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("NetbeansDebuggerBreakpoint");
        }

        protected void setValid(boolean valid) {
            this.getBreakpoint().setValid(valid);
        }

        protected void perform() {
            this.getBreakpoint().perform(this);
        }

        protected void firePropertyChange(String name, Object o, Object n) {
            if (this.breakpoint != null) {
                this.breakpoint.fireEventPropertyChange(this, name, o, n);
            }
        }
    }
}

