/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.openide.filesystems.FileSystemCapability;
import org.openide.windows.TopComponent;

public class GUIManager
implements Serializable {
    public static final String PROP_VIEWS = "views";
    public static final String PROP_ROOT_NODES = "nodes";
    public static final String PROP_VISIBLE = "visible";
    public static final FileSystemCapability DEBUG_SRC = new FileSystemCapability();
    private static GUIManager defaultManager = null;
    private transient PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private View[] views = new View[0];
    private String[] nodes = new String[0];

    public static synchronized GUIManager getDefault() {
        if (defaultManager == null) {
            defaultManager = new GUIManager();
        }
        return defaultManager;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.pcs = new PropertyChangeSupport(this);
    }

    public View[] getViews() {
        return this.views;
    }

    public void addView(View v) {
        this.addView(this.getViews().length, v);
    }

    public void addView(int index, View v) {
        if (this.views.length == 0) {
            this.setViews(new View[]{v});
            return;
        }
        View[] n = new View[this.views.length + 1];
        if (index > 0) {
            System.arraycopy(this.views, 0, n, 0, index);
        }
        if (index < this.views.length) {
            System.arraycopy(this.views, index, n, index + 1, this.views.length - index);
        }
        n[Math.min((int)index, (int)this.views.length)] = v;
        this.setViews(n);
    }

    public boolean removeView(View v) {
        int k = this.views.length;
        int i = 0;
        while (i < k) {
            if (this.views[i] == v) {
                if (k == 1) {
                    this.setViews(new View[0]);
                } else {
                    View[] n = new View[k - 1];
                    if (i > 0) {
                        System.arraycopy(this.views, 0, n, 0, i);
                    }
                    if (i < k - 1) {
                        System.arraycopy(this.views, i + 1, n, i, k - i - 1);
                    }
                    this.setViews(n);
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setViews(View[] vs) {
        View[] old = this.views;
        this.views = vs;
        this.pcs.firePropertyChange(PROP_VIEWS, old, this.views);
    }

    public String[] getRootNodes() {
        return this.nodes;
    }

    public void addRootNode(String n) {
        this.addRootNode(this.getRootNodes().length, n);
    }

    public void addRootNode(int index, String n) {
        if (this.nodes.length == 0) {
            this.setRootNodes(new String[]{n});
            return;
        }
        String[] ns = new String[this.nodes.length + 1];
        if (index > 0) {
            System.arraycopy(this.nodes, 0, ns, 0, index);
        }
        if (index < this.nodes.length) {
            System.arraycopy(this.nodes, index, ns, index + 1, this.nodes.length - index);
        }
        ns[Math.min((int)index, (int)this.nodes.length)] = n;
        this.setRootNodes(ns);
    }

    public boolean removeRootNode(String n) {
        int k = this.nodes.length;
        int i = 0;
        while (i < k) {
            if (this.nodes[i] == n) {
                if (k == 1) {
                    this.setRootNodes(new String[0]);
                } else {
                    String[] ns = new String[k - 1];
                    if (i > 0) {
                        System.arraycopy(this.nodes, 0, ns, 0, i);
                    }
                    if (i < k - 1) {
                        System.arraycopy(this.nodes, i + 1, ns, i, k - i - 1);
                    }
                    this.setRootNodes(ns);
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setRootNodes(String[] vs) {
        String[] old = this.nodes;
        this.nodes = vs;
        this.pcs.firePropertyChange(PROP_ROOT_NODES, old, this.nodes);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    public static abstract class View
    implements Serializable {
        private static final long serialVersionUID = 8294525275584748002L;

        public abstract String getDisplayName();

        public abstract String getIconBase();

        public abstract TopComponent getComponent();
    }
}

