/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class NodesRegistry {
    private static LinkedList reg = new LinkedList();
    private static int regLength = 0;
    private static LinkedList nodes = new LinkedList();
    private static HashMap cache = new HashMap();
    static HashMap helpT = new HashMap();
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Float;

    public static synchronized void register(String documentClassName, String nodeClassName) {
        reg.addFirst(new String[]{documentClassName});
        ++regLength;
        nodes.addFirst(nodeClassName);
    }

    public static synchronized void register(String[] documentClassName, String nodeClassName) {
        String[] s = new String[documentClassName.length];
        int k = documentClassName.length;
        int i = 0;
        while (i < k) {
            s[i] = documentClassName[i];
            ++i;
        }
        reg.addFirst(s);
        ++regLength;
        nodes.addFirst(nodeClassName);
    }

    public static synchronized void registerForName(String documentName, String nodeClassName) {
        reg.addLast(new String[]{documentName});
        nodes.addLast(nodeClassName);
    }

    public static Node getNode(Object document) {
        return NodesRegistry.getNode(document, new Object[]{document});
    }

    public static Node getNode(Object document, Object[] params) {
        if (document instanceof String) {
            return NodesRegistry.getNode((String)document, params);
        }
        Class<?> documentClass = document.getClass();
        String cName = (String)cache.get(documentClass.getName());
        Class<?> c = null;
        if (cName != null) {
            try {
                c = Class.forName(cName, true, (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = NodesRegistry.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader));
            }
            catch (ClassNotFoundException ex) {
                ex.printStackTrace();
                return null;
            }
        } else {
            c = NodesRegistry.getNodeClass(documentClass);
            if (c == null) {
                return null;
            }
            cache.put(documentClass.getName(), c.getName());
        }
        return NodesRegistry.getNode(c, params);
    }

    public static Node getNode(String documentName, Object[] params) {
        String cName = (String)cache.get(documentName);
        Class<?> c = null;
        if (cName != null) {
            try {
                c = Class.forName(cName, true, (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = NodesRegistry.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader));
            }
            catch (ClassNotFoundException ex) {
                ex.printStackTrace();
                return null;
            }
        } else {
            c = NodesRegistry.getNodeString(documentName);
            if (c == null) {
                return null;
            }
            cache.put(documentName, c.getName());
        }
        return NodesRegistry.getNode(c, params);
    }

    private static Node getNode(Class c, Object[] params) {
        int k = params.length;
        Class[] par = new Class[k];
        int i = 0;
        while (i < k) {
            par[i] = params[i].getClass();
            ++i;
        }
        try {
            Constructor<Object> constr = null;
            try {
                constr = c.getConstructor(par);
            }
            catch (NoSuchMethodException ex1) {
                // empty catch block
            }
            if (constr == null) {
                Constructor<?>[] cs = c.getConstructors();
                k = cs.length;
                i = 0;
                while (i < k) {
                    Class<?>[] parT = cs[i].getParameterTypes();
                    if (parT.length == params.length) {
                        int jj = parT.length;
                        int j = 0;
                        while (j < jj) {
                            if (!NodesRegistry.compatible(parT[j], params[j])) break;
                            ++j;
                        }
                        if (j == jj) {
                            constr = cs[i];
                            break;
                        }
                    }
                    ++i;
                }
            }
            if (constr == null) {
                System.out.println("Can not find constructor for " + c + " with params " + params);
                Thread.dumpStack();
                System.out.println();
                return null;
            }
            return (Node)constr.newInstance(params);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    static boolean compatible(Class a, Object b) {
        if (b == null) {
            return true;
        }
        if (a.isInstance(b)) {
            return true;
        }
        Class c = (Class)helpT.get(a);
        if (c == null) {
            return false;
        }
        return c.equals(b.getClass());
    }

    private static Class getNodeString(String document) {
        LinkedList r = (LinkedList)reg.clone();
        int k = r.size();
        int i = regLength;
        while (i < k) {
            String[] s = (String[])r.get(i);
            if (s.length == 1 && s[0].equals(document)) {
                return NodesRegistry.getNodeClass(i);
            }
            ++i;
        }
        System.out.println("Node for " + document + " not found");
        Thread.dumpStack();
        System.out.println();
        return null;
    }

    private static Class getNodeClass(Class document) {
        LinkedList r = (LinkedList)reg.clone();
        int selected = -1;
        int count = -1;
        int rating = -1;
        Class[] oCls = null;
        int k = regLength;
        int i = 0;
        while (i < k) {
            String[] clsName = (String[])r.get(i);
            int jj = clsName.length;
            Class[] cls = new Class[jj];
            int j = 0;
            while (j < jj) {
                try {
                    cls[j] = Class.forName(clsName[j], true, (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? NodesRegistry.class$("java.lang.ClassLoader") : class$java$lang$ClassLoader));
                    if (!cls[j].isAssignableFrom(document)) {
                    }
                }
                catch (ClassNotFoundException ex) {}
                break;
                ++j;
            }
            if (j >= jj) {
                if (jj == 1 && cls[0].equals(document)) {
                    return NodesRegistry.getNodeClass(i);
                }
                if (selected == -1 || count < jj) {
                    selected = i;
                    count = jj;
                    oCls = cls;
                } else if (count <= jj) {
                    int newRating;
                    if (rating < 0) {
                        rating = NodesRegistry.countRating(oCls, document, Integer.MAX_VALUE);
                    }
                    if ((newRating = NodesRegistry.countRating(cls, document, Integer.MAX_VALUE)) < rating) {
                        selected = i;
                        count = jj;
                        rating = newRating;
                    }
                }
            }
            ++i;
        }
        if (selected < 0) {
            System.out.println("Can not find node for " + document);
            Thread.dumpStack();
            System.out.println();
            return null;
        }
        return NodesRegistry.getNodeClass(selected);
    }

    private static Class getNodeClass(int index) {
        String s = (String)nodes.get(index);
        try {
            return Class.forName(s, true, (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = NodesRegistry.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Class " + s + " not found!");
        }
    }

    private static int countRating(Class[] cls, Class o, int r) {
        LinkedList<Class> os = new LinkedList<Class>();
        os.add(o);
        HashSet<Class> clss = new HashSet<Class>();
        int jj = cls.length;
        int j = 0;
        while (j < jj) {
            clss.add(cls[j]);
            ++j;
        }
        return NodesRegistry.countRating(clss, os, r, 0, 0);
    }

    private static void addSuper(LinkedList o, Class c) {
        Class s = c.getSuperclass();
        if (s != null) {
            o.add(s);
        }
        Class<?>[] i = c.getInterfaces();
        int jj = i.length;
        int j = 0;
        while (j < jj) {
            o.add(i[j]);
            ++j;
        }
    }

    private static int countRating(HashSet cls, LinkedList o, int r, int currentR, int depth) {
        int od;
        int k = o.size();
        int i = 0;
        while (i < k) {
            Class c = (Class)o.get(0);
            if (!cls.contains(c)) {
                NodesRegistry.addSuper(o, c);
                o.removeFirst();
            } else {
                if (cls.size() == 1 || (currentR += depth) >= r) {
                    return currentR;
                }
                cls.remove(c);
            }
            ++i;
        }
        if ((od = ++depth * cls.size()) >= r) {
            return od;
        }
        return NodesRegistry.countRating(cls, o, r, currentR, depth);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        helpT.put(Integer.TYPE, class$java$lang$Integer == null ? (class$java$lang$Integer = NodesRegistry.class$("java.lang.Integer")) : class$java$lang$Integer);
        helpT.put(Boolean.TYPE, class$java$lang$Boolean == null ? (class$java$lang$Boolean = NodesRegistry.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        helpT.put(Character.TYPE, class$java$lang$Character == null ? (class$java$lang$Character = NodesRegistry.class$("java.lang.Character")) : class$java$lang$Character);
        helpT.put(Long.TYPE, class$java$lang$Long == null ? (class$java$lang$Long = NodesRegistry.class$("java.lang.Long")) : class$java$lang$Long);
        helpT.put(Byte.TYPE, class$java$lang$Byte == null ? (class$java$lang$Byte = NodesRegistry.class$("java.lang.Byte")) : class$java$lang$Byte);
        helpT.put(Double.TYPE, class$java$lang$Double == null ? (class$java$lang$Double = NodesRegistry.class$("java.lang.Double")) : class$java$lang$Double);
        helpT.put(Short.TYPE, class$java$lang$Short == null ? (class$java$lang$Short = NodesRegistry.class$("java.lang.Short")) : class$java$lang$Short);
        helpT.put(Float.TYPE, class$java$lang$Float == null ? (class$java$lang$Float = NodesRegistry.class$("java.lang.Float")) : class$java$lang$Float);
    }
}

