/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger;

import java.util.AbstractCollection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.CoreDebugger;
import org.netbeans.modules.debugger.DebuggerCoreImpl;
import org.netbeans.modules.debugger.DebuggerImpl;
import org.openide.util.Lookup;

public class Register {
    private static DebuggerImpl defaultImpl;
    private static LinkedList debuggerImpls;
    private static HashMap listeners;
    static /* synthetic */ Class class$org$openide$debugger$Debugger;

    public static DebuggerImpl getDebuggerCoreImpl() {
        if (defaultImpl == null && debuggerImpls.size() == 1) {
            return (DebuggerImpl)debuggerImpls.get(0);
        }
        return defaultImpl;
    }

    public static void setDebuggerCoreImpl(DebuggerImpl impl) {
        if (defaultImpl != null) {
            throw new SecurityException("Second default DebuggerImpl can not be set!");
        }
        if (!(impl instanceof DebuggerCoreImpl)) {
            throw new SecurityException("DebuggerImpl does not implement DebuggerCoreImpl!");
        }
        defaultImpl = impl;
    }

    public static DebuggerImpl getDebuggerImpl(AbstractDebugger debugger) {
        if (defaultImpl != null) {
            return ((DebuggerCoreImpl)((Object)defaultImpl)).getDebuggerImpl(debugger);
        }
        if (debuggerImpls.size() == 1) {
            return (DebuggerImpl)debuggerImpls.get(0);
        }
        return null;
    }

    public static void registerDebuggerImpl(DebuggerImpl debuggerImpl) {
        debuggerImpls.add(debuggerImpl);
        Iterator i = listeners.keySet().iterator();
        while (i.hasNext()) {
            ((RegisterListener)i.next()).debuggerImplAdded(debuggerImpl);
        }
    }

    public static void unregisterDebuggerImpl(DebuggerImpl debuggerImpl) {
        debuggerImpls.remove(debuggerImpl);
        Iterator i = listeners.keySet().iterator();
        while (i.hasNext()) {
            ((RegisterListener)i.next()).debuggerImplRemoved(debuggerImpl);
        }
    }

    public static List getDebuggerImpls() {
        return Collections.unmodifiableList(debuggerImpls);
    }

    public static void addRegisterListener(RegisterListener rl) {
        listeners.put(rl, rl);
    }

    public static void removeRegisterListener(RegisterListener rl) {
        listeners.remove(rl);
    }

    public static String[] getSupportedLanguagesForDebugge(AbstractDebugger d) {
        int k = debuggerImpls.size();
        HashSet<String> hs = new HashSet<String>();
        int i = 0;
        while (i < k) {
            String[] r = ((DebuggerImpl)debuggerImpls.get(i)).canStartDebugging(d);
            int kk = r.length;
            int j = 0;
            while (j < kk) {
                hs.add(r[j]);
                ++j;
            }
            ++i;
        }
        String[] re = new String[hs.size()];
        return ((AbstractCollection)hs).toArray(re);
    }

    public static AbstractDebugger startDebuggingForDebugee(AbstractDebugger d, String language) {
        int k = debuggerImpls.size();
        int i = 0;
        while (i < k) {
            String[] r = ((DebuggerImpl)debuggerImpls.get(i)).canStartDebugging(d);
            int kk = r.length;
            int j = 0;
            while (j < kk) {
                if (language.equals(r[j])) {
                    return ((DebuggerImpl)debuggerImpls.get(i)).startDebugging(d, language);
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public static CoreDebugger getCoreDebugger() {
        return (CoreDebugger)Lookup.getDefault().lookup(class$org$openide$debugger$Debugger == null ? (class$org$openide$debugger$Debugger = Register.class$("org.openide.debugger.Debugger")) : class$org$openide$debugger$Debugger);
    }

    public static AbstractDebugger getCurrentDebugger() {
        CoreDebugger cd = Register.getCoreDebugger();
        if (cd == null) {
            return null;
        }
        return cd.getCurrentDebugger();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        debuggerImpls = new LinkedList();
        listeners = new HashMap();
    }

    public static abstract class RegisterListener {
        public abstract void debuggerImplAdded(DebuggerImpl var1);

        public abstract void debuggerImplRemoved(DebuggerImpl var1);
    }
}

