/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.delegator;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.debugger.ConnectSupport;
import org.netbeans.modules.debugger.DebuggerImpl;
import org.netbeans.modules.debugger.delegator.DelegatingDebugger;
import org.netbeans.modules.debugger.support.DebuggerInfoProducer;
import org.netbeans.modules.debugger.support.DebuggerProjectSettings;
import org.openide.debugger.DebuggerInfo;
import org.openide.util.SharedClassObject;

class ConnectorPanel
extends JPanel
implements DebuggerInfoProducer,
ActionListener {
    private JComboBox cbDebuggers;
    private DebuggerInfoProducer producer;
    private boolean doNotListen;
    private ArrayList connectPanels = new ArrayList();
    private List debuggerTypes = new ArrayList();
    private int lastDebuggerIndex;
    private DebuggerProjectSettings connectSettings;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$DebuggerProjectSettings;

    ConnectorPanel(List debuggerImpls) {
        this.getAccessibleContext().setAccessibleDescription(DelegatingDebugger.getLocString("ACSD_ConnectorPanel"));
        this.cbDebuggers = new JComboBox();
        this.cbDebuggers.getAccessibleContext().setAccessibleDescription(DelegatingDebugger.getLocString("ACSD_CTL_Connect_through"));
        int k = debuggerImpls.size();
        int i = 0;
        while (i < k) {
            JComponent c;
            DebuggerImpl di = (DebuggerImpl)debuggerImpls.get(i);
            if (!(di instanceof ConnectSupport) || (c = ((ConnectSupport)((Object)di)).getConnectPanel()) == null) break;
            this.debuggerTypes.add(di.getClass().getName());
            this.cbDebuggers.addItem(di.getDisplayName());
            this.connectPanels.add(c);
            ++i;
        }
        this.cbDebuggers.setActionCommand("SwitchMe!");
        this.cbDebuggers.addActionListener(this);
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(11, 11, 0, 10));
        this.connectSettings = (DebuggerProjectSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$debugger$support$DebuggerProjectSettings == null ? (class$org$netbeans$modules$debugger$support$DebuggerProjectSettings = ConnectorPanel.class$("org.netbeans.modules.debugger.support.DebuggerProjectSettings")) : class$org$netbeans$modules$debugger$support$DebuggerProjectSettings), (boolean)true);
        int defaultIndex = 0;
        if (this.debuggerTypes.size() > 1) {
            String lastDebuggerTypeName = null;
            if (this.connectSettings != null && (lastDebuggerTypeName = this.connectSettings.getLastDebuggerType()) != null) {
                boolean foundLast = false;
                ListIterator iter = this.debuggerTypes.listIterator();
                int index = 0;
                while (iter.hasNext()) {
                    if (iter.next().equals(lastDebuggerTypeName)) {
                        defaultIndex = index;
                        foundLast = true;
                        break;
                    }
                    ++index;
                }
            }
        }
        this.refresh(defaultIndex);
    }

    private void saveSettings() {
        if (this.connectSettings != null) {
            String lastDebuggerType = (String)this.debuggerTypes.get(this.lastDebuggerIndex);
            this.connectSettings.setLastDebuggerType(lastDebuggerType);
        }
    }

    private void refresh(int index) {
        this.lastDebuggerIndex = index;
        JLabel cbLabel = new JLabel(DelegatingDebugger.getLocString("CTL_Connect_through"));
        cbLabel.setDisplayedMnemonic(DelegatingDebugger.getLocString("CTL_Connect_through_Mnemonic").charAt(0));
        cbLabel.setLabelFor(this.cbDebuggers);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 0, 6, 6);
        this.add((Component)cbLabel, c);
        c = new GridBagConstraints();
        c.weightx = 1.0;
        c.fill = 2;
        c.gridwidth = 0;
        c.insets = new Insets(0, 3, 6, 0);
        this.doNotListen = true;
        this.cbDebuggers.setSelectedIndex(index);
        this.doNotListen = false;
        this.add((Component)this.cbDebuggers, c);
        c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.gridwidth = 0;
        JComponent comp = (JComponent)this.connectPanels.get(index);
        this.producer = (DebuggerInfoProducer)((Object)comp);
        this.add((Component)comp, c);
    }

    public DebuggerInfo getDebuggerInfo() {
        this.saveSettings();
        return this.producer.getDebuggerInfo();
    }

    public void actionPerformed(ActionEvent e) {
        if (this.doNotListen) {
            return;
        }
        if (e.getActionCommand().equals("SwitchMe!")) {
            // empty if block
        }
        this.removeAll();
        this.refresh(((JComboBox)e.getSource()).getSelectedIndex());
        Container w = this.getParent();
        while (!(w instanceof Window)) {
            w = w.getParent();
        }
        if (w != null) {
            ((Window)w).pack();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

