/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.delegator;

import java.util.ArrayList;
import java.util.Arrays;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.Register;
import org.netbeans.modules.debugger.support.BreakpointSupport;
import org.openide.debugger.Debugger;
import org.openide.nodes.Node;
import org.openide.text.Line;

public class DelegatingBreakpoint
extends BreakpointSupport {
    static final long serialVersionUID = 2246204002781932191L;
    private transient CoreBreakpoint.Event delEvent;

    DelegatingBreakpoint(boolean hidden) {
        super(hidden);
    }

    protected void init() {
        this.delEvent = null;
        super.init();
    }

    public CoreBreakpoint.Event getEvent(Debugger d) {
        if (d == this.debugger) {
            return this.event;
        }
        if (this.delEvent != null && d == this.delEvent.getDebugger()) {
            return this.delEvent;
        }
        return null;
    }

    public void remove() {
        super.remove();
        if (this.delEvent != null) {
            this.delEvent.remove();
            this.delEvent.dispose();
            this.delEvent = null;
        }
    }

    protected void setBreakpoint() {
        if (!this.isEnabled()) {
            return;
        }
        boolean valid = false;
        if (this.event != null) {
            if (this.debugger.getState() == 1) {
                if (this.delEvent != null) {
                    this.delEvent.remove();
                    this.delEvent.dispose();
                    this.delEvent = null;
                }
            } else {
                CoreBreakpoint.Event e;
                AbstractDebugger d;
                if (this.delEvent == null && this.event instanceof CoreBreakpoint.SessionEvent && (d = Register.getCurrentDebugger()) != null && (e = this.createEvent(d, this.event.getTypeName())) != null) {
                    if (e instanceof CoreBreakpoint.SessionEvent) {
                        ((CoreBreakpoint.SessionEvent)((Object)e)).synchronizeWith(this.event);
                    }
                    this.synchronizeProperties(e);
                    this.delEvent = e;
                }
                if (this.event instanceof CoreBreakpoint.SessionEvent) {
                    if (this.delEvent != null) {
                        valid = this.delEvent.set();
                    }
                } else {
                    valid = this.event.set();
                }
            }
            Line[] l = null;
            l = this.delEvent != null ? this.delEvent.getLines() : this.event.getLines();
            if (l != null) {
                this.remark(new ArrayList<Line>(Arrays.asList(l)));
            } else {
                this.remark(null);
            }
        }
        this.setValid(valid);
    }

    protected void clearBreakpoint() {
        this.remark(false);
        this.lines = null;
        if (this.delEvent != null) {
            this.delEvent.remove();
        }
        this.setValid(false);
    }

    protected void fireEventPropertyChange(CoreBreakpoint.Event e, String s, Object o, Object n) {
        if (e != this.event) {
            return;
        }
        this.firePropertyChange(null, o, n);
        if (this.isEnabled()) {
            this.setBreakpoint();
        } else if (this.event instanceof CoreBreakpoint.AnnotatableEvent) {
            ((CoreBreakpoint.AnnotatableEvent)((Object)this.event)).annotate();
        }
    }

    protected void synchronizeProperties() {
        if (this.delEvent != null) {
            this.synchronizeProperties(this.delEvent);
        }
    }

    protected void synchronizeProperties(CoreBreakpoint.Event e) {
        if (this.event == null) {
            return;
        }
        Node.Property[] s = this.event.getProperties();
        Node.Property[] d = e.getProperties();
        int k = Math.min(d.length, s.length);
        int i = 0;
        while (i < k) {
            try {
                d[i].setValue(s[i].getValue());
            }
            catch (Exception ex) {
                // empty catch block
            }
            ++i;
        }
    }

    void setDelegatingDebugger(AbstractDebugger debugger) {
        if (this.event == null) {
            return;
        }
        if (this.event instanceof CoreBreakpoint.SessionEvent) {
            CoreBreakpoint.Event e = this.createEvent(debugger, this.event.getTypeName());
            if (e == null) {
                return;
            }
            if (e instanceof CoreBreakpoint.SessionEvent) {
                ((CoreBreakpoint.SessionEvent)((Object)e)).synchronizeWith(this.event);
            }
            this.synchronizeProperties(e);
            if (this.delEvent != null) {
                this.delEvent.remove();
                this.delEvent.dispose();
            }
            this.delEvent = e;
        }
        this.setBreakpoint();
    }

    void removeDelegatingDebugger() {
        if (this.delEvent != null) {
            this.delEvent.remove();
            this.delEvent.dispose();
        }
        this.delEvent = null;
        this.setBreakpoint();
    }
}

