/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.delegator;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.AbstractThread;
import org.netbeans.modules.debugger.State;
import org.netbeans.modules.debugger.ThreadsProducer;
import org.netbeans.modules.debugger.ThreadsRoot;
import org.netbeans.modules.debugger.delegator.DelegatingThreadProducer;
import org.netbeans.modules.debugger.delegator.DelegatingWatch;
import org.netbeans.modules.debugger.support.DebuggerSupport;
import org.openide.debugger.DebuggerException;
import org.openide.debugger.Watch;
import org.openide.text.Line;
import org.openide.util.NbBundle;

public class DelegatingDebugger
extends DebuggerSupport {
    static final long serialVersionUID = 7558733005739651906L;
    private static transient ResourceBundle bundle;
    private transient Listener listener;
    private transient DelegatingThreadProducer threadProducer = null;
    private transient AbstractDebugger[] debuggers = new AbstractDebugger[0];
    private AbstractDebugger currentDebugger;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$delegator$DelegatingDebugger;

    static String getLocString(String s) {
        if (bundle == null) {
            bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$delegator$DelegatingDebugger == null ? (class$org$netbeans$modules$debugger$delegator$DelegatingDebugger = DelegatingDebugger.class$("org.netbeans.modules.debugger.delegator.DelegatingDebugger")) : class$org$netbeans$modules$debugger$delegator$DelegatingDebugger));
        }
        return bundle.getString(s);
    }

    public void traceInto() throws DebuggerException {
        AbstractDebugger debugger = this.getCurrentDebugger();
        if (debugger == null) {
            return;
        }
        this.setLastAction(3);
        debugger.traceInto();
    }

    public void traceOver() throws DebuggerException {
        AbstractDebugger debugger = this.getCurrentDebugger();
        if (debugger == null) {
            return;
        }
        this.setLastAction(2);
        debugger.traceOver();
    }

    public void go() throws DebuggerException {
        AbstractDebugger debugger = this.getCurrentDebugger();
        if (debugger == null) {
            return;
        }
        this.setLastAction(5);
        debugger.go();
    }

    public void stepOut() throws DebuggerException {
        AbstractDebugger debugger = this.getCurrentDebugger();
        if (debugger == null) {
            return;
        }
        this.setLastAction(4);
        debugger.stepOut();
    }

    public void pause() {
        AbstractDebugger debugger = this.getCurrentDebugger();
        if (debugger == null) {
            return;
        }
        this.setLastAction(9);
        debugger.pause();
    }

    public void runToCursor(Line l) {
        AbstractDebugger debugger = this.getCurrentDebugger();
        if (debugger == null) {
            return;
        }
        this.setLastAction(10);
        debugger.runToCursor(l);
    }

    public void goToCalledMethod() {
        AbstractDebugger debugger = this.getCurrentDebugger();
        if (debugger == null) {
            return;
        }
        this.setLastAction(7);
        debugger.goToCalledMethod();
    }

    public void goToCallingMethod() {
        AbstractDebugger debugger = this.getCurrentDebugger();
        if (debugger == null) {
            return;
        }
        this.setLastAction(8);
        debugger.goToCallingMethod();
    }

    public void fix() {
        AbstractDebugger debugger = this.getCurrentDebugger();
        if (debugger == null) {
            return;
        }
        debugger.fix();
    }

    public void popTopmostFrame() {
        AbstractDebugger debugger = this.getCurrentDebugger();
        if (debugger == null) {
            return;
        }
        debugger.popTopmostFrame();
    }

    public Watch createWatch() {
        DelegatingWatch w = new DelegatingWatch(false);
        this.addWatch(w);
        return w;
    }

    public Watch createWatch(String expr, boolean hidden) {
        DelegatingWatch w = new DelegatingWatch(hidden);
        w.setVariableName(expr);
        this.addWatch(w);
        return w;
    }

    public int getLastAction() {
        if (this.getCurrentDebugger() == null) {
            return 6;
        }
        if (!(this.getCurrentDebugger() instanceof AbstractDebugger)) {
            return 6;
        }
        return this.getCurrentDebugger().getLastAction();
    }

    public Line getCurrentLine() {
        if (this.getCurrentDebugger() == null) {
            return null;
        }
        return this.getCurrentDebugger().getCurrentLine();
    }

    public int getState() {
        int state = this.getCurrentDebugger() == null ? 1 : this.getCurrentDebugger().getState();
        System.setProperty("org.openide.awt.SwingBrowserImpl.do-not-block-awt", String.valueOf(state != 1));
        return state;
    }

    public State getDebuggerState() {
        if (this.getCurrentDebugger() == null) {
            return DebuggerSupport.STATE_NOT_RUNNING;
        }
        return this.getCurrentDebugger().getDebuggerState();
    }

    public ThreadsProducer getThreadsRoot() {
        if (this.threadProducer == null) {
            this.threadProducer = new DelegatingThreadProducer();
        }
        return this.threadProducer;
    }

    public AbstractThread getCurrentThread() {
        if (this.getCurrentDebugger() == null) {
            return null;
        }
        if (!(this.getCurrentDebugger() instanceof ThreadsRoot)) {
            return null;
        }
        return ((ThreadsRoot)((Object)this.getCurrentDebugger())).getCurrentThread();
    }

    public void setCurrentThread(AbstractThread thread) {
        thread.setCurrent(true);
    }

    public AbstractDebugger getCurrentDebugger() {
        return this.currentDebugger;
    }

    public AbstractDebugger[] getDebuggers() {
        return this.debuggers;
    }

    public void setCurrentDebugger(AbstractDebugger d) {
        if (this.getCurrentDebugger() == d) {
            return;
        }
        if (d != null) {
            int k = this.debuggers.length;
            int i = 0;
            while (i < k) {
                if (d == this.debuggers[i]) break;
                ++i;
            }
            if (i == k) {
                return;
            }
        }
        AbstractDebugger old = this.getCurrentDebugger();
        State ds = this.getDebuggerState();
        Integer s = new Integer(this.getState());
        AbstractThread t = this.getCurrentThread();
        Line l = this.getCurrentLine();
        Integer a = new Integer(this.getLastAction());
        this.currentDebugger = d;
        this.firePropertyChange("currentDebugger", old, this.currentDebugger);
        this.firePropertyChange("state", s, new Integer(this.getState()));
        this.firePropertyChange("debuggerState", ds, this.getDebuggerState());
        this.firePropertyChange("currentThread", t, this.getCurrentThread());
        this.firePropertyChange("currentLine", l, this.getCurrentLine());
        this.firePropertyChange("lastAction", a, new Integer(this.getLastAction()));
        if (this.threadProducer != null) {
            if (this.currentDebugger instanceof ThreadsRoot) {
                this.threadProducer.setRemoteThreadGroup(((ThreadsRoot)((Object)this.currentDebugger)).getThreadsRoot());
            } else {
                this.threadProducer.setRemoteThreadGroup(null);
            }
        }
    }

    protected void addDebugger(AbstractDebugger d) {
        int k = this.debuggers.length;
        int i = 0;
        while (i < k) {
            if (d == this.debuggers[i]) {
                return;
            }
            ++i;
        }
        AbstractDebugger[] nds = new AbstractDebugger[this.debuggers.length + 1];
        System.arraycopy(this.debuggers, 0, nds, 0, this.debuggers.length);
        nds[this.debuggers.length] = d;
        d.addPropertyChangeListener(this.getListener());
        AbstractDebugger[] o = this.debuggers;
        this.debuggers = nds;
        this.firePropertyChange("debuggers", o, this.debuggers);
    }

    protected void removeDebugger(AbstractDebugger d) {
        AbstractDebugger nCurrentDebugger = null;
        int k = this.debuggers.length;
        int i = 0;
        while (i < k) {
            if (this.debuggers[i] == d) break;
            if (nCurrentDebugger == null) {
                nCurrentDebugger = this.debuggers[i];
            }
            ++i;
        }
        if (i == k) {
            return;
        }
        if (d == this.getCurrentDebugger()) {
            if (nCurrentDebugger == null && k > 1) {
                nCurrentDebugger = this.debuggers[1];
            }
            this.setCurrentDebugger(nCurrentDebugger);
        }
        AbstractDebugger[] nds = new AbstractDebugger[this.debuggers.length - 1];
        System.arraycopy(this.debuggers, 0, nds, 0, i);
        if (this.debuggers.length - i > 1) {
            System.arraycopy(this.debuggers, i + 1, nds, i, this.debuggers.length - i - 1);
        }
        d.removePropertyChangeListener(this.getListener());
        AbstractDebugger[] o = this.debuggers;
        this.debuggers = nds;
        this.firePropertyChange("debuggers", o, this.debuggers);
    }

    private Listener getListener() {
        if (this.listener == null) {
            this.listener = this.createListener();
        }
        return this.listener;
    }

    protected Listener createListener() {
        return new Listener();
    }

    protected void firePropertyChange(String name, Object o, Object n) {
        super.firePropertyChange(name, o, n);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class Listener
    implements PropertyChangeListener {
        protected Listener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            AbstractDebugger d = (AbstractDebugger)e.getSource();
            if (e.getPropertyName().equals("state")) {
                AbstractDebugger dd = DelegatingDebugger.this.getCurrentDebugger();
                if (d.getState() == 1) {
                    DelegatingDebugger.this.removeDebugger(d);
                }
                if (d != dd) {
                    return;
                }
                DelegatingDebugger.this.firePropertyChange("state", e.getOldValue(), e.getNewValue());
            } else if (e.getPropertyName().equals("debuggerState")) {
                if (d != DelegatingDebugger.this.getCurrentDebugger()) {
                    return;
                }
                DelegatingDebugger.this.firePropertyChange("debuggerState", e.getOldValue(), e.getNewValue());
            } else if (e.getPropertyName().equals("currentThread")) {
                if (d != DelegatingDebugger.this.getCurrentDebugger()) {
                    return;
                }
                DelegatingDebugger.this.firePropertyChange("currentThread", e.getOldValue(), e.getNewValue());
            } else if (e.getPropertyName().equals("currentLine")) {
                if (d != DelegatingDebugger.this.getCurrentDebugger()) {
                    return;
                }
                DelegatingDebugger.this.firePropertyChange("currentLine", e.getOldValue(), e.getNewValue());
            } else if (e.getPropertyName().equals("lastAction")) {
                if (d != DelegatingDebugger.this.getCurrentDebugger()) {
                    return;
                }
                DelegatingDebugger.this.firePropertyChange("lastAction", e.getOldValue(), e.getNewValue());
            }
        }
    }
}

