/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.delegator;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.ConnectSupport;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.DebuggerCoreImpl;
import org.netbeans.modules.debugger.DebuggerImpl;
import org.netbeans.modules.debugger.EventsProducer;
import org.netbeans.modules.debugger.Register;
import org.netbeans.modules.debugger.delegator.ConnectorPanel;
import org.netbeans.modules.debugger.delegator.DelegatingDebugger;
import org.netbeans.modules.debugger.support.actions.AddBreakpointAction;
import org.netbeans.modules.debugger.support.actions.ConnectAction;
import org.openide.util.actions.SystemAction;

public class DelegatingDebuggerImpl
extends DebuggerImpl
implements EventsProducer,
DebuggerCoreImpl,
ConnectSupport {
    private static CoreBreakpoint.Event[] breakpointEvents = new CoreBreakpoint.Event[0];
    private static ArrayList globalEvents = new ArrayList();
    private ArrayList debuggerImpls;
    private boolean supportsConnect = false;
    private boolean supportsExpressions = false;
    private WeakHashMap debuggerToImpl = new WeakHashMap();
    protected transient PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private Listener listener;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$ConnectAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction;

    public String getDisplayName() {
        return DelegatingDebugger.getLocString("CTL_Debugger_version");
    }

    public synchronized AbstractDebugger createDebugger() {
        List dis = this.getDebuggerImpls();
        if (dis.size() < 1) {
            return null;
        }
        DebuggerImpl di = (DebuggerImpl)dis.get(0);
        return this.createDebugger(di);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    protected void firePropertyChange(String name, Object o, Object n) {
        this.pcs.firePropertyChange(name, o, n);
    }

    public DebuggerImpl getDebuggerImpl(AbstractDebugger debugger) {
        if (this.debuggerImpls == null) {
            this.initDebuggerImplsSet();
        }
        return (DebuggerImpl)this.debuggerToImpl.get(debugger);
    }

    public JComponent getConnectPanel() {
        if (this.debuggerImpls == null) {
            this.initDebuggerImplsSet();
        }
        if (!this.supportsConnect) {
            return null;
        }
        return new ConnectorPanel(this.getDebuggerImpls());
    }

    public CoreBreakpoint.Event[] getEvents() {
        if (this.debuggerImpls == null) {
            this.initDebuggerImplsSet();
        }
        return breakpointEvents;
    }

    public void registerEvent(CoreBreakpoint.Event e) {
        CoreBreakpoint.Event[] old = breakpointEvents;
        CoreBreakpoint.Event[] bes = new CoreBreakpoint.Event[breakpointEvents.length + 1];
        System.arraycopy(breakpointEvents, 0, bes, 0, breakpointEvents.length);
        bes[DelegatingDebuggerImpl.breakpointEvents.length] = e;
        globalEvents.add(e);
        breakpointEvents = bes;
        this.firePropertyChange("events", old, breakpointEvents);
    }

    boolean supportsConnectAction() {
        if (this.debuggerImpls == null) {
            this.initDebuggerImplsSet();
        }
        return this.supportsConnect;
    }

    public AbstractDebugger createDebugger(DebuggerImpl di) {
        if (this.debuggerImpls == null) {
            this.initDebuggerImplsSet();
        }
        if (di == null) {
            return this.createDebugger();
        }
        AbstractDebugger d = di.createDebugger();
        this.debuggerToImpl.put(d, di);
        d.addPropertyChangeListener(this.listener);
        return d;
    }

    static DelegatingDebuggerImpl getDelegatingImpl() {
        return (DelegatingDebuggerImpl)Register.getDebuggerCoreImpl();
    }

    synchronized List getDebuggerImpls() {
        if (this.debuggerImpls == null) {
            this.initDebuggerImplsSet();
        }
        return Collections.unmodifiableList(this.debuggerImpls);
    }

    private void initDebuggerImplsSet() {
        this.debuggerImpls = new ArrayList();
        if (this.listener == null) {
            this.listener = new Listener();
        }
        Register.addRegisterListener(this.listener);
        List l = Register.getDebuggerImpls();
        int k = l.size();
        boolean up = false;
        int i = 0;
        while (i < k) {
            DebuggerImpl debuggerImpl = (DebuggerImpl)l.get(i);
            this.debuggerImpls.add(debuggerImpl);
            if (debuggerImpl instanceof EventsProducer) {
                up = true;
            }
            ++i;
        }
        if (up) {
            this.updateEventSet();
        }
        this.updateConnectState();
    }

    private synchronized void registerDebuggerImpl(DebuggerImpl debuggerImpl) {
        this.debuggerImpls.add(debuggerImpl);
        if (debuggerImpl instanceof EventsProducer) {
            this.updateEventSet();
        }
        this.updateConnectState();
    }

    private synchronized void unregisterDebuggerImpl(DebuggerImpl debuggerImpl) {
        ((AbstractCollection)this.debuggerImpls).remove(debuggerImpl);
        if (debuggerImpl instanceof EventsProducer) {
            this.updateEventSet();
        }
        this.updateConnectState();
    }

    private synchronized void updateConnectState() {
        this.supportsConnect = false;
        int k = this.debuggerImpls.size();
        int i = 0;
        while (i < k) {
            DebuggerImpl impl = (DebuggerImpl)this.debuggerImpls.get(i);
            if (impl instanceof ConnectSupport) {
                this.supportsConnect = true;
            }
            ++i;
        }
        ConnectAction ca = (ConnectAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$ConnectAction == null ? (class$org$netbeans$modules$debugger$support$actions$ConnectAction = DelegatingDebuggerImpl.class$("org.netbeans.modules.debugger.support.actions.ConnectAction")) : class$org$netbeans$modules$debugger$support$actions$ConnectAction));
        ca.setEnabled(this.supportsConnect);
    }

    private synchronized void updateEventSet() {
        CoreBreakpoint.Event[] oldEs = breakpointEvents;
        HashMap<String, Object> breakpointEventsRegister = new HashMap<String, Object>();
        int k = globalEvents.size();
        int i = 0;
        while (i < k) {
            breakpointEventsRegister.put(((CoreBreakpoint.Event)globalEvents.get(i)).getTypeName(), globalEvents.get(i));
            ++i;
        }
        i = this.debuggerImpls.size() - 1;
        while (i >= 0) {
            DebuggerImpl impl = (DebuggerImpl)this.debuggerImpls.get(i);
            if (impl instanceof EventsProducer) {
                CoreBreakpoint.Event[] br = ((EventsProducer)((Object)impl)).getEvents();
                int jj = br.length;
                int j = 0;
                while (j < jj) {
                    CoreBreakpoint.Event old = (CoreBreakpoint.Event)breakpointEventsRegister.get(br[j].getTypeName());
                    if (old == null || old.getProperties().length < br[j].getProperties().length) {
                        breakpointEventsRegister.put(br[j].getTypeName(), br[j]);
                    }
                    ++j;
                }
            }
            --i;
        }
        k = breakpointEventsRegister.size();
        breakpointEvents = new CoreBreakpoint.Event[k];
        int ins = 0;
        int k2 = globalEvents.size();
        int i2 = 0;
        while (i2 < k2) {
            CoreBreakpoint.Event c = (CoreBreakpoint.Event)globalEvents.get(i2);
            CoreBreakpoint.Event c2 = (CoreBreakpoint.Event)breakpointEventsRegister.get(c.getTypeName());
            if (c2 == c) {
                DelegatingDebuggerImpl.breakpointEvents[ins++] = c2;
            }
            ++i2;
        }
        i2 = this.debuggerImpls.size() - 1;
        while (i2 >= 0) {
            DebuggerImpl impl = (DebuggerImpl)this.debuggerImpls.get(i2);
            if (impl instanceof EventsProducer) {
                CoreBreakpoint.Event[] br = ((EventsProducer)((Object)impl)).getEvents();
                int jj = br.length;
                int j = 0;
                while (j < jj) {
                    CoreBreakpoint.Event c2 = (CoreBreakpoint.Event)breakpointEventsRegister.get(br[j].getTypeName());
                    if (c2 == br[j]) {
                        DelegatingDebuggerImpl.breakpointEvents[ins++] = c2;
                    }
                    ++j;
                }
            }
            --i2;
        }
        AddBreakpointAction aba = (AddBreakpointAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction == null ? (class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction = DelegatingDebuggerImpl.class$("org.netbeans.modules.debugger.support.actions.AddBreakpointAction")) : class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction));
        aba.setEnabled(k > 0);
        this.firePropertyChange("events", oldEs, breakpointEvents);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class Listener
    extends Register.RegisterListener
    implements PropertyChangeListener {
        Listener() {
        }

        public void debuggerImplAdded(DebuggerImpl debuggerImpl) {
            DelegatingDebuggerImpl.this.registerDebuggerImpl(debuggerImpl);
        }

        public void debuggerImplRemoved(DebuggerImpl debuggerImpl) {
            DelegatingDebuggerImpl.this.unregisterDebuggerImpl(debuggerImpl);
        }

        public void propertyChange(PropertyChangeEvent ev) {
            AbstractDebugger d;
            if (ev.getPropertyName().equals("state") && (d = (AbstractDebugger)ev.getSource()).getState() == 1) {
                DelegatingDebuggerImpl.this.debuggerToImpl.remove(d);
                d.removePropertyChangeListener(this);
            }
        }
    }
}

