/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.multisession;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Map;
import org.netbeans.modules.debugger.support.java.JUtils;
import org.openide.execution.ExecInfo;
import org.openide.execution.NbClassPath;
import org.openide.execution.NbProcessDescriptor;
import org.openide.execution.ProcessExecutor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class DebuggerExecutor
extends ProcessExecutor {
    static final long serialVersionUID = 1440216775212461457L;
    public static String PROP_DEBUGGER_EXECUTOR_TYPE = "debuggerExecutorType";
    public static String PROP_CLASSIC_SWITCH = "classicSwitch";
    public static final String PROP_ASSERT_ENABLED = "assertEnabled";
    static final NbProcessDescriptor[] DEFAULT;
    static String[] description;
    private static boolean[] classicPreferred;
    private static boolean classicPreferredResolved;
    private NbProcessDescriptor[] debuggerProcess;
    private Integer selectedType;
    private boolean[] classicValue = new boolean[]{false, false};
    private boolean[] isClassicSet = new boolean[]{false, false};
    private boolean bootClassPathSetManually = false;
    private boolean assertEnabled = false;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$multisession$DebuggerExecutor;

    private void readObject(ObjectInputStream oos) throws IOException, ClassNotFoundException {
        oos.defaultReadObject();
        if (this.classicValue == null) {
            this.classicValue = new boolean[]{false, false};
        }
        if (this.isClassicSet == null) {
            this.isClassicSet = new boolean[]{false, false};
        }
        if (this.debuggerProcess == null || this.selectedType == null) {
            this.init();
        }
        this.initBootClassPath();
    }

    private void init() {
        this.selectedType = new Integer(0);
        this.bootClassPathSetManually = false;
        this.debuggerProcess = new NbProcessDescriptor[DEFAULT.length];
        int x = 0;
        while (x < DEFAULT.length) {
            this.debuggerProcess[x] = DEFAULT[x];
            ++x;
        }
        this.setName(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$multisession$DebuggerExecutor == null ? (class$org$netbeans$modules$debugger$multisession$DebuggerExecutor = DebuggerExecutor.class$("org.netbeans.modules.debugger.multisession.DebuggerExecutor")) : class$org$netbeans$modules$debugger$multisession$DebuggerExecutor)).getString("CTL_DebuggerExecutorDisplayName"));
        this.setExternalExecutor(this.debuggerProcess[this.selectedType]);
    }

    private void initBootClassPath() {
        if (this.bootClassPathSetManually) {
            return;
        }
        String fileSeparator = System.getProperty("file.separator");
        String pathSeparator = System.getProperty("path.separator");
        String javaRoot = System.getProperty("java.home") + fileSeparator;
        String javaRoot1 = System.getProperty("jdk.home") + fileSeparator;
        String bootClassPath = NbClassPath.createBootClassPath().getClassPath();
        if (bootClassPath.startsWith("\"")) {
            bootClassPath = bootClassPath.substring(1, bootClassPath.length());
        }
        if (bootClassPath.endsWith("\"")) {
            bootClassPath = bootClassPath.substring(0, bootClassPath.length() - 1);
        }
        super.setBootClassPath(new NbClassPath(javaRoot1 + "lib" + fileSeparator + "tools.jar" + pathSeparator + bootClassPath));
    }

    public DebuggerExecutor() {
        this.init();
        this.initBootClassPath();
    }

    public Integer getDebuggerExecutorType() {
        this.debuggerProcess[this.selectedType.intValue()] = this.getExternalExecutor();
        return this.selectedType;
    }

    public void setDebuggerExecutorType(Integer sel) {
        this.debuggerProcess[this.selectedType.intValue()] = this.getExternalExecutor();
        this.selectedType = sel > DEFAULT.length ? new Integer(0) : sel;
        this.setExternalExecutor(this.debuggerProcess[this.selectedType]);
        this.setClassic(this.isClassic());
    }

    public synchronized void setBootClassPath(NbClassPath path) {
        String oldPath = this.getBootClassPath().getClassPath();
        super.setBootClassPath(path);
        if (!this.bootClassPathSetManually) {
            String pathSeparator = System.getProperty("path.separator");
            String newPath = this.getBootClassPath().getClassPath();
            if (oldPath.endsWith(pathSeparator)) {
                oldPath = oldPath.substring(0, oldPath.length() - pathSeparator.length());
            }
            if (newPath.endsWith(pathSeparator)) {
                newPath = newPath.substring(0, newPath.length() - pathSeparator.length());
            }
            if (!oldPath.equals(newPath)) {
                this.bootClassPathSetManually = true;
            }
        }
    }

    public boolean isClassic() {
        int index = this.selectedType;
        if (this.isClassicSet[index]) {
            return this.classicValue[index];
        }
        if (!classicPreferredResolved) {
            String processName = System.getProperty("jdk.home") + File.separatorChar + "bin" + File.separatorChar + "java";
            DebuggerExecutor.classicPreferred[0] = JUtils.classicPreferred(processName);
            DebuggerExecutor.classicPreferred[1] = Utilities.getOperatingSystem() == 2048 ? false : JUtils.hasHotSpot(processName);
            classicPreferredResolved = true;
        }
        return classicPreferred[index];
    }

    public void setClassic(boolean classic) {
        int index = this.selectedType;
        if (this.classicValue[index] == classic) {
            return;
        }
        this.isClassicSet[index] = true;
        boolean old = this.classicValue[index];
        this.classicValue[index] = classic;
        this.firePropertyChange(PROP_CLASSIC_SWITCH, old ? Boolean.TRUE : Boolean.FALSE, classic ? Boolean.TRUE : Boolean.FALSE);
    }

    protected Process createProcess(ExecInfo info) throws IOException {
        return this.getExternalExecutor().exec((java.text.Format)((Object)new Format(info, this.getClassPath(), this.getBootClassPath(), this.getRepositoryPath(), this.getLibraryPath(), this.isClassic(), this.isAssertEnabled())), this.getEnvironmentVariables(), this.getWorkingDirectory());
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$modules$debugger$multisession$DebuggerExecutor == null ? (class$org$netbeans$modules$debugger$multisession$DebuggerExecutor = DebuggerExecutor.class$("org.netbeans.modules.debugger.multisession.DebuggerExecutor")) : class$org$netbeans$modules$debugger$multisession$DebuggerExecutor);
    }

    public boolean isAssertEnabled() {
        return this.assertEnabled;
    }

    public void setAssertEnabled(boolean assertFlag) {
        if (this.assertEnabled == assertFlag) {
            return;
        }
        this.assertEnabled = assertFlag;
        this.firePropertyChange(PROP_ASSERT_ENABLED, !assertFlag ? Boolean.TRUE : Boolean.FALSE, assertFlag ? Boolean.TRUE : Boolean.FALSE);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        classicPreferred = new boolean[]{false, false};
        classicPreferredResolved = false;
        int[] version = JUtils.getJavaVersion();
        boolean hasAgentDebugging = version[0] == 1 && version[1] < 4;
        description = new String[hasAgentDebugging ? 2 : 1];
        DEFAULT = new NbProcessDescriptor[hasAgentDebugging ? 2 : 1];
        if (hasAgentDebugging) {
            DebuggerExecutor.description[1] = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$multisession$DebuggerExecutor == null ? (class$org$netbeans$modules$debugger$multisession$DebuggerExecutor = DebuggerExecutor.class$("org.netbeans.modules.debugger.multisession.DebuggerExecutor")) : class$org$netbeans$modules$debugger$multisession$DebuggerExecutor)).getString("CTL_JDK11DebuggerExecutorName");
            DebuggerExecutor.DEFAULT[1] = new NbProcessDescriptor("{java.home}{/}bin{/}java", "{classic}-Xdebug -Djava.compiler=NONE -Xbootclasspath:{bootclasspath} -cp {filesystems} {classname} {arguments}", new ProcessExecutor().getExternalExecutor().getInfo());
        }
        DebuggerExecutor.description[0] = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$multisession$DebuggerExecutor == null ? (class$org$netbeans$modules$debugger$multisession$DebuggerExecutor = DebuggerExecutor.class$("org.netbeans.modules.debugger.multisession.DebuggerExecutor")) : class$org$netbeans$modules$debugger$multisession$DebuggerExecutor)).getString("CTL_JPDADebuggerExecutorName");
        DebuggerExecutor.DEFAULT[0] = new NbProcessDescriptor("{java.home}{/}bin{/}java", "{classic}{assertEnabled}-Xdebug -Xnoagent -Xrunjdwp:transport=dt_socket,server=y,suspend=n -Djava.compiler=NONE -Xbootclasspath:{bootclasspath} -cp {filesystems} {classname} {arguments}", new ProcessExecutor().getExternalExecutor().getInfo());
    }

    public static class Format
    extends ProcessExecutor.Format {
        public static final String TAG_CLASSIC_SWITCH = "classic";
        public static final String TAG_ASSERT_ENABLED = "assertEnabled";
        static final long serialVersionUID = 1070082399063112986L;

        public Format(ExecInfo info, NbClassPath classPath, NbClassPath bootClassPath, NbClassPath repository, NbClassPath library, boolean isClassic, boolean isAssertEnabled) {
            super(info, classPath, bootClassPath, repository, library);
            Map map = this.getMap();
            map.put(TAG_CLASSIC_SWITCH, isClassic ? "-classic " : "");
            map.put("assertEnabled", isAssertEnabled ? "-ea " : "");
        }
    }
}

