/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.multisession;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.AbstractDebuggerInfo;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.Register;
import org.netbeans.modules.debugger.Validator;
import org.netbeans.modules.debugger.ValidatorHolder;
import org.netbeans.modules.debugger.delegator.DelegatingBreakpoint;
import org.netbeans.modules.debugger.delegator.DelegatingDebugger;
import org.netbeans.modules.debugger.delegator.DelegatingDebuggerImpl;
import org.netbeans.modules.debugger.multisession.FinishActionPanel;
import org.netbeans.modules.debugger.multisession.Session;
import org.netbeans.modules.debugger.multisession.SessionBreakpoint;
import org.netbeans.modules.debugger.multisession.SessionsListener;
import org.netbeans.modules.debugger.support.DebuggerContextSettings;
import org.netbeans.modules.debugger.support.DebuggerModule;
import org.netbeans.modules.debugger.support.actions.ContinueAction;
import org.netbeans.modules.debugger.support.actions.FinishAction;
import org.netbeans.modules.debugger.support.actions.FixAction;
import org.netbeans.modules.debugger.support.actions.GoToCalledMethodAction;
import org.netbeans.modules.debugger.support.actions.GoToCallingMethodAction;
import org.netbeans.modules.debugger.support.actions.PauseAction;
import org.netbeans.modules.debugger.support.actions.PopTopmostFrameAction;
import org.netbeans.modules.debugger.support.actions.RunToCursorAction;
import org.netbeans.modules.debugger.support.actions.StepIntoAction;
import org.netbeans.modules.debugger.support.actions.StepOutAction;
import org.netbeans.modules.debugger.support.actions.StepOverAction;
import org.netbeans.modules.debugger.support.util.Utils;
import org.netbeans.modules.debugger.support.util.ValidatorImpl;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.debugger.Breakpoint;
import org.openide.debugger.DebuggerException;
import org.openide.debugger.DebuggerInfo;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.actions.SystemAction;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public class EnterpriseDebugger
extends DelegatingDebugger
implements ValidatorHolder {
    static final long serialVersionUID = 1969501498004072694L;
    public static final String PROP_CURRENT_SESSION = "currentSession";
    public static final int RUN_SINGLE = 0;
    public static final int RUN_MULTI = 1;
    public static final int RUN_CANCEL = 2;
    private transient HashMap sessions = new HashMap();
    private transient Vector sessionsListener = new Vector();
    private transient HashSet startingDebuggers = new HashSet();
    private transient HashSet persistentSessions = new HashSet();
    private transient Validator validator;
    private StepIntoAction stepIntoAction;
    private StepOverAction stepOverAction;
    private StepOutAction stepOutAction;
    private GoToCalledMethodAction goToCalledMethodAction;
    private GoToCallingMethodAction goToCallingMethodAction;
    private RunToCursorAction runToCursorAction;
    private PauseAction pauseAction;
    private ContinueAction continueAction;
    private FinishAction finishAction;
    private FixAction fixAction;
    private PopTopmostFrameAction popTopmostFrameAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$multisession$EnterpriseDebugger;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$DebuggerContextSettings;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$delegator$DelegatingDebugger;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$StepIntoAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$StepOverAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$StepOutAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$GoToCalledMethodAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$GoToCallingMethodAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$FixAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$PopTopmostFrameAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$RunToCursorAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$PauseAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$ContinueAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$FinishAction;

    public EnterpriseDebugger() {
        this.setValidator(new ValidatorImpl());
    }

    static String getString(String s) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$debugger$multisession$EnterpriseDebugger == null ? (class$org$netbeans$modules$debugger$multisession$EnterpriseDebugger = EnterpriseDebugger.class$("org.netbeans.modules.debugger.multisession.EnterpriseDebugger")) : class$org$netbeans$modules$debugger$multisession$EnterpriseDebugger), (String)s);
    }

    static String getProcessName(AbstractDebugger d) {
        DebuggerInfo di = d.getDebuggerInfo();
        return di instanceof AbstractDebuggerInfo ? ((AbstractDebuggerInfo)di).getProcessName() : "process";
    }

    static String getLocationName(AbstractDebugger d) {
        DebuggerInfo di = d.getDebuggerInfo();
        return di instanceof AbstractDebuggerInfo ? ((AbstractDebuggerInfo)di).getLocationName() : "localhost";
    }

    protected void setDebugger(AbstractDebugger debugger) {
        super.setDebugger(debugger);
        Breakpoint[] bs = this.getBreakpoints();
        int i = 0;
        while (i < bs.length) {
            if (bs[i] instanceof DelegatingBreakpoint) {
                bs[i].remove();
                this.createBreakpoint(false).setEvent(((DelegatingBreakpoint)bs[i]).getEvent(this));
            }
            ++i;
        }
    }

    public void startDebugger(DebuggerInfo info) throws DebuggerException {
        super.startDebugger(info);
        WindowManager wm = WindowManager.getDefault();
        String workspaceName = ((DebuggerContextSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$debugger$support$DebuggerContextSettings == null ? (class$org$netbeans$modules$debugger$support$DebuggerContextSettings = EnterpriseDebugger.class$("org.netbeans.modules.debugger.support.DebuggerContextSettings")) : class$org$netbeans$modules$debugger$support$DebuggerContextSettings), (boolean)true)).getDesktop();
        Workspace workspace = wm.findWorkspace(workspaceName);
        if (workspace != null) {
            workspace.activate();
        }
        AbstractDebugger[] ds = this.getDebuggers();
        int action = 1;
        if (info != null && ds.length > 0) {
            action = this.showStartSessionDialog();
        }
        if (action == 2) {
            AbstractDebugger d = this.getCurrentDebugger();
            if (d == null && ds.length > 0) {
                d = ds[0];
            }
            this.setState(2);
            if (d != null) {
                this.setState(d.getState());
            } else {
                this.setState(1);
            }
            return;
        }
        if (action == 0) {
            int i = ds.length - 1;
            while (i >= 0) {
                ds[i].finishDebugger();
                --i;
            }
        }
        if (info == null) {
            return;
        }
        AbstractDebugger debugger = this.createDebugger(info);
        this.addDebugger(debugger);
        debugger.startDebugger(info);
        this.setCurrentDebugger(debugger);
        if (this.getDebuggers().length == 2) {
            Utils.setViewVisibility(DebuggerModule.SESSIONS_VIEW, true);
        }
    }

    public void finishDebugger() throws DebuggerException {
        AbstractDebugger[] ds = this.getDebuggers();
        if (ds.length != 0) {
            DebuggerContextSettings debuggerSettings = (DebuggerContextSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$debugger$support$DebuggerContextSettings == null ? (class$org$netbeans$modules$debugger$support$DebuggerContextSettings = EnterpriseDebugger.class$("org.netbeans.modules.debugger.support.DebuggerContextSettings")) : class$org$netbeans$modules$debugger$support$DebuggerContextSettings), (boolean)true);
            if (debuggerSettings.getShowFinishDialog() && !this.showFinishDialog()) {
                return;
            }
            int k = ds.length;
            int i = 0;
            while (i < k) {
                if (!this.isSessionPersistent(ds[i])) {
                    ds[i].finishDebugger();
                }
                ++i;
            }
        }
        super.finishDebugger();
    }

    public CoreBreakpoint createBreakpoint(boolean hidden) {
        SessionBreakpoint b = new SessionBreakpoint(hidden);
        this.getRootBreakpointGroup().addBreakpoint(b);
        this.addBreakpoint(b);
        return b;
    }

    protected void addDebugger(AbstractDebugger d) {
        super.addDebugger(d);
        this.fireSessionCreated(this.getSession(d));
        this.startingDebuggers.add(d);
    }

    protected void removeDebugger(AbstractDebugger d) {
        super.removeDebugger(d);
        Session s = (Session)this.sessions.remove(d);
        if (s != null) {
            this.fireSessionDeath(s);
        }
        this.removeEvents(d);
        this.startingDebuggers.remove(d);
        if (this.getDebuggers().length < 1) {
            StatusDisplayer.getDefault().setStatusText(EnterpriseDebugger.getString("CTL_Debugger_end"));
        }
    }

    protected DelegatingDebugger.Listener createListener() {
        return new SessionListener();
    }

    public Validator getValidator() {
        return this.validator;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public void setSessionPersistent(AbstractDebugger d, boolean p) {
        if (p) {
            this.persistentSessions.add(d);
        } else {
            this.persistentSessions.remove(d);
        }
    }

    public boolean isSessionPersistent(AbstractDebugger d) {
        return this.persistentSessions.contains(d);
    }

    private int showStartSessionDialog() {
        DebuggerContextSettings debuggerSettings = (DebuggerContextSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$debugger$support$DebuggerContextSettings == null ? (class$org$netbeans$modules$debugger$support$DebuggerContextSettings = EnterpriseDebugger.class$("org.netbeans.modules.debugger.support.DebuggerContextSettings")) : class$org$netbeans$modules$debugger$support$DebuggerContextSettings), (boolean)true);
        if (!debuggerSettings.getShowRunMultisessionDialog()) {
            return debuggerSettings.getRunMultisession() ? 1 : 0;
        }
        AbstractDebugger[] ds = this.getDebuggers();
        String msg = null;
        String title = EnterpriseDebugger.getString("TITLE_Start_session_dialog");
        int debuggersCount = ds.length;
        if (debuggersCount > 1) {
            msg = new MessageFormat(EnterpriseDebugger.getString("MSG_Start_session_dialog")).format(new Object[]{new Integer(debuggersCount)});
        } else {
            DebuggerInfo info = ds[0].getDebuggerInfo();
            String s = info instanceof AbstractDebuggerInfo ? ((AbstractDebuggerInfo)info).getProcessName() : "process";
            msg = new MessageFormat(EnterpriseDebugger.getString("MSG_Start_second_session_dialog")).format(new Object[]{s});
        }
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout(0, 8));
        JTextArea textArea = new JTextArea(msg);
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(true);
        textArea.setEditable(false);
        textArea.setEnabled(false);
        textArea.setOpaque(false);
        textArea.setFont(UIManager.getFont("Label.font"));
        textArea.setDisabledTextColor(UIManager.getColor("Label.foreground"));
        p.getAccessibleContext().setAccessibleName(EnterpriseDebugger.getString("ACS_MSG_Start_session_dialog"));
        p.getAccessibleContext().setAccessibleDescription(textArea.getText());
        p.add((Component)textArea, "North");
        JCheckBox chb = new JCheckBox();
        chb.setText(EnterpriseDebugger.getString("CTL_DNSTDNT"));
        chb.setMnemonic(EnterpriseDebugger.getString("CTL_DNSTDNT_Mnemonic").charAt(0));
        chb.getAccessibleContext().setAccessibleDescription(EnterpriseDebugger.getString("ACSD_CTL_DNSTDNT"));
        p.add((Component)chb, "South");
        p.setPreferredSize(new Dimension(100, 110));
        NotifyDescriptor.Confirmation descriptor = new NotifyDescriptor.Confirmation((Object)p, title);
        JButton fButton = new JButton(EnterpriseDebugger.getString("CTL_FinishAndStart"));
        fButton.setMnemonic(EnterpriseDebugger.getString("CTL_FinishAndStart_Mnemonic").charAt(0));
        fButton.getAccessibleContext().setAccessibleDescription(EnterpriseDebugger.getString("ACSD_CTL_FinishAndStart"));
        JButton sButton = new JButton(EnterpriseDebugger.getString("CTL_StartNewSession"));
        sButton.setMnemonic(EnterpriseDebugger.getString("CTL_StartNewSession_Mnemonic").charAt(0));
        sButton.getAccessibleContext().setAccessibleDescription(EnterpriseDebugger.getString("ACSD_CTL_StartNewSession"));
        descriptor.setOptions(new Object[]{fButton, sButton, NotifyDescriptor.CANCEL_OPTION});
        Object o = DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
        if (o == fButton) {
            debuggerSettings.setRunMultisession(false);
            debuggerSettings.setShowRunMultisessionDialog(!chb.isSelected());
            return 0;
        }
        if (o == sButton) {
            debuggerSettings.setRunMultisession(true);
            debuggerSettings.setShowRunMultisessionDialog(!chb.isSelected());
            return 1;
        }
        return 2;
    }

    protected AbstractDebugger createDebugger(DebuggerInfo info) {
        AbstractDebugger debugger = ((DelegatingDebuggerImpl)Register.getDebuggerCoreImpl()).createDebugger(info instanceof AbstractDebuggerInfo ? ((AbstractDebuggerInfo)info).getDebuggerImpl() : null);
        if (debugger instanceof ValidatorHolder) {
            ((ValidatorHolder)((Object)debugger)).setValidator(this.getValidator());
        }
        return debugger;
    }

    private boolean showFinishDialog() {
        final AbstractDebugger[] ds = this.getDebuggers();
        final Dialog[] d = new Dialog[1];
        final FinishActionPanel panel = new FinishActionPanel(this);
        panel.setSessions(ds);
        final DebuggerContextSettings debuggerSettings = (DebuggerContextSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$debugger$support$DebuggerContextSettings == null ? (class$org$netbeans$modules$debugger$support$DebuggerContextSettings = EnterpriseDebugger.class$("org.netbeans.modules.debugger.support.DebuggerContextSettings")) : class$org$netbeans$modules$debugger$support$DebuggerContextSettings), (boolean)true);
        panel.setShowFinishDialog(debuggerSettings.getShowFinishDialog());
        final boolean[] ok = new boolean[]{false};
        DialogDescriptor descriptor = new DialogDescriptor((Object)panel, EnterpriseDebugger.getString("CTL_Finish_debugging_dialog"), true, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (NotifyDescriptor.OK_OPTION.equals(e.getSource())) {
                    boolean[] state = panel.getState();
                    int jj = state.length;
                    int j = 0;
                    while (j < jj) {
                        EnterpriseDebugger.this.setSessionPersistent(ds[j], state[j]);
                        ++j;
                    }
                    ok[0] = true;
                    debuggerSettings.setShowFinishDialog(panel.getShowFinishDialog());
                }
                d[0].dispose();
            }
        });
        descriptor.setHelpCtx(new HelpCtx((class$org$netbeans$modules$debugger$delegator$DelegatingDebugger == null ? (class$org$netbeans$modules$debugger$delegator$DelegatingDebugger = EnterpriseDebugger.class$("org.netbeans.modules.debugger.delegator.DelegatingDebugger")) : class$org$netbeans$modules$debugger$delegator$DelegatingDebugger).getName() + ".dialog"));
        d[0] = DialogDisplayer.getDefault().createDialog(descriptor);
        d[0].show();
        return ok[0];
    }

    boolean wakeUpDebugger(AbstractDebugger d) {
        Session s = this.findSession(d);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)new MessageFormat(EnterpriseDebugger.getString("CTL_Hidden_debugger_on_breakpoint")).format(new Object[]{s.getSessionName()}), 0)) == NotifyDescriptor.YES_OPTION) {
            WindowManager dp = WindowManager.getDefault();
            Workspace w = dp.findWorkspace("Debugging");
            if (w != null) {
                w.activate();
            }
            this.setState(2);
            this.setState(3);
            this.debuggerStateChanged();
            try {
                this.startDebugger(null);
            }
            catch (DebuggerException ex) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    private void addEvents(AbstractDebugger debugger) {
        Breakpoint[] b = this.getBreakpoints();
        int k = b.length;
        int i = 0;
        while (i < k) {
            ((SessionBreakpoint)b[i]).addDebugger(debugger);
            ++i;
        }
    }

    private void removeEvents(AbstractDebugger debugger) {
        Breakpoint[] b = this.getBreakpoints();
        int k = b.length;
        int i = 0;
        while (i < k) {
            ((SessionBreakpoint)b[i]).removeDebugger(debugger);
            ++i;
        }
    }

    protected void debuggerStateChanged() {
        if (this.stepIntoAction == null) {
            this.stepIntoAction = (StepIntoAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$StepIntoAction == null ? (class$org$netbeans$modules$debugger$support$actions$StepIntoAction = EnterpriseDebugger.class$("org.netbeans.modules.debugger.support.actions.StepIntoAction")) : class$org$netbeans$modules$debugger$support$actions$StepIntoAction));
            this.stepOverAction = (StepOverAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$StepOverAction == null ? (class$org$netbeans$modules$debugger$support$actions$StepOverAction = EnterpriseDebugger.class$("org.netbeans.modules.debugger.support.actions.StepOverAction")) : class$org$netbeans$modules$debugger$support$actions$StepOverAction));
            this.stepOutAction = (StepOutAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$StepOutAction == null ? (class$org$netbeans$modules$debugger$support$actions$StepOutAction = EnterpriseDebugger.class$("org.netbeans.modules.debugger.support.actions.StepOutAction")) : class$org$netbeans$modules$debugger$support$actions$StepOutAction));
            this.goToCalledMethodAction = (GoToCalledMethodAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$GoToCalledMethodAction == null ? (class$org$netbeans$modules$debugger$support$actions$GoToCalledMethodAction = EnterpriseDebugger.class$("org.netbeans.modules.debugger.support.actions.GoToCalledMethodAction")) : class$org$netbeans$modules$debugger$support$actions$GoToCalledMethodAction));
            this.goToCallingMethodAction = (GoToCallingMethodAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$GoToCallingMethodAction == null ? (class$org$netbeans$modules$debugger$support$actions$GoToCallingMethodAction = EnterpriseDebugger.class$("org.netbeans.modules.debugger.support.actions.GoToCallingMethodAction")) : class$org$netbeans$modules$debugger$support$actions$GoToCallingMethodAction));
            this.fixAction = (FixAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$FixAction == null ? (class$org$netbeans$modules$debugger$support$actions$FixAction = EnterpriseDebugger.class$("org.netbeans.modules.debugger.support.actions.FixAction")) : class$org$netbeans$modules$debugger$support$actions$FixAction));
            this.popTopmostFrameAction = (PopTopmostFrameAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$PopTopmostFrameAction == null ? (class$org$netbeans$modules$debugger$support$actions$PopTopmostFrameAction = EnterpriseDebugger.class$("org.netbeans.modules.debugger.support.actions.PopTopmostFrameAction")) : class$org$netbeans$modules$debugger$support$actions$PopTopmostFrameAction));
            this.runToCursorAction = (RunToCursorAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$RunToCursorAction == null ? (class$org$netbeans$modules$debugger$support$actions$RunToCursorAction = EnterpriseDebugger.class$("org.netbeans.modules.debugger.support.actions.RunToCursorAction")) : class$org$netbeans$modules$debugger$support$actions$RunToCursorAction));
            this.pauseAction = (PauseAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$PauseAction == null ? (class$org$netbeans$modules$debugger$support$actions$PauseAction = EnterpriseDebugger.class$("org.netbeans.modules.debugger.support.actions.PauseAction")) : class$org$netbeans$modules$debugger$support$actions$PauseAction));
            this.continueAction = (ContinueAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$ContinueAction == null ? (class$org$netbeans$modules$debugger$support$actions$ContinueAction = EnterpriseDebugger.class$("org.netbeans.modules.debugger.support.actions.ContinueAction")) : class$org$netbeans$modules$debugger$support$actions$ContinueAction));
            this.finishAction = (FinishAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$FinishAction == null ? (class$org$netbeans$modules$debugger$support$actions$FinishAction = EnterpriseDebugger.class$("org.netbeans.modules.debugger.support.actions.FinishAction")) : class$org$netbeans$modules$debugger$support$actions$FinishAction));
        }
        this.stepIntoAction.checkEnabled();
        this.stepOverAction.setEnabled(this.getDebuggerState().isStepOverEnabled());
        this.stepOutAction.setEnabled(this.getDebuggerState().isStepOutEnabled());
        this.goToCalledMethodAction.setEnabled(this.getDebuggerState().isGoToCalledMethodEnabled());
        this.goToCallingMethodAction.setEnabled(this.getDebuggerState().isGoToCallingMethodEnabled());
        this.fixAction.setEnabled(this.getDebuggerState().isFixEnabled());
        this.popTopmostFrameAction.setEnabled(this.getDebuggerState().isPopTopmostFrameEnabled());
        this.runToCursorAction.checkEnabled();
        this.pauseAction.setEnabled(this.getDebuggerState().isPauseEnabled());
        this.continueAction.setEnabled(this.getDebuggerState().isContinueEnabled());
        this.finishAction.setEnabled(this.getState() != 1);
    }

    protected void firePropertyChange(String name, Object o, Object n) {
        super.firePropertyChange(name, o, n);
    }

    private Session getSession(AbstractDebugger d) {
        Session s = (Session)this.sessions.get(d);
        if (s == null) {
            s = new Session(d, d.getDebuggerInfo() == null ? this.getDebuggerInfo() : d.getDebuggerInfo());
            this.sessions.put(d, s);
            this.fireSessionCreated(s);
        }
        return s;
    }

    public void setCurrentDebugger(AbstractDebugger d) {
        if (this.getCurrentDebugger() == d) {
            return;
        }
        AbstractDebugger od = this.getCurrentDebugger();
        Session os = null;
        if (od != null) {
            os = this.getSession(od);
        }
        super.setCurrentDebugger(d);
        AbstractDebugger nd = this.getCurrentDebugger();
        Session ns = null;
        if (nd != null) {
            ns = this.getSession(nd);
        }
        this.firePropertyChange(PROP_CURRENT_SESSION, os, ns);
        this.debuggerStateChanged();
    }

    public void startSession(DebuggerInfo info) throws DebuggerException {
        AbstractDebugger debugger = this.createDebugger(info);
        this.addDebugger(debugger);
        debugger.startDebugger(info);
        this.setCurrentDebugger(debugger);
    }

    public void addSessionsListener(SessionsListener l) {
        this.sessionsListener.addElement(l);
    }

    public void removeSessionsListener(SessionsListener l) {
        this.sessionsListener.removeElement(l);
    }

    protected void fireSessionCreated(final Session s) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int k = EnterpriseDebugger.this.sessionsListener.size();
                int i = 0;
                while (i < k) {
                    ((SessionsListener)EnterpriseDebugger.this.sessionsListener.elementAt(i)).sessionCreated(s);
                    ++i;
                }
            }
        });
    }

    protected void fireSessionDeath(final Session s) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int k = EnterpriseDebugger.this.sessionsListener.size();
                int i = 0;
                while (i < k) {
                    ((SessionsListener)EnterpriseDebugger.this.sessionsListener.elementAt(i)).sessionDeath(s);
                    ++i;
                }
            }
        });
    }

    public AbstractDebugger getInnerDebugger() {
        return this.getCurrentDebugger();
    }

    public Session findSession(AbstractDebugger debugger) {
        return this.getSession(debugger);
    }

    public Session getCurrentSession() {
        AbstractDebugger d = this.getCurrentDebugger();
        if (d == null) {
            return null;
        }
        return this.getSession(d);
    }

    public void setCurrentSession(Session s) {
        if (s == null) {
            this.setCurrentDebugger(null);
        } else {
            this.setCurrentDebugger(s.getDebugger());
        }
    }

    public Session[] getSessions() {
        AbstractDebugger[] ds = this.getDebuggers();
        Session[] s = new Session[ds.length];
        int k = ds.length;
        int i = 0;
        while (i < k) {
            s[i] = this.getSession(ds[i]);
            ++i;
        }
        return s;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class SessionListener
    extends DelegatingDebugger.Listener {
        private SessionListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            AbstractDebugger d = (AbstractDebugger)e.getSource();
            int ns = d.getState();
            if (e.getPropertyName().equals("state")) {
                if (ns != 2 && ns != 1 && EnterpriseDebugger.this.startingDebuggers.contains(d)) {
                    EnterpriseDebugger.this.addEvents(d);
                    EnterpriseDebugger.this.startingDebuggers.remove(d);
                }
            } else if (e.getPropertyName().equals("debuggerState")) {
                EnterpriseDebugger.this.debuggerStateChanged();
            }
            super.propertyChange(e);
        }
    }
}

