/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.multisession;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.InvocationTargetException;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.AbstractDebuggerInfo;
import org.netbeans.modules.debugger.AbstractThread;
import org.netbeans.modules.debugger.Register;
import org.netbeans.modules.debugger.ThreadsProducer;
import org.netbeans.modules.debugger.ThreadsRoot;
import org.netbeans.modules.debugger.multisession.EnterpriseDebugger;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.debugger.DebuggerException;
import org.openide.debugger.DebuggerInfo;
import org.openide.util.NbBundle;

public class Session {
    public static final String STATE_CONNECTED = "Connected";
    public static final String STATE_DISCONNECTED = "Disconnected";
    public static final String STATE_HIDDEN = "Hidden";
    public static final String STATE_NOT_RUNNING = "Not Running";
    public static final int ACTION_FINISH = 0;
    public static final int ACTION_DISCONNECT = 1;
    public static final int ACTION_HIDE = 2;
    public static final String PROP_HIDDEN = "hidden";
    public static final String PROP_PERSISTENT = "persistent";
    public static final String PROP_CONNECTION_STATE = "connectionState";
    public static final String PROP_CURRENT = "current";
    public static final String PROP_CONNECTED = "connected";
    public static final String PROP_ACTION_ON_FINISH = "actionOnFinish";
    private boolean connected = true;
    private boolean running = true;
    private String connectionState = "Connected";
    private int actionOnFinish = 2;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private AbstractDebugger debugger;
    private EnterpriseDebugger coreDebugger;
    private DebuggerListener debuggerListener;
    private DebuggerInfo debuggerInfo;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$multisession$Session;

    public Session(AbstractDebugger debugger, DebuggerInfo info) {
        this(null, null, debugger, info);
    }

    public Session(String sessionName, String locationName, AbstractDebugger debugger, DebuggerInfo info) {
        this.debugger = debugger;
        this.debuggerInfo = info;
        this.coreDebugger = (EnterpriseDebugger)Register.getCoreDebugger();
        this.debuggerListener = new DebuggerListener();
        debugger.addPropertyChangeListener(this.debuggerListener);
        this.coreDebugger.addPropertyChangeListener(this.debuggerListener);
    }

    public boolean isPersistent() {
        return this.coreDebugger.isSessionPersistent(this.debugger);
    }

    public void setPersistent(boolean p) {
        this.coreDebugger.setSessionPersistent(this.debugger, p);
        this.firePropertyChange(PROP_PERSISTENT, !p ? Boolean.TRUE : Boolean.FALSE, p ? Boolean.TRUE : Boolean.FALSE);
    }

    public AbstractDebugger getDebugger() {
        return this.debugger;
    }

    public AbstractThread getCurrentThread() {
        if (this.debugger instanceof ThreadsRoot) {
            return ((ThreadsRoot)((Object)this.debugger)).getCurrentThread();
        }
        return null;
    }

    public ThreadsProducer getThreadsProducer() {
        if (this.debugger instanceof ThreadsRoot) {
            return ((ThreadsRoot)((Object)this.debugger)).getThreadsRoot();
        }
        return null;
    }

    protected DebuggerInfo getDebuggerInfo() {
        DebuggerInfo info1 = this.debugger.getDebuggerInfo();
        return info1 == null ? this.debuggerInfo : info1;
    }

    public String getSessionName() {
        DebuggerInfo info = this.getDebuggerInfo();
        return info instanceof AbstractDebuggerInfo ? ((AbstractDebuggerInfo)info).getProcessName() : "process";
    }

    public String getLocationName() {
        DebuggerInfo info = this.getDebuggerInfo();
        return info instanceof AbstractDebuggerInfo ? ((AbstractDebuggerInfo)info).getLocationName() : "localhost";
    }

    public int getActionOnFinish() {
        return this.actionOnFinish;
    }

    public void setActionOnFinish(int action) {
        if (this.actionOnFinish == action) {
            return;
        }
        int old = this.actionOnFinish;
        this.actionOnFinish = action;
        this.firePropertyChange(PROP_ACTION_ON_FINISH, new Integer(old), new Integer(this.actionOnFinish));
    }

    public String getConnectionState() {
        return this.connectionState;
    }

    protected void setConnectionState(String connectionState) {
        if (this.connectionState == connectionState) {
            return;
        }
        if (connectionState != STATE_CONNECTED && connectionState != STATE_DISCONNECTED && connectionState != STATE_HIDDEN && connectionState != STATE_NOT_RUNNING) {
            throw new InternalError("Unknown connectionState constant");
        }
        String old = this.connectionState;
        this.connectionState = connectionState;
        this.firePropertyChange(PROP_CONNECTION_STATE, old, connectionState);
    }

    public boolean isCurrent() {
        return this.debugger == this.coreDebugger.getCurrentDebugger();
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean connected) {
        if (connected == this.connected) {
            return;
        }
        if (connected) {
            // empty if block
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isHidden() {
        return this.connectionState == STATE_HIDDEN;
    }

    public void setHidden(boolean hidden) {
        if (this.isHidden() == hidden) {
            return;
        }
        if (hidden) {
            this.setConnectionState(STATE_HIDDEN);
            this.firePropertyChange(PROP_HIDDEN, Boolean.FALSE, Boolean.TRUE);
        } else {
            if (this.isRunning()) {
                if (this.isConnected()) {
                    this.setConnectionState(STATE_CONNECTED);
                } else {
                    this.setConnectionState(STATE_DISCONNECTED);
                }
            } else {
                this.setConnectionState(STATE_NOT_RUNNING);
            }
            this.firePropertyChange(PROP_HIDDEN, Boolean.TRUE, Boolean.FALSE);
        }
    }

    public void start() {
        this.setHidden(false);
        if (!this.running) {
            try {
                this.getDebugger().startDebugger(this.getDebuggerInfo());
            }
            catch (DebuggerException ex) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Exception(((InvocationTargetException)((Object)ex)).getTargetException() == null ? ex : ((InvocationTargetException)((Object)ex)).getTargetException(), (Object)(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$multisession$Session == null ? (class$org$netbeans$modules$debugger$multisession$Session = Session.class$("org.netbeans.modules.debugger.multisession.Session")) : class$org$netbeans$modules$debugger$multisession$Session)).getString("EXC_Debugger") + ": " + ex.getMessage())));
            }
            return;
        }
    }

    public void finish() {
        if (this.isPersistent()) {
            switch (this.getActionOnFinish()) {
                case 0: {
                    this.finishIn();
                    break;
                }
                case 1: {
                    this.setConnected(false);
                    break;
                }
                case 2: {
                    this.setHidden(true);
                }
            }
        } else if (this.isConnected()) {
            this.finishIn();
        }
    }

    public boolean isDead() {
        AbstractDebugger[] ds = this.coreDebugger.getDebuggers();
        int k = ds.length;
        int i = 0;
        while (i < k) {
            if (ds[i] == this.debugger) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    protected void firePropertyChange(String name, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(name, oldValue, newValue);
    }

    protected void debuggerStateChanged(int debuggerState) {
        switch (debuggerState) {
            case 1: {
                if (this.connected) {
                    this.connected = false;
                    this.firePropertyChange(PROP_CONNECTED, Boolean.TRUE, Boolean.FALSE);
                }
                this.running = false;
                this.setConnectionState(STATE_NOT_RUNNING);
                this.debugger.removePropertyChangeListener(this.debuggerListener);
                this.coreDebugger.removePropertyChangeListener(this.debuggerListener);
                this.debuggerListener = null;
                break;
            }
            case 2: {
                if (this.getConnectionState() == STATE_HIDDEN) {
                    this.setConnectionState(STATE_DISCONNECTED);
                    return;
                }
                this.connected = true;
                this.setConnectionState(STATE_CONNECTED);
                this.firePropertyChange(PROP_CONNECTED, Boolean.FALSE, Boolean.TRUE);
            }
        }
    }

    void finishIn() {
        Session[] allSessions = this.coreDebugger.getSessions();
        int n = allSessions.length;
        if (allSessions != null) {
            int i = 0;
            while (i < n) {
                if (allSessions[i] != this && allSessions[i].getDebugger() == this.getDebugger()) {
                    return;
                }
                ++i;
            }
        }
        try {
            this.getDebugger().finishDebugger();
        }
        catch (DebuggerException ex) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Exception(((InvocationTargetException)((Object)ex)).getTargetException() == null ? ex : ((InvocationTargetException)((Object)ex)).getTargetException(), (Object)(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$multisession$Session == null ? (class$org$netbeans$modules$debugger$multisession$Session = Session.class$("org.netbeans.modules.debugger.multisession.Session")) : class$org$netbeans$modules$debugger$multisession$Session)).getString("EXC_Debugger") + ": " + ex.getMessage())));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class DebuggerListener
    implements PropertyChangeListener {
        private DebuggerListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName() == null) {
                return;
            }
            if (e.getPropertyName().equals("state")) {
                Session.this.debuggerStateChanged(Session.this.getDebugger().getState());
            } else if (e.getPropertyName().equals("currentSession")) {
                Session.this.pcs.firePropertyChange(Session.PROP_CURRENT, !Session.this.isCurrent(), Session.this.isCurrent());
            }
        }
    }
}

