/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.multisession;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.Register;
import org.netbeans.modules.debugger.multisession.EnterpriseDebugger;
import org.netbeans.modules.debugger.multisession.Session;
import org.netbeans.modules.debugger.support.BreakpointSupport;
import org.openide.debugger.Debugger;
import org.openide.nodes.Node;
import org.openide.text.Line;

public class SessionBreakpoint
extends BreakpointSupport {
    static final long serialVersionUID = 2246204002781932191L;
    private transient ArrayList events = null;
    private boolean doNotFire = false;

    SessionBreakpoint(boolean hidden) {
        super(hidden);
    }

    protected void init() {
        super.init();
    }

    public CoreBreakpoint.Event getEvent(Debugger d) {
        if (d == this.debugger) {
            return this.event;
        }
        if (this.events == null) {
            return null;
        }
        ArrayList arrayList = this.events;
        synchronized (arrayList) {
            int k = this.events.size();
            int i = 0;
            while (i < k) {
                CoreBreakpoint.Event e = (CoreBreakpoint.Event)this.events.get(i);
                if (d == e.getDebugger()) {
                    CoreBreakpoint.Event event = e;
                    return event;
                }
                ++i;
            }
        }
        return null;
    }

    public void remove() {
        super.remove();
        this.disposeEvents();
    }

    protected void setBreakpoint() {
        if (!this.isEnabled()) {
            return;
        }
        boolean valid = false;
        if (this.event != null) {
            Line[] l;
            valid = this.event.set();
            if (this.debugger.getState() == 1) {
                if (this.event instanceof CoreBreakpoint.SessionEvent) {
                    this.disposeEvents();
                }
            } else if (this.event instanceof CoreBreakpoint.SessionEvent) {
                int i;
                int k;
                if (this.events == null) {
                    AbstractDebugger[] ds = Register.getCoreDebugger().getDebuggers();
                    k = ds.length;
                    i = 0;
                    while (i < k) {
                        this.addEventForDebugger(ds[i]);
                        ++i;
                    }
                }
                if (this.events != null) {
                    ArrayList a = (ArrayList)this.events.clone();
                    k = a.size();
                    i = 0;
                    while (i < k) {
                        if (((CoreBreakpoint.Event)a.get(i)).set()) {
                            valid = true;
                        }
                        ++i;
                    }
                }
            }
            if ((l = this.event.getLines()) != null) {
                this.remark(new ArrayList<Line>(Arrays.asList(l)));
            } else {
                this.remark(null);
            }
        }
        this.setValid(valid);
    }

    protected void clearBreakpoint() {
        super.clearBreakpoint();
        if (this.events == null) {
            return;
        }
        if (this.event instanceof CoreBreakpoint.SessionEvent) {
            ArrayList arrayList = this.events;
            synchronized (arrayList) {
                int k = this.events.size();
                int i = 0;
                while (i < k) {
                    ((CoreBreakpoint.Event)this.events.get(i)).remove();
                    ++i;
                }
            }
        }
    }

    protected void fireEventPropertyChange(CoreBreakpoint.Event e, String s, Object o, Object n) {
        if (e != this.event) {
            return;
        }
        this.synchronizeProperties();
        this.firePropertyChange(s, o, n);
        if (this.isEnabled()) {
            this.setBreakpoint();
        } else if (this.event instanceof CoreBreakpoint.AnnotatableEvent) {
            ((CoreBreakpoint.AnnotatableEvent)((Object)this.event)).annotate();
        }
    }

    private void synchronizeProperties() {
        if (this.events == null) {
            return;
        }
        ArrayList a = (ArrayList)this.events.clone();
        int k = a.size();
        int i = 0;
        while (i < k) {
            this.synchronizeProperties((CoreBreakpoint.Event)a.get(i));
            ++i;
        }
    }

    private void synchronizeProperties(CoreBreakpoint.Event e) {
        if (this.event == null) {
            return;
        }
        Node.Property[] s = this.event.getProperties();
        Node.Property[] d = e.getProperties();
        int k = Math.min(d.length, s.length);
        int i = 0;
        while (i < k) {
            try {
                d[i].setValue(s[i].getValue());
            }
            catch (Exception ex) {
                // empty catch block
            }
            ++i;
        }
    }

    private void disposeEvents() {
        if (this.events == null) {
            return;
        }
        EnterpriseDebugger debugger = (EnterpriseDebugger)Register.getCoreDebugger();
        Session[] sessions = debugger.getSessions();
        ArrayList<AbstractDebugger> hidden = new ArrayList<AbstractDebugger>(sessions.length);
        int i = 0;
        while (i < sessions.length) {
            if (sessions[i].isHidden()) {
                hidden.add(sessions[i].getDebugger());
            }
            ++i;
        }
        ArrayList arrayList = this.events;
        synchronized (arrayList) {
            Iterator i2 = ((AbstractList)this.events).iterator();
            while (i2.hasNext()) {
                CoreBreakpoint.Event e = (CoreBreakpoint.Event)i2.next();
                if (hidden.contains(e.getDebugger())) continue;
                e.remove();
                e.dispose();
                i2.remove();
            }
            if (this.events.isEmpty()) {
                this.events = null;
            }
        }
    }

    private CoreBreakpoint.Event addEventForDebugger(AbstractDebugger debugger) {
        if (this.event == null) {
            return null;
        }
        if (this.event instanceof CoreBreakpoint.SessionEvent) {
            CoreBreakpoint.Event e = this.createEvent(debugger, this.event.getTypeName());
            if (e == null) {
                return null;
            }
            if (e instanceof CoreBreakpoint.SessionEvent) {
                ((CoreBreakpoint.SessionEvent)((Object)e)).synchronizeWith(this.event);
            }
            this.synchronizeProperties(e);
            if (this.events == null) {
                this.events = new ArrayList();
            }
            ArrayList arrayList = this.events;
            synchronized (arrayList) {
                this.events.add(e);
            }
            return e;
        }
        return this.event;
    }

    void addDebugger(AbstractDebugger debugger) {
        CoreBreakpoint.Event e = this.addEventForDebugger(debugger);
        if (e == null) {
            return;
        }
        if (this.isEnabled() && e.set()) {
            this.setValid(true);
        }
    }

    void removeDebugger(AbstractDebugger debugger) {
        if (this.events == null) {
            return;
        }
        ArrayList a = (ArrayList)this.events.clone();
        int k = a.size();
        int i = 0;
        while (i < k) {
            CoreBreakpoint.Event ee = (CoreBreakpoint.Event)a.get(i);
            if (ee.getDebugger() == debugger) {
                ee.remove();
                ee.dispose();
                ArrayList arrayList = this.events;
                synchronized (arrayList) {
                    ((AbstractCollection)this.events).remove(ee);
                }
                return;
            }
            ++i;
        }
        this.setBreakpoint();
    }
}

