/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support;

import java.io.Serializable;
import org.netbeans.modules.debugger.BreakpointGroup;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.support.BreakpointSupport;

public class BreakpointGroupSupport
extends BreakpointGroup
implements Serializable {
    static final long serialVersionUID = 368001278961932551L;
    public static final String PROP_TOP_BREAKPOINT = "topBreakpoint";
    private CoreBreakpoint topBreakpoint = null;

    public BreakpointGroupSupport(String name) {
        this.setName(name == null ? "" : name);
        this.init();
    }

    public boolean addBreakpoint(CoreBreakpoint breakpoint) {
        if (this.topBreakpoint != null && this.topBreakpoint != breakpoint) {
            breakpoint.setHidden(this.topBreakpoint.isHidden());
        }
        return super.addBreakpoint(breakpoint);
    }

    public boolean removeBreakpoint(CoreBreakpoint breakpoint) {
        if (super.removeBreakpoint(breakpoint)) {
            if (breakpoint == this.topBreakpoint) {
                this.setTopBreakpoint(null);
            }
            return true;
        }
        return false;
    }

    public void setName(String newName) {
        super.setName(newName);
    }

    public CoreBreakpoint getTopBreakpoint() {
        return this.topBreakpoint;
    }

    public void setTopBreakpoint(CoreBreakpoint breakpoint) {
        if (this.topBreakpoint == breakpoint) {
            return;
        }
        if (breakpoint != null) {
            this.addBreakpoint(breakpoint);
        }
        CoreBreakpoint old = this.topBreakpoint;
        this.topBreakpoint = breakpoint;
        if (this.topBreakpoint != null) {
            this.setHidden(this.topBreakpoint.isHidden());
        }
        this.firePropertyChange(PROP_TOP_BREAKPOINT, old, breakpoint);
    }

    public void deleteBreakpoints() {
        if (this.topBreakpoint != null) {
            this.delete();
            return;
        }
        CoreBreakpoint[] bs = this.getBreakpoints();
        int k = bs.length;
        int i = 0;
        while (i < k) {
            this.removeBreakpoint(bs[i]);
            bs[i].remove();
            ++i;
        }
        BreakpointGroup[] bgs = this.getGroups();
        k = bgs.length;
        i = 0;
        while (i < k) {
            if (bgs[i] instanceof BreakpointGroupSupport) {
                ((BreakpointGroupSupport)bgs[i]).deleteBreakpoints();
            }
            ++i;
        }
    }

    public void delete() {
        if (this.getParentGroup() != null) {
            this.getParentGroup().removeGroup(this);
        }
        CoreBreakpoint[] bs = this.getBreakpoints();
        int k = bs.length;
        int i = 0;
        while (i < k) {
            this.removeBreakpoint(bs[i]);
            bs[i].remove();
            ++i;
        }
        BreakpointGroup[] bgs = this.getGroups();
        k = bgs.length;
        i = 0;
        while (i < k) {
            if (bgs[i] instanceof BreakpointGroupSupport) {
                ((BreakpointGroupSupport)bgs[i]).delete();
            }
            ++i;
        }
    }

    public void setEnabled(boolean enabled) {
        CoreBreakpoint[] bs = this.getBreakpoints();
        int k = bs.length;
        int i = 0;
        while (i < k) {
            bs[i].setEnabled(enabled);
            ++i;
        }
        BreakpointGroup[] bgs = this.getGroups();
        k = bgs.length;
        i = 0;
        while (i < k) {
            if (bgs[i] instanceof BreakpointGroupSupport) {
                ((BreakpointGroupSupport)bgs[i]).setEnabled(enabled);
            }
            ++i;
        }
    }

    public void setHidden(boolean hidden) {
        CoreBreakpoint[] bs = this.getBreakpoints();
        int k = bs.length;
        int i = 0;
        while (i < k) {
            bs[i].setHidden(hidden);
            ++i;
        }
        BreakpointGroup[] bgs = this.getGroups();
        k = bgs.length;
        i = 0;
        while (i < k) {
            if (bgs[i] instanceof BreakpointGroupSupport) {
                ((BreakpointGroupSupport)bgs[i]).setHidden(hidden);
            }
            ++i;
        }
    }

    public String toString() {
        String n = this.getClass().getName();
        int i = n.lastIndexOf(46);
        if (i > 0) {
            n = n.substring(i + 1);
        }
        return n + this.hashCode() + "[nam. " + this.getName() + " :par. " + this.getParentGroup() + " :br. " + this.getBreakpoints().length + " :gr. " + this.getGroups().length + " :topB. " + (this.topBreakpoint instanceof BreakpointSupport ? ((BreakpointSupport)this.topBreakpoint).toStringIn() : "") + "]";
    }
}

