/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import org.netbeans.modules.debugger.BreakpointGroup;
import org.netbeans.modules.debugger.BreakpointProducer;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.DebuggerImpl;
import org.netbeans.modules.debugger.EventsProducer;
import org.netbeans.modules.debugger.Register;
import org.netbeans.modules.debugger.support.BreakpointGroupSupport;
import org.netbeans.modules.debugger.support.DebuggerSupport;
import org.netbeans.modules.debugger.support.LineBreakpointEvent;
import org.openide.debugger.Breakpoint;
import org.openide.loaders.DataObject;
import org.openide.src.ConstructorElement;
import org.openide.text.Line;

public class BreakpointSupport
extends CoreBreakpoint {
    static final long serialVersionUID = 3686204002781932191L;
    private boolean enabled = true;
    private boolean valid = false;
    private boolean hidden = false;
    protected ArrayList lines = null;
    protected boolean linesVisible = true;
    private BreakpointGroupSupport topGroup;
    private transient PropertyChangeListener topListener;
    private HashMap subEvents;

    protected BreakpointSupport(boolean hidden) {
        this.hidden = hidden;
    }

    protected void init() {
        super.init();
        if (this.enabled) {
            this.setBreakpoint();
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.remark(true);
        CoreBreakpoint.Event e = this.getEvent();
        if (e instanceof CoreBreakpoint.CompoundEvent) {
            this.topListener = new Listener();
            this.addPropertyChangeListener(this.topListener);
        }
    }

    public void remove() {
        this.clearBreakpoint();
        if (this.event != null) {
            this.setEvent(null);
        }
        super.remove();
        if (this.debugger instanceof DebuggerSupport) {
            ((DebuggerSupport)this.debugger).removeBreakpoint(this);
        }
        if (this.topGroup != null) {
            this.topGroup.delete();
        }
    }

    public Line getLine() {
        if (this.event instanceof LineBreakpointEvent) {
            return ((LineBreakpointEvent)this.event).getLine();
        }
        if (this.lines == null || this.lines.size() < 1) {
            return null;
        }
        return (Line)this.lines.get(0);
    }

    public String getClassName() {
        return null;
    }

    public ConstructorElement getMethod() {
        return null;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (enabled == this.enabled) {
            return;
        }
        boolean old = this.enabled;
        this.enabled = enabled;
        if (enabled) {
            this.setBreakpoint();
        } else {
            this.clearBreakpoint();
        }
        this.firePropertyChange("enabled", old ? Boolean.TRUE : Boolean.FALSE, enabled ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setEvent(CoreBreakpoint.Event e) {
        if (e != this.event) {
            this.clearBreakpoint();
            super.setEvent(e);
            this.setBreakpoint();
            this.updateSubEvents();
        }
    }

    private void updateSubEvents() {
        CoreBreakpoint.Event e = this.getEvent();
        if (e instanceof CoreBreakpoint.CompoundEvent) {
            CoreBreakpoint.CompoundEvent ce = (CoreBreakpoint.CompoundEvent)((Object)e);
            if (this.subEvents == null) {
                this.subEvents = new HashMap();
            }
            if (this.topGroup == null) {
                this.topGroup = new BreakpointGroupSupport("");
                this.topListener = new Listener();
                this.addPropertyChangeListener(this.topListener);
            }
            CoreBreakpoint.Event[] es = ce.getEvents();
            HashMap<CoreBreakpoint.Event, CoreBreakpoint.Event> newM = new HashMap<CoreBreakpoint.Event, CoreBreakpoint.Event>();
            int k = es.length;
            int i = 0;
            while (i < k) {
                if (!this.subEvents.containsKey(es[i])) {
                    CoreBreakpoint cb = ((BreakpointProducer)((Object)this.debugger)).createBreakpoint(true);
                    cb.setEvent(es[i]);
                    this.topGroup.addBreakpoint(cb);
                } else {
                    this.subEvents.remove(es[i]);
                }
                newM.put(es[i], es[i]);
                ++i;
            }
            Iterator it = this.subEvents.keySet().iterator();
            while (it.hasNext()) {
                ((CoreBreakpoint.Event)it.next()).getBreakpoint().remove();
            }
            this.subEvents = newM;
            if (this.isHidden()) {
                BreakpointGroup bg = this.topGroup.getParentGroup();
                if (bg != null) {
                    bg.removeGroup(this.topGroup);
                    bg.addBreakpoint(this);
                }
            } else if (this.topGroup.getParentGroup() == null) {
                this.getGroup().addGroup(this.topGroup);
                this.topGroup.setTopBreakpoint(this);
            }
            this.topGroup.setHidden(this.isHidden());
        } else {
            if (this.subEvents == null) {
                return;
            }
            Iterator it = this.subEvents.keySet().iterator();
            while (it.hasNext()) {
                ((CoreBreakpoint.Event)it.next()).getBreakpoint().remove();
            }
            if (this.topGroup != null) {
                BreakpointGroup bg = this.topGroup.getParentGroup();
                if (bg != null) {
                    bg.removeGroup(this.topGroup);
                    bg.addBreakpoint(this);
                }
                this.removePropertyChangeListener(this.topListener);
                this.topListener = null;
                this.topGroup = null;
            }
            this.subEvents = null;
        }
    }

    public void setHidden(boolean hidden) {
        if (this.hidden == hidden) {
            return;
        }
        this.hidden = hidden;
        this.updateSubEvents();
        if (this.topGroup != null) {
            this.topGroup.setHidden(this.isHidden());
        }
        this.firePropertyChange("hidden", !hidden ? Boolean.TRUE : Boolean.FALSE, hidden ? Boolean.TRUE : Boolean.FALSE);
        this.remark(!hidden && this.enabled);
    }

    protected void setValid(boolean valid) {
        if (valid == this.valid) {
            return;
        }
        boolean old = this.valid;
        this.valid = valid;
        this.firePropertyChange("valid", old ? Boolean.TRUE : Boolean.FALSE, valid ? Boolean.TRUE : Boolean.FALSE);
    }

    protected void fireEventPropertyChange(CoreBreakpoint.Event e, String s, Object o, Object n) {
        super.fireEventPropertyChange(e, s, o, n);
        if (this.enabled) {
            this.setBreakpoint();
        } else if (this.event instanceof CoreBreakpoint.AnnotatableEvent) {
            ((CoreBreakpoint.AnnotatableEvent)((Object)this.event)).annotate();
        }
    }

    protected void setBreakpoint() {
        if (!this.enabled) {
            return;
        }
        boolean valid = false;
        if (this.event != null) {
            valid = this.event.set();
            Line[] l = this.event.getLines();
            if (l != null) {
                this.remark(new ArrayList<Line>(Arrays.asList(l)));
            } else {
                this.remark(null);
            }
        }
        this.setValid(valid);
    }

    protected void clearBreakpoint() {
        this.remark(false);
        this.lines = null;
        if (this.event != null) {
            this.event.remove();
        }
        this.setValid(false);
    }

    protected void remark(boolean visible) {
        if (this.event instanceof CoreBreakpoint.AnnotatableEvent) {
            ((CoreBreakpoint.AnnotatableEvent)((Object)this.event)).annotate();
        }
    }

    protected void remark(ArrayList n) {
        if (this.event instanceof CoreBreakpoint.AnnotatableEvent) {
            ((CoreBreakpoint.AnnotatableEvent)((Object)this.event)).annotate();
        }
    }

    protected void remarkAll() {
        Breakpoint[] bs = Register.getCoreDebugger().getBreakpoints();
        int k = bs.length;
        int i = 0;
        while (i < k) {
            if (bs[i] instanceof BreakpointSupport && ((BreakpointSupport)bs[i]).linesVisible) {
                ((BreakpointSupport)bs[i]).remark(true);
            }
            ++i;
        }
    }

    public CoreBreakpoint.Action getAction(Class actionType) {
        CoreBreakpoint.Action[] actions = this.getActions();
        int k = actions.length;
        int i = 0;
        while (i < k) {
            if (actions[i].getClass().isAssignableFrom(actionType)) {
                return actions[i];
            }
            ++i;
        }
        return null;
    }

    public void setLine(Line line) {
        if (!(this.event instanceof LineBreakpointEvent)) {
            String mime = line.getDataObject().getPrimaryFile().getMIMEType();
            CoreBreakpoint.Event e = this.createEvent(line.getDataObject());
            ((LineBreakpointEvent)e).setLine(line);
            this.setEvent(e);
            return;
        }
        if (this.event != null) {
            ((LineBreakpointEvent)this.event).setLine(line);
        }
    }

    protected CoreBreakpoint.Event createEvent(DataObject obj) {
        DebuggerImpl impl = Register.getDebuggerCoreImpl();
        CoreBreakpoint.Event[] es = ((EventsProducer)((Object)impl)).getEvents();
        Object lbEvent = null;
        int k = es.length;
        boolean mime = false;
        int i = 0;
        while (i < k) {
            if (es[i] instanceof LineBreakpointEvent) {
                LineBreakpointEvent lbe = (LineBreakpointEvent)es[i];
                if (lbe.supportsDataObject(obj)) {
                    lbEvent = lbe;
                    break;
                }
                if (!mime && lbe.supportsMIMEType(obj.getPrimaryFile().getMIMEType())) {
                    mime = true;
                    lbEvent = lbe;
                } else if (lbEvent == null) {
                    lbEvent = lbe;
                }
            }
            ++i;
        }
        if (lbEvent != null) {
            try {
                return (CoreBreakpoint.Event)lbEvent.getClass().newInstance();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    public String toString() {
        String n = this.getClass().getName();
        int i = n.lastIndexOf(46);
        if (i > 0) {
            n = n.substring(i + 1);
        }
        return n + this.hashCode() + "[ev. " + this.event + " :gr. " + this.getGroup() + " :en. " + this.enabled + " :hi. " + this.hidden + " :va. " + this.valid + "]";
    }

    String toStringIn() {
        String n = this.getClass().getName();
        int i = n.lastIndexOf(46);
        if (i > 0) {
            n = n.substring(i + 1);
        }
        return n + this.hashCode() + "[ev. " + this.event + " :en. " + this.enabled + " :hi. " + this.hidden + " :va. " + this.valid + "]";
    }

    private class Listener
    implements PropertyChangeListener {
        private Listener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName() != null && e.getPropertyName() == "event") {
                BreakpointSupport.this.updateSubEvents();
            }
        }
    }
}

