/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.Vector;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.AbstractWatch;
import org.netbeans.modules.debugger.BreakpointGroup;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.CoreDebugger;
import org.netbeans.modules.debugger.DebuggerListener;
import org.netbeans.modules.debugger.State;
import org.netbeans.modules.debugger.support.BreakpointGroupSupport;
import org.netbeans.modules.debugger.support.BreakpointSupport;
import org.netbeans.modules.debugger.support.DebuggerProjectSettings;
import org.netbeans.modules.debugger.support.StateSupport;
import org.netbeans.modules.debugger.support.util.Find;
import org.openide.debugger.Breakpoint;
import org.openide.debugger.DebuggerException;
import org.openide.debugger.DebuggerInfo;
import org.openide.debugger.Watch;
import org.openide.src.ConstructorElement;
import org.openide.text.Line;
import org.openide.util.SharedClassObject;

public abstract class DebuggerSupport
extends CoreDebugger {
    static final long serialVersionUID = 2822234994389243393L;
    public static final State STATE_NOT_RUNNING = new StateSupport(17);
    private Vector breakpoints = new Vector();
    private Vector watches = new Vector();
    private BreakpointGroupSupport rootBreakpointGroup;
    private transient int lastAction = 6;
    private transient PropertyChangeSupport pcs;
    private transient Vector listener = new Vector();
    private transient Line currentLine = null;
    private transient int state = 1;
    private transient State debuggerState = STATE_NOT_RUNNING;
    private transient DebuggerProjectSettings settings;
    private transient boolean watchesInitialized = false;
    private transient boolean breakpointsInitialized = false;
    private transient DebuggerInfo debuggerInfo = null;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$DebuggerProjectSettings;

    public DebuggerSupport() {
        this.pcs = new PropertyChangeSupport(this);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.watches == null) {
            this.watches = new Vector();
        }
        this.watchesInitialized = true;
        if (this.breakpoints == null) {
            this.breakpoints = new Vector();
        }
        this.breakpointsInitialized = true;
    }

    protected void setDebugger(AbstractDebugger debugger) {
        this.removeAllBreakpoints();
        this.removeAllWatches();
        Breakpoint[] bs = debugger.getBreakpoints();
        int k = bs.length;
        int i = 0;
        while (i < k) {
            if (!bs[i].isHidden()) {
                this.breakpoints.addElement(bs[i]);
                this.fireBreakpointCreated(bs[i]);
            }
            ++i;
        }
        AbstractWatch[] ws = (AbstractWatch[])debugger.getWatches();
        k = ws.length;
        i = 0;
        while (i < k) {
            if (!ws[i].isHidden()) {
                this.watches.addElement(ws[i]);
                this.fireWatchCreated(ws[i]);
            }
            ++i;
        }
        BreakpointGroupSupport myRoot = (BreakpointGroupSupport)this.getRootBreakpointGroup();
        myRoot.delete();
        if (debugger instanceof DebuggerSupport) {
            BreakpointGroup oldRoot = ((DebuggerSupport)debugger).getRootBreakpointGroup();
            CoreBreakpoint[] cbs = oldRoot.getBreakpoints();
            k = cbs.length;
            i = 0;
            while (i < k) {
                myRoot.addBreakpoint(cbs[i]);
                ++i;
            }
            BreakpointGroup[] bgs = oldRoot.getGroups();
            k = bgs.length;
            i = 0;
            while (i < k) {
                myRoot.addGroup(bgs[i]);
                ++i;
            }
        }
    }

    public void startDebugger(DebuggerInfo info) throws DebuggerException {
        this.debuggerInfo = info;
    }

    public DebuggerInfo getDebuggerInfo() {
        return this.debuggerInfo;
    }

    public void finishDebugger() throws DebuggerException {
        this.setState(1);
        this.refreshBreakpoints();
        this.setCurrentLine(null);
    }

    public int getLastAction() {
        return this.lastAction;
    }

    protected void setLastAction(int lastAction) {
        int old = this.lastAction;
        this.lastAction = lastAction;
        this.firePropertyChange("lastAction", new Integer(old), new Integer(lastAction));
    }

    protected void setState(int newState) {
        if (newState == this.state) {
            return;
        }
        Integer old = new Integer(this.state);
        this.state = newState;
        this.firePropertyChange("state", old, new Integer(this.state));
    }

    public int getState() {
        return this.state;
    }

    protected void setDebuggerState(State newState) {
        if (newState.equals(this.debuggerState)) {
            return;
        }
        State old = this.debuggerState;
        this.debuggerState = newState;
        this.firePropertyChange("debuggerState", old, this.debuggerState);
    }

    public State getDebuggerState() {
        return this.debuggerState;
    }

    public Line getCurrentLine() {
        return this.currentLine;
    }

    protected void setCurrentLine(Line l) {
        Line old = this.currentLine;
        this.currentLine = l;
        this.firePropertyChange("currentLine", old, this.currentLine);
    }

    public CoreBreakpoint createBreakpoint(boolean hidden) {
        return new BreakpointSupport(hidden);
    }

    public Breakpoint createBreakpoint(Line l) {
        BreakpointSupport b = (BreakpointSupport)this.createBreakpoint(false);
        b.setLine(l);
        return b;
    }

    public Breakpoint createBreakpoint(Line l, boolean hidden) {
        BreakpointSupport b = (BreakpointSupport)this.createBreakpoint(hidden);
        b.setLine(l);
        return b;
    }

    public Breakpoint createBreakpoint(ConstructorElement method) {
        return this.createBreakpoint(method, false);
    }

    public Breakpoint createBreakpoint(ConstructorElement method, boolean hidden) {
        return null;
    }

    public Breakpoint findBreakpoint(Line l) {
        CoreBreakpoint[] bs = Find.breakpoint(this, l, true, true, true, true);
        if (bs.length > 0) {
            return bs[0];
        }
        return null;
    }

    public Breakpoint findBreakpoint(ConstructorElement method) {
        return null;
    }

    public Breakpoint[] getBreakpoints() {
        Object[] b;
        if (!this.breakpointsInitialized) {
            this.initBreakpoints();
        }
        Vector vector = this.breakpoints;
        synchronized (vector) {
            b = new CoreBreakpoint[this.breakpoints.size()];
            this.breakpoints.copyInto(b);
        }
        return b;
    }

    public BreakpointGroup getRootBreakpointGroup() {
        if (this.rootBreakpointGroup == null) {
            this.initGroups();
        }
        return this.rootBreakpointGroup;
    }

    private void initGroups() {
        DebuggerSupport ds = ((DebuggerProjectSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$debugger$support$DebuggerProjectSettings == null ? (class$org$netbeans$modules$debugger$support$DebuggerProjectSettings = DebuggerSupport.class$("org.netbeans.modules.debugger.support.DebuggerProjectSettings")) : class$org$netbeans$modules$debugger$support$DebuggerProjectSettings), (boolean)true)).getRemoteDebugger();
        if (ds == null) {
            this.rootBreakpointGroup = new BreakpointGroupSupport("main");
        } else {
            this.rootBreakpointGroup = ds.rootBreakpointGroup;
            if (ds.breakpoints != null) {
                this.breakpoints = ds.breakpoints;
            }
            this.breakpointsInitialized = true;
            if (this.rootBreakpointGroup == null) {
                this.rootBreakpointGroup = new BreakpointGroupSupport("main");
                Breakpoint[] bs = ds.getBreakpoints();
                int k = bs.length;
                int i = 0;
                while (i < k) {
                    this.rootBreakpointGroup.addBreakpoint((CoreBreakpoint)bs[i]);
                    ++i;
                }
            }
        }
    }

    public void removeAllBreakpoints() {
        if (!this.breakpointsInitialized) {
            this.initBreakpoints();
        }
        Vector v = (Vector)this.breakpoints.clone();
        int k = v.size();
        int i = k - 1;
        while (i >= 0) {
            ((Breakpoint)v.elementAt(i)).remove();
            --i;
        }
    }

    protected void addBreakpoint(Breakpoint b) {
        if (!this.breakpointsInitialized) {
            this.initBreakpoints();
        }
        this.breakpoints.addElement(b);
        this.fireBreakpointCreated(b);
    }

    protected void removeBreakpoint(Breakpoint b) {
        if (!this.breakpointsInitialized) {
            this.initBreakpoints();
        }
        this.breakpoints.removeElement(b);
        this.fireBreakpointRemoved(b);
    }

    protected void refreshBreakpoints() {
        if (!this.breakpointsInitialized) {
            this.initBreakpoints();
        }
        Vector v = (Vector)this.breakpoints.clone();
        int k = v.size();
        int i = 0;
        while (i < k) {
            if (v.elementAt(i) instanceof BreakpointSupport) {
                ((BreakpointSupport)v.elementAt(i)).setBreakpoint();
            }
            ++i;
        }
    }

    private void initBreakpoints() {
        DebuggerSupport ds = ((DebuggerProjectSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$debugger$support$DebuggerProjectSettings == null ? (class$org$netbeans$modules$debugger$support$DebuggerProjectSettings = DebuggerSupport.class$("org.netbeans.modules.debugger.support.DebuggerProjectSettings")) : class$org$netbeans$modules$debugger$support$DebuggerProjectSettings), (boolean)true)).getRemoteDebugger();
        if (ds != null && ds.breakpoints != null) {
            this.breakpoints = ds.breakpoints;
        }
        this.breakpointsInitialized = true;
    }

    public Watch[] getWatches() {
        Object[] w;
        if (!this.watchesInitialized) {
            this.initWatches();
        }
        if (this.watches == null) {
            return new Watch[0];
        }
        Vector vector = this.watches;
        synchronized (vector) {
            w = new Watch[this.watches.size()];
            this.watches.copyInto(w);
        }
        return w;
    }

    public void removeAllWatches() {
        if (!this.watchesInitialized) {
            this.initWatches();
        }
        Vector v = (Vector)this.watches.clone();
        int k = v.size();
        int i = k - 1;
        while (i >= 0) {
            ((Watch)v.elementAt(i)).remove();
            --i;
        }
    }

    public void addWatch(AbstractWatch w) {
        if (!this.watchesInitialized) {
            this.initWatches();
        }
        this.watches.addElement(w);
        this.fireWatchCreated(w);
    }

    public void removeWatch(AbstractWatch w) {
        if (!this.watchesInitialized) {
            this.initWatches();
        }
        this.watches.removeElement(w);
        this.fireWatchRemoved(w);
    }

    private void initWatches() {
        this.watchesInitialized = true;
        DebuggerSupport ds = ((DebuggerProjectSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$debugger$support$DebuggerProjectSettings == null ? (class$org$netbeans$modules$debugger$support$DebuggerProjectSettings = DebuggerSupport.class$("org.netbeans.modules.debugger.support.DebuggerProjectSettings")) : class$org$netbeans$modules$debugger$support$DebuggerProjectSettings), (boolean)true)).getRemoteDebugger();
        if (ds != null) {
            Watch[] ws = ds.getWatches();
            if (this.watches == null) {
                this.watches = new Vector();
            }
            this.watches.addAll(Arrays.asList(ws));
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    protected void firePropertyChange(String name, Object o, Object n) {
        this.pcs.firePropertyChange(name, o, n);
    }

    public void addDebuggerListener(DebuggerListener l) {
        this.listener.addElement(l);
    }

    public void removeDebuggerListener(DebuggerListener l) {
        this.listener.removeElement(l);
    }

    private void fireBreakpointCreated(Breakpoint breakpoint) {
        Vector l = (Vector)this.listener.clone();
        int k = l.size();
        int i = 0;
        while (i < k) {
            ((DebuggerListener)l.elementAt(i)).breakpointAdded(breakpoint);
            ++i;
        }
        this.pcs.firePropertyChange("breakpoints", null, null);
    }

    private void fireBreakpointRemoved(Breakpoint breakpoint) {
        Vector l = (Vector)this.listener.clone();
        int k = l.size();
        int i = 0;
        while (i < k) {
            ((DebuggerListener)l.elementAt(i)).breakpointRemoved(breakpoint);
            ++i;
        }
        this.pcs.firePropertyChange("breakpoints", null, null);
    }

    private void fireWatchCreated(AbstractWatch watch) {
        Vector l = (Vector)this.listener.clone();
        int k = l.size();
        int i = 0;
        while (i < k) {
            ((DebuggerListener)l.elementAt(i)).watchAdded(watch);
            ++i;
        }
        this.pcs.firePropertyChange("watches", null, null);
    }

    private void fireWatchRemoved(AbstractWatch watch) {
        Vector l = (Vector)this.listener.clone();
        int k = l.size();
        int i = 0;
        while (i < k) {
            ((DebuggerListener)l.elementAt(i)).watchRemoved(watch);
            ++i;
        }
        this.pcs.firePropertyChange("watches", null, null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

