/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Hashtable;
import javax.swing.JComponent;
import org.netbeans.modules.debugger.AbstractVariable;
import org.netbeans.modules.debugger.VariablesFilter;
import org.netbeans.modules.debugger.VariablesProducer;
import org.netbeans.modules.debugger.support.VariablesFilterSupport;
import org.openide.nodes.Node;
import org.openide.util.actions.SystemAction;

public class DelegatingFilter
extends VariablesFilterSupport {
    static final long serialVersionUID = -4241615364751798871L;
    private Hashtable h = new Hashtable();
    protected VariablesFilter innerFilter;

    public DelegatingFilter(VariablesFilter innerFilter) {
        this.innerFilter = innerFilter;
        this.init();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
    }

    protected void init() {
        super.init();
        if (this.innerFilter != null) {
            this.innerFilter.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent e) {
                    DelegatingFilter.this.firePropertyChange(e.getPropertyName(), e.getOldValue(), e.getNewValue());
                }
            });
        }
    }

    public AbstractVariable[] getVariables(VariablesProducer v) {
        if (!(v instanceof AbstractVariable)) {
            return this.innerFilter.getVariables(v);
        }
        VariablesFilter vf = this.getFilter(((AbstractVariable)((Object)v)).getType());
        if (vf == null) {
            return v.getVariables();
        }
        return vf.getVariables(v);
    }

    public SystemAction[] getActions(AbstractVariable v) {
        VariablesFilter vf = this.getFilter(v.getType());
        if (vf == null) {
            return new SystemAction[0];
        }
        return vf.getActions(v);
    }

    public Node.Property[] getProperties(AbstractVariable v) {
        String type = v.getType();
        if (type == null) {
            return new Node.Property[0];
        }
        VariablesFilter vf = this.getFilter(type);
        if (vf == null) {
            return new Node.Property[0];
        }
        return vf.getProperties(v);
    }

    public String getDisplayName(AbstractVariable v) {
        VariablesFilter vf = this.getFilter(v.getType());
        if (vf == null) {
            return null;
        }
        return vf.getDisplayName(v);
    }

    public JComponent getToolbar() {
        if (this.innerFilter == null) {
            return null;
        }
        return this.innerFilter.getToolbar();
    }

    public JComponent getCustomizer() {
        if (this.innerFilter == null) {
            return null;
        }
        return this.innerFilter.getCustomizer();
    }

    public VariablesFilter getFilter(String type) {
        if (type == null) {
            return this.innerFilter;
        }
        VariablesFilter vf = (VariablesFilter)this.h.get(type);
        if (vf != null) {
            return vf;
        }
        return this.innerFilter;
    }

    public void register(String type, VariablesFilter filter) {
        this.h.put(type, filter);
    }

    public String toString() {
        String n = this.getClass().getName();
        int i = n.lastIndexOf(46);
        if (i > 0) {
            n = n.substring(i + 1);
        }
        return n + this.hashCode() + "[inner " + this.innerFilter + " :#fil " + this.h.size() + "]";
    }
}

