/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support;

import org.netbeans.modules.debugger.GUIManager;
import org.netbeans.modules.debugger.support.View2;
import org.openide.windows.TopComponent;

public class DelegatingView2
extends View2 {
    static final long serialVersionUID = 3943837264524825522L;
    private String displayName;
    private String iconBase;
    private boolean hasFixedSize;
    private boolean canBeHidden;
    private boolean visible;
    private boolean separated;
    private View2[] views;
    private int currentView = 0;
    private String hash;

    public DelegatingView2(View2[] views) {
        this.views = views;
        int k = views.length;
        int i = 0;
        while (i < k) {
            if (views[i] != null) {
                if (views[i].getIconBase() == null) {
                    throw new NullPointerException();
                }
                this.displayName = views[i].getDisplayName();
                this.iconBase = views[i].getIconBase();
                this.hasFixedSize = views[i].hasFixedSize();
                this.canBeHidden = views[i].canBeHidden();
                this.visible = views[i].isVisible();
                this.separated = views[i].isSeparated();
            }
            ++i;
        }
    }

    public String getDisplayName() {
        View2 v = this.getCurrentView();
        if (v == null) {
            return this.displayName;
        }
        return v.getDisplayName();
    }

    public String getIconBase() {
        View2 v = this.getCurrentView();
        if (v == null) {
            return null;
        }
        return v.getIconBase();
    }

    public TopComponent getComponent() {
        View2 v = this.getCurrentView();
        if (v == null) {
            return null;
        }
        TopComponent tc = v.getComponent();
        return tc;
    }

    public boolean hasFixedSize() {
        View2 v = this.getCurrentView();
        if (v == null) {
            return this.hasFixedSize;
        }
        return v.hasFixedSize();
    }

    public boolean canBeHidden() {
        View2 v = this.getCurrentView();
        if (v == null) {
            return this.canBeHidden;
        }
        return v.canBeHidden();
    }

    public boolean isVisible() {
        View2 v = this.getCurrentView();
        if (v == null) {
            return this.visible;
        }
        return v.isVisible();
    }

    public boolean isSeparated() {
        View2 v = this.getCurrentView();
        if (v == null) {
            return this.separated;
        }
        return v.isSeparated();
    }

    public View2[] getViews() {
        return this.views;
    }

    public void setViews(View2[] views) {
        this.views = views;
        if (views == null) {
            return;
        }
        if (views.length > this.currentView) {
            this.setCurrentView(this.currentView);
        } else if (views.length > 0) {
            this.setCurrentView(0);
        }
    }

    public void setCurrentView(int index) {
        if (index == this.currentView) {
            return;
        }
        this.currentView = index;
    }

    public static void refreshViews() {
        GUIManager m = GUIManager.getDefault();
        GUIManager.View[] vs = m.getViews();
        int k = vs.length;
        GUIManager.View[] nvs = new GUIManager.View[k];
        System.arraycopy(vs, 0, nvs, 0, k);
        m.setViews(nvs);
    }

    public View2 getCurrentView() {
        return this.views[this.currentView];
    }

    public int hashCode() {
        return this.iconBase.hashCode();
    }

    public boolean equals(Object o) {
        return o != null && o instanceof DelegatingView2 && ((DelegatingView2)o).iconBase.equals(this.iconBase);
    }
}

