/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Hashtable;
import javax.swing.SwingUtilities;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.CoreDebugger;
import org.netbeans.modules.debugger.Register;
import org.openide.awt.StatusDisplayer;
import org.openide.text.Line;
import org.openide.util.Utilities;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;
import org.openide.windows.TopComponent;

public class IOManager {
    public static final int DEBUGGER_OUT = 1;
    public static final int PROCESS_OUT = 2;
    public static final int STATUS_OUT = 4;
    public static final int ALL_OUT = 7;
    public static final int STD_OUT = 1;
    public static final int ERR_OUT = 2;
    private static Hashtable debuggerToIOManager = new Hashtable();
    private static IOManager currentIOManager;
    protected InputOutput processIO = null;
    protected InputOutput debuggerIO = null;
    private AbstractDebugger debugger;
    private OutputWriter processOut;
    private OutputWriter debuggerOut;
    private String name;
    private Thread inputThread = null;
    private Thread outputThread = null;
    private Thread errorThread = null;
    private Listener listener = new Listener();
    private static DListener dListener;

    public IOManager(AbstractDebugger debugger) {
        this.debugger = debugger;
        this.debuggerIO = IOProvider.getDefault().getIO("Debugger Console", true);
        this.debuggerOut = this.debuggerIO.getOut();
        this.processIO = IOProvider.getDefault().getIO("Process Output", true);
        this.processOut = this.processIO.getOut();
        ((TopComponent)this.debuggerIO).hide();
        debuggerToIOManager.put(debugger, this);
        CoreDebugger cd = Register.getCoreDebugger();
        if (dListener == null) {
            dListener = new DListener();
            cd.addPropertyChangeListener(dListener);
        }
        if (currentIOManager != null) {
            if (cd.getDebuggers().length < 2) {
                currentIOManager.dispose();
            } else {
                currentIOManager.setVisible(false);
            }
        }
        currentIOManager = this;
    }

    public void select() {
        this.processIO.select();
    }

    public void print(final String text, final int where) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if ((where & 2) != 0) {
                    IOManager.this.processOut.print(text);
                }
                if ((where & 1) != 0) {
                    IOManager.this.debuggerOut.print(text);
                }
                if ((where & 4) != 0) {
                    StatusDisplayer.getDefault().setStatusText(text);
                }
            }
        });
    }

    public void println(String text) {
        this.println(text, 1);
    }

    public void println(String text, int where) {
        this.println(text, where, null);
    }

    public void println(final String text, final int where, final Line line) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    if ((where & 2) != 0) {
                        if (line != null) {
                            IOManager.this.processOut.println(text, (OutputListener)IOManager.this.listener);
                            IOManager.this.listener.lines.put(text, line);
                        } else {
                            IOManager.this.processOut.println(text);
                        }
                    }
                    if ((where & 1) != 0) {
                        if (line != null) {
                            IOManager.this.debuggerOut.println(text, (OutputListener)IOManager.this.listener);
                            IOManager.this.listener.lines.put(text, line);
                        } else {
                            IOManager.this.debuggerOut.println(text);
                        }
                    }
                    if ((where & 4) != 0) {
                        StatusDisplayer.getDefault().setStatusText(text);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    public void showOutput(Process process, int what, int where) {
        if (process == null) {
            throw new NullPointerException();
        }
        if ((what | 1) != 0) {
            this.outputThread = new CopyMaker("Debugger output writer thread", new InputStreamReader(process.getInputStream()), (Writer)((where & 2) != 0 ? this.processOut : this.debuggerOut), false);
            this.outputThread.start();
        }
        if ((what | 2) != 0) {
            this.errorThread = new CopyMaker("Debugger error writer thread", new InputStreamReader(process.getErrorStream()), (Writer)((where & 2) != 0 ? this.processOut : this.debuggerOut), false);
            this.errorThread.start();
        }
    }

    public void connectInput(Process process) {
        if (process == null) {
            throw new NullPointerException();
        }
        if (this.processIO == null) {
            return;
        }
        this.processIO.setInputVisible(true);
        this.processIO.flushReader();
        this.inputThread = new CopyMaker("Debugger input reader thread", this.processIO.getIn(), new OutputStreamWriter(process.getOutputStream()), true);
        this.inputThread.start();
    }

    public void stop() {
        CoreDebugger cd;
        if (this.errorThread != null) {
            this.errorThread.interrupt();
            this.errorThread = null;
        }
        if (this.outputThread != null) {
            this.outputThread.interrupt();
            this.outputThread = null;
        }
        if (this.inputThread != null) {
            this.inputThread.interrupt();
            this.inputThread = null;
        }
        if ((cd = Register.getCoreDebugger()).getDebuggers().length > 1) {
            this.dispose();
        } else {
            debuggerToIOManager.remove(this.debugger);
            this.debugger = null;
        }
    }

    private void dispose() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (IOManager.this.debuggerIO != null) {
                    IOManager.this.debuggerIO.closeInputOutput();
                }
                if (IOManager.this.processIO != null) {
                    IOManager.this.processIO.closeInputOutput();
                }
                if (IOManager.this.debugger != null) {
                    debuggerToIOManager.remove(IOManager.this.debugger);
                    IOManager.this.debugger = null;
                }
                IOManager.this.processIO = null;
                IOManager.this.debuggerIO = null;
            }
        });
    }

    private void setVisible(final boolean visible) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (IOManager.this.debuggerIO != null) {
                    IOManager.this.debuggerIO.setOutputVisible(visible);
                }
                if (IOManager.this.processIO != null) {
                    IOManager.this.processIO.setOutputVisible(visible);
                }
            }
        });
    }

    private static void switchOutput() {
        AbstractDebugger d = Register.getCurrentDebugger();
        if (d == null) {
            return;
        }
        if (debuggerToIOManager.get(d) == currentIOManager) {
            return;
        }
        if (currentIOManager != null) {
            currentIOManager.setVisible(false);
        }
        if ((currentIOManager = (IOManager)debuggerToIOManager.get(d)) != null) {
            currentIOManager.setVisible(true);
        }
    }

    private static class DListener
    implements PropertyChangeListener {
        private DListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName() == null || e.getPropertyName() != "currentDebugger") {
                return;
            }
            IOManager.switchOutput();
        }
    }

    private static class CopyMaker
    extends Thread {
        final Writer os;
        final Reader is;
        final boolean autoflush;

        CopyMaker(String name, Reader is, Writer os, boolean b) {
            super(name);
            this.os = os;
            this.is = is;
            this.autoflush = b;
            this.setPriority(1);
        }

        /*
         * WARNING - void declaration
         */
        public void run() {
            char[] buff = new char[256];
            try {
                int read;
                while ((read = this.read(this.is, buff, 0, 256)) > 0) {
                    void var1_2;
                    this.os.write(buff, 0, (int)var1_2);
                    if (!this.autoflush) continue;
                    this.os.flush();
                }
            }
            catch (IOException ex) {
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }

        private int read(Reader is, char[] buff, int start, int count) throws InterruptedException, IOException {
            if (Utilities.getOperatingSystem() != 1024 && Utilities.getOperatingSystem() != 8192) {
                while (!is.ready()) {
                    Thread.sleep(100L);
                }
            }
            return is.read(buff, start, count);
        }
    }

    private static class Listener
    implements OutputListener {
        private Hashtable lines = new Hashtable();

        private Listener() {
        }

        public void outputLineSelected(OutputEvent ev) {
        }

        public void outputLineAction(OutputEvent ev) {
            String t = ev.getLine();
            Line l = (Line)this.lines.get(t);
            if (l == null) {
                return;
            }
            l.show(2);
        }

        public void outputLineCleared(OutputEvent ev) {
            this.lines = new Hashtable();
        }
    }
}

