/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support;

import java.io.File;
import java.io.Serializable;
import java.util.HashSet;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.AbstractDebuggerInfo;
import org.netbeans.modules.debugger.CoreDebugger;
import org.netbeans.modules.debugger.DebuggerImpl;
import org.netbeans.modules.debugger.Register;
import org.openide.execution.NbProcessDescriptor;

public class ProcessDebuggerInfo
extends AbstractDebuggerInfo
implements Serializable {
    private NbProcessDescriptor processDescriptor;
    private String classPath;
    private String bootClassPath;
    private String repositoryPath;
    private String libraryPath;
    private File workingDirectory;
    private boolean classic;
    private boolean assertEnabled;
    private String processName;

    public ProcessDebuggerInfo(String className, String[] argv, String stopClassName, NbProcessDescriptor processDescriptor, String classPath, String bootClassPath, String repositoryPath, String libraryPath, File workingDirectory, boolean classic, boolean assertEnabled, String processName) {
        super(className, argv, stopClassName);
        this.processDescriptor = processDescriptor;
        this.classPath = classPath;
        this.bootClassPath = bootClassPath;
        this.repositoryPath = repositoryPath;
        this.libraryPath = libraryPath;
        this.workingDirectory = workingDirectory;
        this.classic = classic;
        this.assertEnabled = assertEnabled;
        CoreDebugger cd = Register.getCoreDebugger();
        AbstractDebugger[] ds = cd.getDebuggers();
        int k = ds.length;
        HashSet<Integer> m = new HashSet<Integer>();
        int i = 0;
        while (i < k) {
            String pn;
            AbstractDebuggerInfo di = (AbstractDebuggerInfo)ds[i].getDebuggerInfo();
            if (di != null && (pn = di.getProcessName()).startsWith(processName)) {
                if (pn.equals(processName)) {
                    m.add(new Integer(0));
                } else {
                    try {
                        int t = Integer.parseInt(pn.substring(processName.length()));
                        m.add(new Integer(t));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            ++i;
        }
        k = m.size();
        i = 0;
        while (i < k) {
            if (!m.contains(new Integer(i))) break;
            ++i;
        }
        if (i > 0) {
            processName = processName + i;
        }
        this.processName = processName;
    }

    public ProcessDebuggerInfo(String className, String[] argv, String stopClassName, NbProcessDescriptor processDescriptor, String classPath, String bootClassPath, String repositoryPath, String libraryPath, File workingDirectory, boolean classic, String processName) {
        this(className, argv, stopClassName, processDescriptor, classPath, bootClassPath, repositoryPath, libraryPath, workingDirectory, classic, false, processName);
    }

    public ProcessDebuggerInfo(String className, String[] argv, String stopClassName, NbProcessDescriptor processDescriptor, String classPath, String bootClassPath, String repositoryPath, String libraryPath, boolean classic) {
        this(className, argv, stopClassName, processDescriptor, classPath, bootClassPath, repositoryPath, libraryPath, null, classic, false, className);
    }

    public NbProcessDescriptor getDebuggerProcess() {
        return this.processDescriptor;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public String getBootClassPath() {
        return this.bootClassPath;
    }

    public String getRepositoryPath() {
        return this.repositoryPath;
    }

    public String getLibraryPath() {
        return this.libraryPath;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public boolean isClassic() {
        return this.classic;
    }

    public boolean isAssertEnabled() {
        return this.assertEnabled;
    }

    public String getProcessName() {
        return this.processName;
    }

    public String getLocationName() {
        return "localhost";
    }

    public DebuggerImpl getDebuggerImpl() {
        return null;
    }
}

