/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Map;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.AbstractDebuggerType;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.CoreDebugger;
import org.netbeans.modules.debugger.Register;
import org.netbeans.modules.debugger.support.ProcessDebuggerInfo;
import org.netbeans.modules.debugger.support.java.JUtils;
import org.netbeans.modules.debugger.support.java.PrintAction;
import org.openide.debugger.Breakpoint;
import org.openide.debugger.Debugger;
import org.openide.debugger.DebuggerException;
import org.openide.execution.ExecInfo;
import org.openide.execution.NbClassPath;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileSystemCapability;
import org.openide.loaders.DataObject;
import org.openide.loaders.ExecutionSupport;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.text.Line;
import org.openide.util.HelpCtx;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ProcessDebuggerType
extends AbstractDebuggerType {
    static final long serialVersionUID = 833275268075073629L;
    public static final String PROP_DEBUGGER_PROCESS = "debuggerProcess";
    public static final String PROP_CLASSIC = "classic";
    public static final String PROP_ASSERT_ENABLED = "assertEnabled";
    public static final String PROP_CLASSPATH = "classPath";
    public static final String PROP_BOOT_CLASSPATH = "bootClassPath";
    public static final String PROP_REPOSITORY = "repositoryPath";
    public static final String PROP_LIBRARY = "libraryPath";
    public static final String PROP_NAME = "name";
    public static final String PROP_WORKING_DIRECTORY = "workingDirectory";
    public static final String CLASSIC_SWITCH = "classic";
    public static final String ASSERT_ENABLED_SWITCH = "assertEnabled";
    public static final String DEBUGGER_OPTIONS = "debuggerOptions";
    public static final String BOOT_CLASS_PATH_SWITCH_SWITCH = "bootclasspathSwitch";
    public static final String BOOT_CLASS_PATH_SWITCH = "bootclasspath";
    public static final String REPOSITORY_SWITCH = "filesystems";
    public static final String LIBRARY_SWITCH = "library";
    public static final String CLASS_PATH_SWITCH = "classpath";
    public static final String MAIN_SWITCH = "main";
    public static final String JAVA_HOME_SWITCH = "java.home";
    public static final String JDK_HOME_SWITCH = "jdk.home";
    public static final String FILE_SEPARATOR_SWITCH = "/";
    public static final String PATH_SEPARATOR_SWITCH = ":";
    public static final String QUOTE_SWITCH = "q";
    public static NbProcessDescriptor DEFAULT_DEBUGGER_PROCESS;
    private static String bootClassPath;
    private NbProcessDescriptor debuggerProcess;
    protected boolean classic;
    protected boolean assertEnabled = false;
    protected boolean classicInited = false;
    protected boolean setted = false;
    private File workingDirectory = null;
    private int serialVer = 1;
    private NbClassPath classPath;
    private NbClassPath bootClassPath2;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$ProcessDebuggerType;

    public static NbProcessDescriptor getDefaultDebuggerProcess() {
        if (DEFAULT_DEBUGGER_PROCESS != null) {
            return DEFAULT_DEBUGGER_PROCESS;
        }
        DEFAULT_DEBUGGER_PROCESS = new NbProcessDescriptor(ProcessDebuggerType.getDefaultProcessName(), "{classic}{assertEnabled}{debuggerOptions} -Djava.compiler=NONE -classpath {q}{filesystems}{q} {main}", NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$support$ProcessDebuggerType == null ? (class$org$netbeans$modules$debugger$support$ProcessDebuggerType = ProcessDebuggerType.class$("org.netbeans.modules.debugger.support.ProcessDebuggerType")) : class$org$netbeans$modules$debugger$support$ProcessDebuggerType)).getString("MSG_DebuggerHint"));
        return DEFAULT_DEBUGGER_PROCESS;
    }

    private void readObject(ObjectInputStream oos) throws IOException, ClassNotFoundException {
        oos.defaultReadObject();
        if (this.serialVer == 0) {
            this.setDebuggerProcess(ProcessDebuggerType.getDefaultDebuggerProcess());
        }
    }

    public String displayName() {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$support$ProcessDebuggerType == null ? (class$org$netbeans$modules$debugger$support$ProcessDebuggerType = ProcessDebuggerType.class$("org.netbeans.modules.debugger.support.ProcessDebuggerType")) : class$org$netbeans$modules$debugger$support$ProcessDebuggerType)).getString("CTL_Process_debugger_type");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$modules$debugger$support$ProcessDebuggerType == null ? (class$org$netbeans$modules$debugger$support$ProcessDebuggerType = ProcessDebuggerType.class$("org.netbeans.modules.debugger.support.ProcessDebuggerType")) : class$org$netbeans$modules$debugger$support$ProcessDebuggerType);
    }

    public void startDebugger(DataObject obj, Line line) throws DebuggerException {
        CoreDebugger debugger = Register.getCoreDebugger();
        CoreBreakpoint b = (CoreBreakpoint)debugger.createBreakpoint(line, true);
        CoreBreakpoint.Action[] actions = b.getActions();
        int ii = actions.length;
        int i = 0;
        while (i < ii) {
            if (actions[i] instanceof PrintAction) {
                ((PrintAction)actions[i]).setPrintText(PrintAction.RUN_TO_CURSOR_TEXT);
            }
            ++i;
        }
        ((AbstractDebugger)debugger).addPropertyChangeListener(new Listener(debugger, b));
        String[] params = ExecutionSupport.getArguments((MultiDataObject.Entry)new FileEntry(null, obj.getPrimaryFile()));
        this.startDebugger(new ExecInfo(obj.getPrimaryFile().getPackageName('.'), params), false);
    }

    public void startDebugger(ExecInfo info, boolean stopOnMain) throws DebuggerException {
        if (!this.prepareArguments()) {
            return;
        }
        this.startDebugger(info.getClassName(), info.getArguments(), stopOnMain ? info.getClassName() : null, this.getDebuggerProcess(), this.getClassPath(), this.getBootClassPath(), this.getRepositoryPath(), this.getLibraryPath(), this.isClassic(), this.isAssertEnabled(), info, stopOnMain);
    }

    public boolean supportsDebuggingOf(DataObject obj) {
        return obj.getPrimaryFile().getMIMEType().equals("text/x-java");
    }

    protected void startDebugger(String className, String[] arguments, String stopClassName, NbProcessDescriptor process, String classPath, String bootClassPath, String repositoryPath, String libraryPath, boolean classic, boolean assertEnabled, ExecInfo info, boolean stopOnMain) throws DebuggerException {
        String processName = className;
        int i = processName.lastIndexOf(46);
        if (i > 0) {
            processName = processName.substring(i + 1);
        }
        Register.getCoreDebugger().startDebugger(new ProcessDebuggerInfo(className, arguments, stopClassName, process, classPath, bootClassPath, repositoryPath, libraryPath, this.getWorkingDirectory(), classic, assertEnabled, processName));
    }

    protected boolean getClassicDefault() {
        boolean hasHotSpot = JUtils.hasHotSpot(new MapFormat((Map)JUtils.processDebuggerInfo(null, "", "")).format(this.getDebuggerProcess().getProcessName()));
        return hasHotSpot;
    }

    protected boolean prepareArguments() {
        if (!this.setted) {
            boolean old = this.classic;
            this.classic = this.getClassicDefault();
            this.firePropertyChange("classic", old ? Boolean.TRUE : Boolean.FALSE, this.classic ? Boolean.TRUE : Boolean.FALSE);
        }
        return true;
    }

    public static String getDefaultProcessName() {
        if (Utilities.getOperatingSystem() == 1024) {
            return "{jdk.home}{/}jre{/}bin{/}java";
        }
        return "{jdk.home}{/}bin{/}java";
    }

    public NbProcessDescriptor getDebuggerProcess() {
        if (this.debuggerProcess != null) {
            return this.debuggerProcess;
        }
        return ProcessDebuggerType.getDefaultDebuggerProcess();
    }

    public void setDebuggerProcess(NbProcessDescriptor debugger) {
        NbProcessDescriptor oldValue = this.getDebuggerProcess();
        this.debuggerProcess = debugger;
        this.firePropertyChange(PROP_DEBUGGER_PROCESS, oldValue, this.debuggerProcess);
    }

    public boolean isClassic() {
        if (this.setted || this.classicInited) {
            return this.classic;
        }
        this.classicInited = true;
        this.classic = this.getClassicDefault();
        return this.classic;
    }

    public void setClassic(boolean hs) {
        if (hs == this.classic) {
            return;
        }
        this.classic = hs;
        this.setted = true;
        this.firePropertyChange("classic", !hs ? Boolean.TRUE : Boolean.FALSE, hs ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean isAssertEnabled() {
        return this.assertEnabled;
    }

    public void setAssertEnabled(boolean assertFlag) {
        if (this.assertEnabled == assertFlag) {
            return;
        }
        this.assertEnabled = assertFlag;
        this.firePropertyChange("assertEnabled", !assertFlag ? Boolean.TRUE : Boolean.FALSE, assertFlag ? Boolean.TRUE : Boolean.FALSE);
    }

    public String getClassPath() {
        return this.getNbClassPath().getClassPath();
    }

    public NbClassPath getNbClassPath() {
        return this.classPath == null ? NbClassPath.createClassPath() : this.classPath;
    }

    public synchronized void setNbClassPath(NbClassPath path) {
        NbClassPath old = this.classPath;
        this.classPath = path;
        this.firePropertyChange(PROP_CLASSPATH, old, path);
    }

    public String getBootClassPath() {
        return this.getNbBootClassPath().getClassPath();
    }

    public NbClassPath getNbBootClassPath() {
        return this.bootClassPath2 == null ? NbClassPath.createBootClassPath() : this.bootClassPath2;
    }

    public synchronized void setNbBootClassPath(NbClassPath path) {
        NbClassPath old = this.bootClassPath2;
        this.bootClassPath2 = path;
        this.firePropertyChange(PROP_BOOT_CLASSPATH, old, path);
    }

    public String getRepositoryPath() {
        return this.getNbRepositoryPath().getClassPath();
    }

    public NbClassPath getNbRepositoryPath() {
        return NbClassPath.createRepositoryPath((FileSystemCapability)FileSystemCapability.EXECUTE);
    }

    public String getLibraryPath() {
        return this.getNbLibraryPath().getClassPath();
    }

    public NbClassPath getNbLibraryPath() {
        return NbClassPath.createLibraryPath();
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(File nue) {
        this.workingDirectory = nue;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Listener
    implements PropertyChangeListener {
        Breakpoint b;
        Debugger d;

        Listener(Debugger d, Breakpoint b) {
            this.d = d;
            this.b = b;
        }

        public void propertyChange(PropertyChangeEvent ev) {
            block2: {
                block3: {
                    if (!ev.getPropertyName().equals("state")) break block2;
                    if ((Integer)ev.getNewValue() == 4) break block3;
                    if ((Integer)ev.getNewValue() != 1) break block2;
                }
                this.b.remove();
                this.d.removePropertyChangeListener((PropertyChangeListener)this);
            }
        }
    }
}

