/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Vector;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.BreakpointGroup;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.DebuggerListener;
import org.netbeans.modules.debugger.Register;
import org.netbeans.modules.debugger.State;
import org.netbeans.modules.debugger.support.DebuggerSupport;
import org.openide.debugger.Breakpoint;
import org.openide.debugger.DebuggerException;
import org.openide.debugger.DebuggerInfo;
import org.openide.debugger.Watch;
import org.openide.src.ConstructorElement;
import org.openide.text.Line;

public abstract class SecondaryDebuggerSupport
extends AbstractDebugger {
    static final long serialVersionUID = 2822234994389241123L;
    public static final State STATE_NOT_RUNNING = DebuggerSupport.STATE_NOT_RUNNING;
    private transient Vector watches;
    private transient int lastAction = 6;
    private transient PropertyChangeSupport pcs;
    private transient Vector listener = new Vector();
    private transient Line currentLine = null;
    private transient int state = 1;
    private transient State debuggerState = STATE_NOT_RUNNING;
    private transient DebuggerInfo debuggerInfo = null;

    public SecondaryDebuggerSupport() {
        this.pcs = new PropertyChangeSupport(this);
        this.watches = new Vector();
    }

    public void startDebugger(DebuggerInfo info) throws DebuggerException {
        this.debuggerInfo = info;
        this.setState(2);
        this.setLastAction(6);
    }

    public DebuggerInfo getDebuggerInfo() {
        return this.debuggerInfo;
    }

    public void finishDebugger() throws DebuggerException {
        this.setState(1);
        this.setCurrentLine(null);
    }

    public int getLastAction() {
        return this.lastAction;
    }

    protected void setLastAction(int lastAction) {
        int old = this.lastAction;
        this.lastAction = lastAction;
        this.firePropertyChange("lastAction", new Integer(old), new Integer(lastAction));
    }

    protected void setState(int newState) {
        if (newState == this.state) {
            return;
        }
        Integer old = new Integer(this.state);
        this.state = newState;
        this.firePropertyChange("state", old, new Integer(this.state));
    }

    public int getState() {
        return this.state;
    }

    protected void setDebuggerState(State newState) {
        if (newState.equals(this.debuggerState)) {
            return;
        }
        State old = this.debuggerState;
        this.debuggerState = newState;
        this.firePropertyChange("debuggerState", old, this.debuggerState);
    }

    public State getDebuggerState() {
        return this.debuggerState;
    }

    public Line getCurrentLine() {
        return this.currentLine;
    }

    public void setCurrentLine(Line l) {
        if (l == this.currentLine) {
            return;
        }
        Line old = this.currentLine;
        this.currentLine = l;
        this.firePropertyChange("currentLine", old, this.currentLine);
    }

    public CoreBreakpoint createBreakpoint(boolean hidden) {
        return Register.getCoreDebugger().createBreakpoint(hidden);
    }

    public Breakpoint createBreakpoint(Line l) {
        return Register.getCoreDebugger().createBreakpoint(l);
    }

    public Breakpoint createBreakpoint(Line l, boolean hidden) {
        return Register.getCoreDebugger().createBreakpoint(l, hidden);
    }

    public Breakpoint createBreakpoint(ConstructorElement method) {
        return Register.getCoreDebugger().createBreakpoint(method);
    }

    public Breakpoint createBreakpoint(ConstructorElement method, boolean hidden) {
        return Register.getCoreDebugger().createBreakpoint(method, hidden);
    }

    public Breakpoint findBreakpoint(Line l) {
        return Register.getCoreDebugger().findBreakpoint(l);
    }

    public Breakpoint findBreakpoint(ConstructorElement method) {
        return Register.getCoreDebugger().findBreakpoint(method);
    }

    public Breakpoint[] getBreakpoints() {
        return Register.getCoreDebugger().getBreakpoints();
    }

    public BreakpointGroup getRootBreakpointGroup() {
        return Register.getCoreDebugger().getRootBreakpointGroup();
    }

    public void removeAllBreakpoints() {
        Register.getCoreDebugger().removeAllBreakpoints();
    }

    public Watch[] getWatches() {
        Object[] w;
        if (this.watches == null) {
            return new Watch[0];
        }
        Vector vector = this.watches;
        synchronized (vector) {
            w = new Watch[this.watches.size()];
            this.watches.copyInto(w);
        }
        return w;
    }

    public void removeAllWatches() {
        Vector v = (Vector)this.watches.clone();
        int k = v.size();
        int i = k - 1;
        while (i >= 0) {
            ((Watch)v.elementAt(i)).remove();
            --i;
        }
    }

    protected void addWatch(Watch w) {
        this.watches.addElement(w);
        this.fireWatchCreated(w);
    }

    public void removeWatch(Watch w) {
        this.watches.removeElement(w);
        this.fireWatchRemoved(w);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    protected void firePropertyChange(String name, Object o, Object n) {
        this.pcs.firePropertyChange(name, o, n);
    }

    public void addDebuggerListener(DebuggerListener l) {
        this.listener.addElement(l);
    }

    public void removeDebuggerListener(DebuggerListener l) {
        this.listener.removeElement(l);
    }

    private void fireWatchCreated(Watch watch) {
        this.pcs.firePropertyChange("watches", null, null);
    }

    private void fireWatchRemoved(Watch watch) {
        this.pcs.firePropertyChange("watches", null, null);
    }
}

