/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support;

import org.netbeans.modules.debugger.State;

public class StateSupport
extends State {
    public static final int STEP_INTO = 1;
    public static final int STEP_OVER = 2;
    public static final int STEP_OUT = 4;
    public static final int RUN_TO_CURSOR = 16;
    public static final int PAUSE = 32;
    public static final int CONTINUE = 64;
    public static final int GO_TO_CALLING_METHOD = 128;
    public static final int GO_TO_CALLED_METHOD = 256;
    public static final int POP_TOPMOST_FRAME = 512;
    public static final int FIX = 1024;
    private int state;

    public StateSupport(int state) {
        this.state = state;
    }

    public boolean isStepIntoEnabled() {
        return (this.state & 1) != 0;
    }

    public boolean isStepOverEnabled() {
        return (this.state & 2) != 0;
    }

    public boolean isStepOutEnabled() {
        return (this.state & 4) != 0;
    }

    public boolean isRunToCursorEnabled() {
        return (this.state & 0x10) != 0;
    }

    public boolean isPauseEnabled() {
        return (this.state & 0x20) != 0;
    }

    public boolean isContinueEnabled() {
        return (this.state & 0x40) != 0;
    }

    public boolean isGoToCallingMethodEnabled() {
        return (this.state & 0x80) != 0;
    }

    public boolean isGoToCalledMethodEnabled() {
        return (this.state & 0x100) != 0;
    }

    public boolean equals(Object o) {
        return o != null && o instanceof StateSupport && ((StateSupport)o).state == this.state;
    }

    public boolean isFixEnabled() {
        return (this.state & 0x400) != 0;
    }

    public boolean isPopTopmostFrameEnabled() {
        return (this.state & 0x200) != 0;
    }

    public int hashCode() {
        return this.state;
    }

    public String toString() {
        String n = this.getClass().getName();
        int i = n.lastIndexOf(46);
        if (i > 0) {
            n = n.substring(i + 1);
        }
        return n + this.hashCode() + "[SI " + this.isStepIntoEnabled() + " : SOut " + this.isStepOutEnabled() + " : SOv " + this.isStepOverEnabled() + " : toCur " + this.isRunToCursorEnabled() + " : pause " + this.isPauseEnabled() + " : cont " + this.isContinueEnabled() + " : calling " + this.isGoToCallingMethodEnabled() + " : called " + this.isGoToCalledMethodEnabled() + "]";
    }
}

