/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.swing.JComponent;
import org.netbeans.modules.debugger.AbstractVariable;
import org.netbeans.modules.debugger.VariablesFilter;
import org.netbeans.modules.debugger.VariablesProducer;
import org.openide.nodes.Node;
import org.openide.util.actions.SystemAction;

public class VariablesFilterSupport
extends VariablesFilter
implements Serializable {
    static final long serialVersionUID = -520940446384821783L;
    private static SystemAction[] actions;
    private static Node.Property[] properties;
    private transient PropertyChangeSupport pcs;

    public VariablesFilterSupport() {
        this.init();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
    }

    protected void init() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public AbstractVariable[] getVariables(VariablesProducer v) {
        return v.getVariables();
    }

    public SystemAction[] getActions(AbstractVariable v) {
        if (actions == null) {
            actions = new SystemAction[0];
        }
        return actions;
    }

    public Node.Property[] getProperties(AbstractVariable v) {
        if (properties == null) {
            properties = new Node.Property[0];
        }
        return properties;
    }

    public String getDisplayName(AbstractVariable v) {
        String name = v.getVariableName();
        if (name == null) {
            return "???";
        }
        String type = v.getType();
        String value = v.getAsText();
        if (value == null) {
            return name;
        }
        if (type == null) {
            return name + " = " + value;
        }
        return name + " = (" + type + ") " + value;
    }

    public JComponent getToolbar() {
        return null;
    }

    public JComponent getCustomizer() {
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    protected void firePropertyChange(String name, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(name, oldValue, newValue);
    }
}

