/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.java;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.support.java.JUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.filesystems.RepositoryEvent;
import org.openide.filesystems.RepositoryListener;
import org.openide.filesystems.RepositoryReorderedEvent;
import org.openide.src.ClassElement;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListener;

public class BreakpointUpdater
extends FileChangeAdapter
implements PropertyChangeListener {
    protected static final LazyRepositoryListener repListener = new LazyRepositoryListener();
    protected CoreBreakpoint.Event breakpoint;
    protected String className;
    private Method classNameChangeMethod;
    private String classNameChangeMethodName;
    private WeakReference clsElemRef;
    protected transient FileObject fileObject;
    private PropertyChangeListener clsElementChangeListenerWeak;
    protected boolean onNestedClass;
    protected boolean listenOnClass;
    static /* synthetic */ Class class$java$lang$String;

    protected ClassElement getClsElement() {
        if (this.clsElemRef == null) {
            return null;
        }
        ClassElement result = (ClassElement)this.clsElemRef.get();
        if (result == null) {
            this.clsElementChangeListenerWeak = null;
        }
        return result;
    }

    protected ClassElement setClsElement(ClassElement clsElem) {
        this.clsElemRef = clsElem == null ? null : new WeakReference<ClassElement>(clsElem);
        return clsElem;
    }

    protected void init() {
        repListener.register(this);
    }

    public BreakpointUpdater(CoreBreakpoint.Event breakpoint, String classNameUpdateMethod, String className) {
        this.classNameChangeMethodName = classNameUpdateMethod;
        this.breakpoint = breakpoint;
        this.init();
        this.setClassName(className);
    }

    public void dispose() {
        repListener.unregister(this);
        ClassElement clsElement = this.getClsElement();
        if (clsElement != null) {
            this.refreshClsElementListener(clsElement, null);
        }
        if (this.fileObject != null) {
            this.refreshFileObjectListener(this.fileObject, null);
        }
    }

    protected synchronized void refreshClsElementListener() {
        ClassElement clsElement;
        ClassElement old = this.getClsElement();
        ClassElement classElement = clsElement = this.className == null ? null : ClassElement.forName((String)this.className);
        if (clsElement == old) {
            return;
        }
        this.setClsElement(clsElement);
        this.refreshClsElementListener(old, clsElement);
    }

    protected synchronized void refreshClsElementListener(ClassElement old, ClassElement clsElement) {
        if (clsElement != old) {
            if (old != null) {
                old.removePropertyChangeListener(this.clsElementChangeListenerWeak);
                this.clsElementChangeListenerWeak = null;
            }
            if (clsElement != null) {
                this.clsElementChangeListenerWeak = WeakListener.propertyChange((PropertyChangeListener)this, (Object)clsElement);
                clsElement.addPropertyChangeListener(this.clsElementChangeListenerWeak);
            }
        }
    }

    protected synchronized void refreshFileObjectListener() {
        FileObject old = this.fileObject;
        this.fileObject = this.className == null ? null : Repository.getDefault().find(JUtils.getPackageName(this.className), JUtils.getTopClassName(JUtils.getClassName(this.className)), "java");
        this.refreshFileObjectListener(old, this.fileObject);
    }

    protected synchronized void refreshFileObjectListener(FileObject old, FileObject fileObject) {
        if (fileObject != old) {
            if (old != null) {
                old.removeFileChangeListener((FileChangeListener)this);
            }
            if (fileObject != null) {
                fileObject.addFileChangeListener((FileChangeListener)this);
            }
        }
    }

    public void setClassName(String className) {
        this.className = className;
        boolean wasListenOnClass = this.listenOnClass;
        this.refreshFileObjectListener();
        this.onNestedClass = className != null && className.indexOf(36) != -1;
        boolean bl = this.listenOnClass = this.onNestedClass && this.fileObject != null;
        if (wasListenOnClass && !this.listenOnClass) {
            ClassElement old = this.getClsElement();
            this.setClsElement(null);
            this.refreshClsElementListener(old, null);
        } else if (this.listenOnClass) {
            this.refreshClsElementListener();
        }
    }

    protected void updateBreakpoint() {
        if (this.classNameChangeMethodName != null) {
            try {
                this.classNameChangeMethod = this.breakpoint.getClass().getMethod(this.classNameChangeMethodName, class$java$lang$String == null ? (class$java$lang$String = BreakpointUpdater.class$("java.lang.String")) : class$java$lang$String);
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(4096, (Throwable)ex);
            }
            this.classNameChangeMethodName = null;
        }
        if (this.classNameChangeMethod != null) {
            try {
                this.classNameChangeMethod.invoke((Object)this.breakpoint, this.className);
            }
            catch (Exception ex) {
                this.classNameChangeMethod = null;
                ErrorManager.getDefault().notify(4096, (Throwable)ex);
            }
        }
    }

    public void fileChanged(FileEvent e) {
        if (this.onNestedClass) {
            this.refreshClsElementListener();
        }
    }

    public void fileDeleted(FileEvent e) {
        this.fileObject = null;
        this.refreshFileObjectListener(this.fileObject, null);
        if (this.listenOnClass) {
            this.refreshClsElementListener(this.getClsElement(), this.setClsElement(null));
        }
    }

    public void fileRenamed(FileRenameEvent e) {
        if (!this.onNestedClass) {
            this.className = this.fileObject.getPackageName('.');
            this.updateBreakpoint();
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("name")) {
            this.className = ((ClassElement)e.getSource()).getVMName();
            this.updateBreakpoint();
        }
    }

    protected void fileSystemsAdded(List fileSystems) {
        if (this.fileObject == null) {
            this.refreshFileObjectListener();
            boolean bl = this.listenOnClass = this.onNestedClass && this.fileObject != null;
            if (this.listenOnClass) {
                this.refreshClsElementListener();
            }
        }
    }

    protected void fileSystemsRemoved(List fileSystems) {
        if (this.fileObject != null) {
            boolean removed = false;
            try {
                Iterator i = fileSystems.iterator();
                while (i.hasNext()) {
                    if ((FileSystem)i.next() != this.fileObject.getFileSystem()) continue;
                    removed = true;
                    break;
                }
            }
            catch (FileStateInvalidException ex) {
                removed = true;
            }
            if (removed) {
                this.fileObject = null;
                this.refreshFileObjectListener(this.fileObject, null);
                if (this.listenOnClass) {
                    this.refreshClsElementListener(this.getClsElement(), this.setClsElement(null));
                    this.listenOnClass = false;
                }
            }
        }
    }

    protected void fileSystemsChanged(List addedFS, List removedFS) {
        this.refreshFileObjectListener();
        boolean bl = this.listenOnClass = this.onNestedClass && this.fileObject != null;
        if (this.listenOnClass) {
            this.refreshClsElementListener();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static final class LazyRepositoryListener
    implements Runnable,
    RepositoryListener {
        private static final int TASK_DELAY = 500;
        private RequestProcessor.Task updaterTask;
        private List addedFS;
        private List removedFS;
        private List registeredUpdaters = new ArrayList(10);

        protected LazyRepositoryListener() {
        }

        public void register(BreakpointUpdater updater) {
            List list = this.registeredUpdaters;
            synchronized (list) {
                boolean wasEmpty = this.registeredUpdaters.isEmpty();
                this.registeredUpdaters.add(updater);
                if (wasEmpty) {
                    this.updaterTask = new RequestProcessor("BreakpointUpdater").create((Runnable)this);
                    Repository.getDefault().addRepositoryListener((RepositoryListener)this);
                }
            }
        }

        public void unregister(BreakpointUpdater updater) {
            List list = this.registeredUpdaters;
            synchronized (list) {
                this.registeredUpdaters.remove(updater);
                if (this.registeredUpdaters.isEmpty()) {
                    Repository.getDefault().removeRepositoryListener((RepositoryListener)this);
                    this.updaterTask = null;
                }
            }
        }

        public void run() {
            block14: {
                BreakpointUpdater[] updaters;
                ArrayList removedFS;
                ArrayList addedFS;
                LazyRepositoryListener lazyRepositoryListener = this;
                synchronized (lazyRepositoryListener) {
                    addedFS = this.addedFS == null ? null : new ArrayList(this.addedFS);
                    removedFS = this.removedFS == null ? null : new ArrayList(this.removedFS);
                    this.addedFS = null;
                    this.removedFS = null;
                }
                if (addedFS == null && removedFS == null) {
                    return;
                }
                List list = this.registeredUpdaters;
                synchronized (list) {
                    updaters = this.registeredUpdaters.isEmpty() ? null : this.registeredUpdaters.toArray(new BreakpointUpdater[0]);
                }
                if (updaters == null) break block14;
                if (addedFS == null) {
                    int i = 0;
                    while (i < updaters.length) {
                        updaters[i].fileSystemsRemoved(removedFS);
                        ++i;
                    }
                } else if (removedFS == null) {
                    int i = 0;
                    while (i < updaters.length) {
                        updaters[i].fileSystemsAdded(addedFS);
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < updaters.length) {
                        updaters[i].fileSystemsChanged(addedFS, removedFS);
                        ++i;
                    }
                }
            }
        }

        public final void fileSystemAdded(RepositoryEvent e) {
            LazyRepositoryListener lazyRepositoryListener = this;
            synchronized (lazyRepositoryListener) {
                if (this.addedFS == null) {
                    this.addedFS = new ArrayList(10);
                }
                this.addedFS.add(e.getFileSystem());
            }
            List list = this.registeredUpdaters;
            synchronized (list) {
                if (this.updaterTask != null) {
                    this.updaterTask.schedule(500);
                }
            }
        }

        public final void fileSystemRemoved(RepositoryEvent e) {
            LazyRepositoryListener lazyRepositoryListener = this;
            synchronized (lazyRepositoryListener) {
                if (this.removedFS == null) {
                    this.removedFS = new ArrayList(10);
                }
                this.removedFS.add(e.getFileSystem());
            }
            List list = this.registeredUpdaters;
            synchronized (list) {
                if (this.updaterTask != null) {
                    this.updaterTask.schedule(500);
                }
            }
        }

        public final void fileSystemPoolReordered(RepositoryReorderedEvent e) {
        }
    }
}

