/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.java;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Observer;
import java.util.Set;
import org.openide.cookies.SourceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.src.ClassElement;

public final class ClassLookup
implements Runnable {
    private boolean stopRequest;
    private String pkg;
    private Set result = new HashSet(35, 0.75f);
    private Observer observer;
    static /* synthetic */ Class class$org$openide$cookies$SourceCookie;

    public ClassLookup(Observer observer) {
        this.observer = observer;
    }

    public void run() throws IllegalStateException {
        if (this.pkg == null) {
            throw new IllegalStateException("Package not specified.");
        }
        Enumeration foldersEnum = Repository.getDefault().findAll(this.pkg, null, null);
        if (!foldersEnum.hasMoreElements()) {
            this.observer.update(null, null);
            return;
        }
        ArrayList result = new ArrayList();
        while (foldersEnum.hasMoreElements()) {
            DataFolder dataFolder;
            if (this.stopRequest) {
                return;
            }
            FileObject folder = (FileObject)foldersEnum.nextElement();
            try {
                dataFolder = DataFolder.findFolder((FileObject)folder);
            }
            catch (IllegalArgumentException ex) {
                continue;
            }
            DataObject[] children = dataFolder.getChildren();
            int count = children.length;
            int i = 0;
            while (i < count) {
                if (this.stopRequest) {
                    return;
                }
                SourceCookie srcCookie = (SourceCookie)children[i].getCookie(class$org$openide$cookies$SourceCookie == null ? ClassLookup.class$("org.openide.cookies.SourceCookie") : class$org$openide$cookies$SourceCookie);
                if (srcCookie != null) {
                    ClassElement[] clsElems = srcCookie.getSource().getAllClasses();
                    int clsElemCount = clsElems.length;
                    int j = 0;
                    while (j < clsElemCount) {
                        ClassElement clsElem = clsElems[j];
                        if (!clsElem.isInterface()) {
                            this.checkDuplicityAndNotify(clsElem);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        this.observer.update(null, null);
    }

    private void checkDuplicityAndNotify(Object obj) {
        if (this.result.add(obj)) {
            this.observer.update(null, obj);
        }
    }

    public void interrupt() {
        this.stopRequest = true;
    }

    public void setPackage(String pkgName) {
        this.pkg = pkgName;
        this.stopRequest = false;
        this.result.clear();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

