/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.java;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.netbeans.modules.debugger.CallStackFilter;
import org.netbeans.modules.debugger.CallStackProducer;
import org.netbeans.modules.debugger.Location;
import org.netbeans.modules.debugger.support.CompoundLocation;
import org.netbeans.modules.debugger.support.java.CallStackFrame;

public class CompactCallStackFilter
extends CallStackFilter {
    private PropertyChangeSupport pcs;
    private String[] filters = new String[0];
    private String[] names = new String[0];

    public CompactCallStackFilter() {
        this.init();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
    }

    protected void init() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public Location[] filterCallStack(CallStackProducer producer) {
        boolean normal = true;
        Location[] stack = producer.getCallStack();
        ArrayList<Location> nStack = new ArrayList<Location>();
        HashSet<String> name = new HashSet<String>();
        CompoundLocation cl = null;
        int k = stack.length;
        int i = 0;
        while (i < k) {
            String stackName = ((CallStackFrame)stack[i]).getClassName();
            int j = 0;
            while (j < this.filters.length) {
                if (stackName.startsWith(this.filters[j])) {
                    name.add(this.names[j]);
                    if (normal) {
                        normal = false;
                        break;
                    }
                    if (cl == null) {
                        cl = new CompoundLocation(producer);
                        cl.add(stack[i - 1]);
                        nStack.add(cl);
                    }
                    cl.add(stack[i]);
                    break;
                }
                ++j;
            }
            if (!(j != this.filters.length && i + 1 != k || normal)) {
                normal = true;
                if (cl != null) {
                    Iterator it = name.iterator();
                    String sName = "";
                    if (it.hasNext()) {
                        sName = "<" + (String)it.next();
                    }
                    while (it.hasNext()) {
                        sName = sName + "+" + (String)it.next();
                    }
                    sName = sName + ">";
                    cl.setName(sName);
                    cl = null;
                } else {
                    nStack.add(stack[i - 1]);
                }
                if (i + 1 < k) {
                    nStack.add(stack[i]);
                }
                name = new HashSet();
            } else if (normal) {
                nStack.add(stack[i]);
            }
            ++i;
        }
        Location[] ls = new Location[nStack.size()];
        return nStack.toArray(ls);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }
}

