/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.java;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.netbeans.modules.debugger.GUIManager;
import org.netbeans.modules.debugger.support.ProcessDebuggerInfo;
import org.netbeans.modules.debugger.support.actions.AddBreakpointAction;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.cookies.LineCookie;
import org.openide.debugger.DebuggerInfo;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.Element;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.SourceElement;
import org.openide.text.Line;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

public class JUtils
extends Utils {
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction;
    static /* synthetic */ Class class$org$openide$src$Element;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$openide$src$ConstructorElement;
    static /* synthetic */ Class class$org$openide$src$FieldElement;
    static /* synthetic */ Class class$org$openide$cookies$LineCookie;
    static /* synthetic */ Class class$org$openide$cookies$DebuggerCookie;

    public static String convertToStringInitializer(String s) {
        StringBuffer sb = new StringBuffer();
        int k = s.length();
        int i = 0;
        while (i < k) {
            switch (s.charAt(i)) {
                case '\b': {
                    sb.append("\\b");
                    break;
                }
                case '\f': {
                    sb.append("\\f");
                    break;
                }
                case '\\': {
                    sb.append("\\\\");
                    break;
                }
                case '\t': {
                    sb.append("\\t");
                    break;
                }
                case '\r': {
                    sb.append("\\r");
                    break;
                }
                case '\n': {
                    sb.append("\\n");
                    break;
                }
                case '\"': {
                    sb.append("\\\"");
                    break;
                }
                case '\'': {
                    sb.append("\\'");
                    break;
                }
                default: {
                    sb.append(s.charAt(i));
                }
            }
            ++i;
        }
        return new String(sb);
    }

    public static String getDefaultType() {
        if (!JUtils.isJava()) {
            return "";
        }
        String id = JUtils.getSelectedIdentifier();
        if (id.length() > 0) {
            if (id.equals(JUtils.getCurrentMethodName1())) {
                return "java-method";
            }
            String s = JUtils.getCurrentClassName();
            int i = s.lastIndexOf(46);
            if (i >= 0) {
                s = s.substring(i + 1);
            }
            if (id.equals(s)) {
                return "java-class";
            }
            return "java-field";
        }
        String s = JUtils.getCurrentFieldName();
        if (s.length() > 0) {
            return "java-field";
        }
        s = JUtils.getCurrentMethodName();
        if (s.length() < 1 && (s = JUtils.getCurrentClassName()).length() > 0) {
            return "java-class";
        }
        return "java-line";
    }

    public static String getCurrentClassName() {
        FileObject fo;
        AddBreakpointAction aba = (AddBreakpointAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction == null ? (class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction = JUtils.class$("org.netbeans.modules.debugger.support.actions.AddBreakpointAction")) : class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction));
        Node[] nodes = aba.getActivatedNodes();
        if (nodes == null) {
            return "";
        }
        if (nodes.length != 1) {
            return "";
        }
        Node n = nodes[0];
        Element e = (Element)n.getCookie(class$org$openide$src$Element == null ? (class$org$openide$src$Element = JUtils.class$("org.openide.src.Element")) : class$org$openide$src$Element);
        if (e != null) {
            return JUtils.getClassNameForElement(e);
        }
        DataObject dO = null;
        if (n instanceof DataNode) {
            dO = ((DataNode)n).getDataObject();
        }
        if (dO == null) {
            dO = (DataObject)n.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = JUtils.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
        }
        if (dO == null) {
            return "";
        }
        if (dO instanceof DataShadow) {
            dO = ((DataShadow)dO).getOriginal();
        }
        if (!(fo = dO.getPrimaryFile()).getMIMEType().equals("text/x-java")) {
            return "";
        }
        return fo.getPackageName('.');
    }

    public static boolean isJava() {
        AddBreakpointAction aba = (AddBreakpointAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction == null ? (class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction = JUtils.class$("org.netbeans.modules.debugger.support.actions.AddBreakpointAction")) : class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction));
        Node[] nodes = aba.getActivatedNodes();
        if (nodes == null) {
            return false;
        }
        if (nodes.length != 1) {
            return false;
        }
        Node n = nodes[0];
        DataObject dO = null;
        if (dO == null) {
            dO = (DataObject)n.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = JUtils.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
        }
        if (dO == null) {
            return false;
        }
        if (dO instanceof DataShadow) {
            dO = ((DataShadow)dO).getOriginal();
        }
        FileObject fo = dO.getPrimaryFile();
        return fo.getMIMEType().equals("text/x-java");
    }

    public static String getClassNameForElement(Element e) {
        if (e == null) {
            return "";
        }
        if (e instanceof ClassElement) {
            return JUtils.getClassName((ClassElement)e);
        }
        if (e instanceof ConstructorElement) {
            return JUtils.getClassName(((ConstructorElement)e).getDeclaringClass());
        }
        if (e instanceof FieldElement) {
            return JUtils.getClassName(((FieldElement)e).getDeclaringClass());
        }
        return "";
    }

    private static String getClassName(ClassElement e) {
        String f = e.getName().getFullName();
        if (!e.isInner()) {
            return f;
        }
        SourceElement sourceEl = e.getSource();
        if (sourceEl == null) {
            return f;
        }
        Identifier ident = sourceEl.getPackage();
        String c = ident == null ? "" : ident.getFullName();
        if (c.length() > 0) {
            return c + '.' + f.substring(c.length() + 1).replace('.', '$');
        }
        return f.replace('.', '$');
    }

    private static String getCurrentMethodName1() {
        AddBreakpointAction aba = (AddBreakpointAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction == null ? (class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction = JUtils.class$("org.netbeans.modules.debugger.support.actions.AddBreakpointAction")) : class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction));
        Node[] nodes = aba.getActivatedNodes();
        if (nodes == null) {
            return "";
        }
        if (nodes.length != 1) {
            return "";
        }
        Node n = nodes[0];
        ConstructorElement e = (ConstructorElement)n.getCookie(class$org$openide$src$ConstructorElement == null ? (class$org$openide$src$ConstructorElement = JUtils.class$("org.openide.src.ConstructorElement")) : class$org$openide$src$ConstructorElement);
        if (e == null) {
            return "";
        }
        return e.getName().getName();
    }

    public static String getCurrentMethodName() {
        String name = JUtils.getCurrentMethodName1();
        String cls = JUtils.getCurrentClassName();
        int i = cls.lastIndexOf(46);
        int j = cls.lastIndexOf(36);
        if (j > i) {
            i = j;
        }
        if (cls.substring(i + 1).equals(name)) {
            return "<init>";
        }
        return name;
    }

    public static String getCurrentFieldName() {
        AddBreakpointAction aba = (AddBreakpointAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction == null ? (class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction = JUtils.class$("org.netbeans.modules.debugger.support.actions.AddBreakpointAction")) : class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction));
        Node[] nodes = aba.getActivatedNodes();
        if (nodes == null) {
            return "";
        }
        if (nodes.length != 1) {
            return "";
        }
        Node n = nodes[0];
        FieldElement e = (FieldElement)n.getCookie(class$org$openide$src$FieldElement == null ? (class$org$openide$src$FieldElement = JUtils.class$("org.openide.src.FieldElement")) : class$org$openide$src$FieldElement);
        if (e != null) {
            return e.getName().getName();
        }
        return JUtils.getSelectedIdentifier();
    }

    public static String getSelectedIdentifier() {
        String s = Utils.getSelectedText();
        if (s == null) {
            return "";
        }
        if (!Utilities.isJavaIdentifier((String)s)) {
            return "";
        }
        return s;
    }

    public static HashMap processDebuggerInfo(DebuggerInfo info, String debuggerOptions, String main) {
        String repository = Utils.removeQuotationMarks(NbClassPath.createRepositoryPath((FileSystemCapability)FileSystemCapability.DEBUG).getClassPath());
        String library = Utils.removeQuotationMarks(NbClassPath.createLibraryPath().getClassPath());
        String classPath = Utils.removeQuotationMarks(NbClassPath.createClassPath().getClassPath());
        String bootClassPath = Utils.removeQuotationMarks(NbClassPath.createBootClassPath().getClassPath());
        if (bootClassPath == null) {
            bootClassPath = "";
        }
        String pathSeparator = System.getProperty("path.separator");
        String javaHome = System.getProperty("java.home");
        String jdkHome = System.getProperty("jdk.home");
        boolean classic = false;
        boolean assertEnabled = false;
        if (info instanceof ProcessDebuggerInfo) {
            ProcessDebuggerInfo processInfo = (ProcessDebuggerInfo)info;
            if (processInfo.getClassPath() != null) {
                classPath = Utils.removeQuotationMarks(processInfo.getClassPath());
            }
            if (processInfo.getBootClassPath() != null) {
                bootClassPath = Utils.removeQuotationMarks(processInfo.getBootClassPath());
            }
            if (processInfo.getRepositoryPath() != null) {
                repository = Utils.removeQuotationMarks(processInfo.getRepositoryPath());
            }
            if (processInfo.getLibraryPath() != null) {
                library = Utils.removeQuotationMarks(processInfo.getLibraryPath());
            }
            classic = processInfo.isClassic();
            assertEnabled = processInfo.isAssertEnabled();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("classic", classic ? "-classic " : "");
        map.put("assertEnabled", assertEnabled ? "-ea " : "");
        map.put("debuggerOptions", debuggerOptions);
        map.put("filesystems", repository);
        map.put("library", library.length() > 0 && repository.length() > 0 ? pathSeparator + library : library);
        map.put("classpath", classPath.length() > 0 && library.length() + repository.length() > 0 ? pathSeparator + classPath : classPath);
        map.put("bootclasspath", bootClassPath);
        map.put("bootclasspathSwitch", bootClassPath.length() < 1 ? "" : "-Xbootclasspath:");
        map.put("main", main);
        map.put("q", "\"");
        map.put("java.home", javaHome);
        map.put("jdk.home", jdkHome);
        map.put("/", System.getProperty("file.separator"));
        map.put(":", pathSeparator);
        return map;
    }

    public static boolean hasHotSpot(String path) {
        try {
            String sub = path.substring(0, path.lastIndexOf(File.separatorChar));
            sub = sub.substring(0, sub.lastIndexOf(File.separatorChar));
            sub = sub.substring(0, sub.lastIndexOf(File.separatorChar));
            File f = new File(sub + File.separatorChar + "bin" + File.separatorChar + "hotspot");
            if (f.exists()) {
                return true;
            }
            f = new File(sub + File.separatorChar + "lib" + File.separatorChar + "sparc" + File.separatorChar + "hotspot");
            if (f.exists()) {
                return true;
            }
            f = new File(sub = sub.concat(File.separator).concat("lib"));
            String[] list = f.list();
            if (list != null) {
                int x = 0;
                while (x < list.length) {
                    if (new File(sub + File.separatorChar + list[x] + File.separatorChar + "hotspot").exists()) {
                        return true;
                    }
                    ++x;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        final boolean[] hotSpotDetected = new boolean[]{false};
        try {
            final Process process = Runtime.getRuntime().exec(path.concat(" -version"));
            Thread t = new Thread(){

                public boolean checkStream(BufferedReader bufferedReader) {
                    int LIMIT = 10;
                    int lineCounter = 0;
                    boolean res = false;
                    try {
                        String line = bufferedReader.readLine();
                        while (line != null && lineCounter < 10) {
                            if (line.toLowerCase().indexOf("hotspot") > -1) {
                                res = true;
                                break;
                            }
                            line = bufferedReader.readLine();
                            ++lineCounter;
                        }
                        bufferedReader.close();
                    }
                    catch (IOException e) {
                    }
                    catch (SecurityException e) {
                        // empty catch block
                    }
                    return res;
                }

                public void run() {
                    hotSpotDetected[0] = false;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                    hotSpotDetected[0] = this.checkStream(bufferedReader);
                    if (!hotSpotDetected[0]) {
                        bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                        hotSpotDetected[0] = this.checkStream(bufferedReader);
                    }
                }
            };
            t.start();
            int counter = 12;
            while (counter-- > 0 && t.isAlive()) {
                try {
                    Thread.currentThread();
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            process.destroy();
            if (t.isAlive()) {
                try {
                    Thread.currentThread();
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            t.stop();
        }
        catch (IOException e) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return hotSpotDetected[0];
    }

    public static boolean classicPreferred(String str) {
        if (Utilities.getOperatingSystem() == 2048) {
            return false;
        }
        String version = System.getProperty("java.version");
        if (version.startsWith("1.3.0")) {
            return Utilities.getOperatingSystem() != 8;
        }
        StringTokenizer tokenizer = new StringTokenizer(version, ".");
        try {
            String token = tokenizer.nextToken();
            if (Integer.parseInt(token) > 1) {
                return false;
            }
            token = tokenizer.nextToken();
            if (Integer.parseInt(token) >= 3) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (str == null) {
            str = System.getProperty("jdk.home") + File.separatorChar + "bin" + File.separatorChar + "java";
        }
        return JUtils.hasHotSpot(str);
    }

    public static int[] getJavaVersion() {
        String version = System.getProperty("java.version");
        int[] result = new int[]{0, 0, 0};
        if (version == null) {
            return result;
        }
        int dotIndex = version.indexOf(46);
        if (dotIndex <= 0) {
            return result;
        }
        try {
            result[0] = Integer.parseInt(version.substring(0, dotIndex));
        }
        catch (NumberFormatException ex) {
            return result;
        }
        char[] chars = version.toCharArray();
        int i = dotIndex + 1;
        while (i < chars.length && Character.isDigit(chars[i])) {
            ++i;
        }
        if (i == dotIndex + 1) {
            result[0] = 0;
            return result;
        }
        try {
            result[1] = Integer.parseInt(version.substring(dotIndex + 1, i));
        }
        catch (NumberFormatException ex) {
            result[0] = 0;
            return result;
        }
        if (i < chars.length && chars[i] == '.') {
            dotIndex = i++;
            while (i < chars.length && Character.isDigit(chars[i])) {
                ++i;
            }
            if (i > dotIndex + 1) {
                try {
                    result[2] = Integer.parseInt(version.substring(dotIndex + 1, i));
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    public static String getShortInstanceName(Object o) {
        if (o == null) {
            return "null";
        }
        return JUtils.getClassName(o.getClass().getName()) + " @ " + System.identityHashCode(o);
    }

    public static String getClassName(String className) {
        int i = className.lastIndexOf(46);
        return i > 0 ? className.substring(i + 1) : className;
    }

    public static String getTopClassName(String className) {
        int i = className.indexOf(36);
        return i > 0 ? className.substring(0, i) : className;
    }

    public static String getPackageName(String className) {
        int i = className.lastIndexOf(46);
        return i > 0 ? className.substring(0, i) : "";
    }

    public static Line getLineForSource(String className, String sourceName, int lineNumber) {
        if (sourceName == null) {
            return JUtils.getLine(className, lineNumber);
        }
        int i = sourceName.lastIndexOf(46);
        if (i > 0) {
            sourceName = sourceName.substring(0, i);
        }
        return JUtils.getLine(JUtils.getPackageName(className), sourceName, lineNumber);
    }

    public static Line.Set getLineSet(String className) {
        LineCookie lineCookie = null;
        ClassElement cls = ClassElement.forName((String)JUtils.getTopClassName(className));
        if (cls != null) {
            lineCookie = (LineCookie)cls.getCookie(class$org$openide$cookies$LineCookie == null ? (class$org$openide$cookies$LineCookie = JUtils.class$("org.openide.cookies.LineCookie")) : class$org$openide$cookies$LineCookie);
        }
        if (lineCookie == null) {
            FileObject file = Repository.getDefault().find(JUtils.getPackageName(className), JUtils.getClassName(JUtils.getTopClassName(className)), "java");
            if (file == null) {
                file = Repository.getDefault().find(JUtils.getPackageName(className), JUtils.getClassName(JUtils.getTopClassName(className)), "jsp");
            }
            if (file == null) {
                return null;
            }
            DataObject data = null;
            try {
                data = DataObject.find((FileObject)file);
            }
            catch (Exception e) {
                return null;
            }
            if (data.getCookie(class$org$openide$cookies$DebuggerCookie == null ? (class$org$openide$cookies$DebuggerCookie = JUtils.class$("org.openide.cookies.DebuggerCookie")) : class$org$openide$cookies$DebuggerCookie) == null) {
                return null;
            }
            lineCookie = (LineCookie)data.getCookie(class$org$openide$cookies$LineCookie == null ? (class$org$openide$cookies$LineCookie = JUtils.class$("org.openide.cookies.LineCookie")) : class$org$openide$cookies$LineCookie);
            if (lineCookie == null) {
                return null;
            }
        }
        return lineCookie.getLineSet();
    }

    public static Line getCurrentLine(String className, int lineNumber) {
        Line.Set ls = JUtils.getLineSet(className);
        if (ls == null) {
            return null;
        }
        try {
            return ls.getCurrent(lineNumber - 1);
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        return null;
    }

    private static Line getLine(String packageName, String className, int lineNumber) {
        String name = packageName.length() == 0 ? className : packageName + '.' + className;
        return JUtils.getLine(name, lineNumber);
    }

    public static Line getLine(String className, int lineNumber) {
        Line.Set ls = JUtils.getLineSet(className);
        if (ls == null) {
            return null;
        }
        try {
            Line l = ls.getOriginal(lineNumber - 1);
            FileSystem fs = l.getDataObject().getPrimaryFile().getFileSystem();
            if (fs.getCapability().capableOf(GUIManager.DEBUG_SRC)) {
                return l;
            }
            if (fs.isHidden()) {
                return null;
            }
            return l;
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (FileStateInvalidException ex) {
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

