/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.java;

import java.util.Hashtable;
import org.netbeans.modules.debugger.support.java.JavaVariable;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.InitializerElement;
import org.openide.src.MethodElement;
import org.openide.src.SourceException;

public abstract class JavaClass {
    private ClassElement element = null;
    private Hashtable innerClasses = new Hashtable();

    public abstract String getName();

    public abstract JavaClass[] getInnerClasses();

    public abstract MethodElement[] getMethods();

    public abstract ConstructorElement[] getConstructors();

    public abstract InitializerElement[] getInitializers();

    public abstract FieldElement[] getFields();

    public abstract boolean isClass();

    public abstract int modifiers();

    public abstract String classLoaderTypeName();

    public abstract JavaVariable getClassLoader();

    public abstract JavaVariable getStaticVariable(FieldElement var1);

    public abstract boolean isPrepared();

    public abstract Identifier getSuperClass();

    public abstract Identifier[] getInterfaces();

    public String getClassName() {
        String name = this.getName();
        int i = name.lastIndexOf(46) + 1;
        int j = name.lastIndexOf(36) + 1;
        return name.substring(j > i ? j : i);
    }

    protected static final Identifier createClassIdentifier(String fullName) {
        if (fullName == "") {
            return Identifier.create((String)"");
        }
        int i = fullName.lastIndexOf(46) + 1;
        int j = fullName.lastIndexOf(36) + 1;
        return Identifier.create((String)fullName, (String)fullName.substring(j > i ? j : i));
    }

    public ClassElement toClassElement() {
        if (this.element != null) {
            return this.element;
        }
        try {
            this.element = new ClassElement();
            JavaClass[] inner = this.getInnerClasses();
            this.innerClasses = new Hashtable();
            ClassElement[] classes = new ClassElement[inner.length];
            int x = 0;
            while (x < inner.length) {
                classes[x] = inner[x].toClassElement();
                if (classes[x] == null) {
                    classes[x] = new ClassElement();
                }
                this.innerClasses.put(inner[x].getClassName(), inner[x]);
                ++x;
            }
            this.element.setName(JavaClass.createClassIdentifier(this.getName()));
            this.element.setClasses(classes);
            this.element.setClassOrInterface(this.isClass());
            Identifier superClass = this.getSuperClass();
            if (superClass != null) {
                this.element.setSuperclass(superClass);
            }
            this.element.setInterfaces(this.getInterfaces());
            if (this.isPrepared()) {
                this.element.setConstructors(this.getConstructors());
                this.element.setMethods(this.getMethods());
                this.element.setInitializers(this.getInitializers());
                this.element.setFields(this.getFields());
            }
            this.element.setModifiers(this.modifiers());
        }
        catch (SourceException e) {
            e.printStackTrace();
        }
        return this.element;
    }

    public void updateClassElement(ClassElement element) {
        try {
            this.innerClasses = new Hashtable();
            JavaClass[] inner = this.getInnerClasses();
            ClassElement[] classes = new ClassElement[inner.length];
            int x = 0;
            while (x < inner.length) {
                classes[x] = inner[x].toClassElement();
                if (classes[x] == null) {
                    classes[x] = new ClassElement();
                }
                this.innerClasses.put(inner[x].getClassName(), inner[x]);
                ++x;
            }
            element.setClasses(classes);
            if (this.isPrepared()) {
                element.setConstructors(this.getConstructors());
                element.setMethods(this.getMethods());
                element.setInitializers(this.getInitializers());
                element.setFields(this.getFields());
            }
            element.setModifiers(this.modifiers());
        }
        catch (SourceException e) {
            e.printStackTrace();
        }
    }

    public void updateInnerClasses(ClassElement element) {
        try {
            Hashtable<String, JavaClass> temp = new Hashtable<String, JavaClass>();
            ClassElement[] last = element.getClasses();
            JavaClass[] inner = this.getInnerClasses();
            int x = 0;
            while (x < inner.length) {
                ClassElement el = inner[x].toClassElement();
                JavaClass clazz = (JavaClass)this.innerClasses.get(inner[x].getClassName());
                if (clazz == null) {
                    this.innerClasses.put(inner[x].getClassName(), inner[x]);
                    element.addClass(el);
                }
                temp.put(inner[x].getClassName(), inner[x]);
                ++x;
            }
            int x2 = 0;
            while (x2 < last.length) {
                if (temp.get(last[x2].getName().getName()) == null) {
                    element.removeClass(last[x2]);
                }
                ++x2;
            }
            this.innerClasses = temp;
        }
        catch (SourceException e) {
            e.printStackTrace();
        }
    }

    public JavaClass findInnerClass(ClassElement el) {
        return (JavaClass)this.innerClasses.get(el.getName().getName());
    }
}

