/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.java;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.netbeans.modules.debugger.AbstractDebuggerInfo;
import org.netbeans.modules.debugger.AbstractThread;
import org.netbeans.modules.debugger.CallStackFilter;
import org.netbeans.modules.debugger.CallStackRoot;
import org.netbeans.modules.debugger.CoreDebugger;
import org.netbeans.modules.debugger.Location;
import org.netbeans.modules.debugger.Register;
import org.netbeans.modules.debugger.State;
import org.netbeans.modules.debugger.ThreadsProducer;
import org.netbeans.modules.debugger.ThreadsRoot;
import org.netbeans.modules.debugger.Validator;
import org.netbeans.modules.debugger.ValidatorHolder;
import org.netbeans.modules.debugger.VariablesFilter;
import org.netbeans.modules.debugger.VariablesRoot;
import org.netbeans.modules.debugger.support.DebuggerAnnotation;
import org.netbeans.modules.debugger.support.IOManager;
import org.netbeans.modules.debugger.support.SecondaryDebuggerSupport;
import org.netbeans.modules.debugger.support.StateSupport;
import org.netbeans.modules.debugger.support.actions.CreateVariableAction;
import org.netbeans.modules.debugger.support.actions.SuspendResumeSupport;
import org.netbeans.modules.debugger.support.java.JavaDebuggerSettings;
import org.netbeans.modules.debugger.support.java.JavaProjectSettings;
import org.netbeans.modules.debugger.support.java.JavaThread;
import org.netbeans.modules.debugger.support.java.JavaThreadGroup;
import org.netbeans.modules.debugger.support.util.Utils;
import org.netbeans.modules.debugger.support.util.ValidatorImpl;
import org.openide.actions.AbstractCompileAction;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.CompilerCookie;
import org.openide.debugger.DebuggerException;
import org.openide.debugger.DebuggerInfo;
import org.openide.src.ClassElement;
import org.openide.text.Line;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.SharedClassObject;
import org.openide.util.actions.SystemAction;

public abstract class JavaDebugger
extends SecondaryDebuggerSupport
implements ThreadsRoot,
ValidatorHolder,
SuspendResumeSupport,
VariablesRoot,
CallStackRoot {
    static final long serialVersionUID = 2791304615739651906L;
    public static final State STATE_RUNNING = new StateSupport(32);
    public static final State STATE_STARTING = new StateSupport(0);
    private transient boolean generalIOName = true;
    private transient Validator validator = new ValidatorImpl();
    private transient Listener listener;
    private transient CoreDebugger coreDebugger;
    boolean showMessages = false;
    boolean followedByEditor = true;
    private transient IOManager io;
    private transient HashMap stackAnnotations = new HashMap();
    private transient DebuggerAnnotation currentPC = new DebuggerAnnotation.CurrentPC();
    protected transient boolean suspendedPatch = false;
    private RequestProcessor.Task updateUITask = null;
    public static final long MODE_DONT_MAKE_CURRENT = 1L;
    private long quietMode;
    private CallStackFilter csFilter;
    private VariablesFilter filter;
    private static String errMsgPattern;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$java$JavaDebugger;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$CreateVariableAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$java$JavaDebuggerSettings;
    static /* synthetic */ Class class$org$openide$cookies$CompilerCookie$Compile;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$java$JavaProjectSettings;

    protected static String getString(String key) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$debugger$support$java$JavaDebugger == null ? (class$org$netbeans$modules$debugger$support$java$JavaDebugger = JavaDebugger.class$("org.netbeans.modules.debugger.support.java.JavaDebugger")) : class$org$netbeans$modules$debugger$support$java$JavaDebugger), (String)key);
    }

    public void startDebugger(DebuggerInfo info) throws DebuggerException {
        super.startDebugger(info);
        this.io = new IOManager(this);
        this.io.println(JavaDebugger.getString("CTL_Debugger_starting"), 4);
        this.coreDebugger = Register.getCoreDebugger();
        this.listener = new Listener();
        this.coreDebugger.addPropertyChangeListener(this.listener);
        ((CreateVariableAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$CreateVariableAction == null ? (class$org$netbeans$modules$debugger$support$actions$CreateVariableAction = JavaDebugger.class$("org.netbeans.modules.debugger.support.actions.CreateVariableAction")) : class$org$netbeans$modules$debugger$support$actions$CreateVariableAction))).changeEnabled(true);
    }

    public synchronized void finishDebugger() throws DebuggerException {
        JavaThreadGroup ttg;
        if (this.getState() == 1) {
            return;
        }
        if (this.io != null) {
            this.io.stop();
        }
        if ((ttg = (JavaThreadGroup)this.getThreadsRoot()) != null) {
            ttg.removeAll();
        }
        this.setCurrentThread(null);
        this.setState(1);
        ((CreateVariableAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$CreateVariableAction == null ? (class$org$netbeans$modules$debugger$support$actions$CreateVariableAction = JavaDebugger.class$("org.netbeans.modules.debugger.support.actions.CreateVariableAction")) : class$org$netbeans$modules$debugger$support$actions$CreateVariableAction))).changeEnabled(false);
        this.validator.clear();
        this.updateUI();
        this.updateUITask = null;
        this.setCurrentLine(null);
        Register.getCoreDebugger().removePropertyChangeListener(this.listener);
        this.listener = null;
        this.clearCallStackAnnotations();
    }

    public void traceInto() throws DebuggerException {
        this.io.println(JavaDebugger.getString("CTL_Debugger_running"), 4);
        this.setState(3);
        this.setLastAction(3);
        this.setCurrentLine(null);
    }

    public void traceOver() throws DebuggerException {
        this.io.println(JavaDebugger.getString("CTL_Debugger_running"), 4);
        this.setState(3);
        this.setLastAction(2);
        this.setCurrentLine(null);
    }

    public void go() throws DebuggerException {
        this.io.println(JavaDebugger.getString("CTL_Debugger_running"), 4);
        this.setState(3);
        this.setLastAction(5);
        this.setCurrentLine(null);
        this.clearCallStackAnnotations();
    }

    public void stepOut() throws DebuggerException {
        this.io.println(JavaDebugger.getString("CTL_Debugger_running"), 4);
        this.setState(3);
        this.setLastAction(4);
        this.setCurrentLine(null);
        this.clearCallStackAnnotations();
    }

    public void runToCursor(Line l) {
        this.io.println(JavaDebugger.getString("CTL_Debugger_running"), 4);
        this.setState(3);
        this.setLastAction(10);
        this.setCurrentLine(null);
        this.clearCallStackAnnotations();
    }

    public void pause() {
        ((JavaThreadGroup)this.getThreadsRoot()).setSuspended(true);
        this.setState(4);
    }

    public void goToCalledMethod() {
        JavaThread markedThread = (JavaThread)this.getCurrentThread();
        int markedCallStackFrame = markedThread.getCurrentCallStackFrameIndex();
        if (markedThread != null && markedCallStackFrame > 0) {
            markedThread.setCurrentCallStackFrameIndex(--markedCallStackFrame);
            JavaDebugger.showCallStackLocation(markedThread.getCallStack()[markedCallStackFrame]);
            this.updateStoppedState();
        }
    }

    public void goToCallingMethod() {
        JavaThread markedThread = (JavaThread)this.getCurrentThread();
        int markedCallStackFrame = markedThread.getCurrentCallStackFrameIndex();
        if (markedThread != null && markedCallStackFrame < markedThread.getStackDepth() - 1) {
            markedThread.setCurrentCallStackFrameIndex(++markedCallStackFrame);
            JavaDebugger.showCallStackLocation(markedThread.getCallStack()[markedCallStackFrame]);
            this.updateStoppedState();
        }
    }

    public void setCurrentLine(Line l) {
        if (l == this.getCurrentLine()) {
            return;
        }
        if (this.coreDebugger.getCurrentDebugger() == this) {
            if (l != null) {
                Utils.showInEditor(l);
                this.currentPC.attachLine(l);
            } else {
                this.currentPC.detachLine();
            }
        }
        super.setCurrentLine(l);
    }

    public void annotateCallStack() {
        HashMap hashMap = this.stackAnnotations;
        synchronized (hashMap) {
            JavaThread thread = (JavaThread)this.getCurrentThread();
            Location[] stack = thread != null ? thread.getCallStack() : new Location[]{};
            HashMap<Line, DebuggerAnnotation> tempAnno = new HashMap<Line, DebuggerAnnotation>();
            HashSet<Object[]> batchAttach = new HashSet<Object[]>(3);
            int x = 1;
            while (x < stack.length) {
                Line line = stack[x].getLine();
                if (line != null) {
                    DebuggerAnnotation anno = (DebuggerAnnotation)((Object)this.stackAnnotations.remove(line));
                    if (anno == null) {
                        anno = new DebuggerAnnotation.CallSite();
                        DebuggerAnnotation oldAnno = tempAnno.put(line, anno);
                        if (oldAnno == null) {
                            batchAttach.add(new Object[]{anno, line});
                        } else {
                            tempAnno.put(line, oldAnno);
                        }
                    } else {
                        tempAnno.put(line, anno);
                    }
                }
                ++x;
            }
            Iterator it = batchAttach.iterator();
            while (it.hasNext()) {
                Object[] annotationLinePair = (Object[])it.next();
                DebuggerAnnotation anno = (DebuggerAnnotation)((Object)annotationLinePair[0]);
                Line line = (Line)annotationLinePair[1];
                anno.attachLine(line);
            }
            Iterator iter = this.stackAnnotations.entrySet().iterator();
            while (iter.hasNext()) {
                ((DebuggerAnnotation)((Object)iter.next().getValue())).detachLine();
            }
            this.stackAnnotations = tempAnno;
        }
    }

    public void clearCallStackAnnotations() {
        HashMap hashMap = this.stackAnnotations;
        synchronized (hashMap) {
            Iterator iter = this.stackAnnotations.entrySet().iterator();
            while (iter.hasNext()) {
                DebuggerAnnotation next = (DebuggerAnnotation)((Object)iter.next().getValue());
                if (!(next instanceof DebuggerAnnotation.CallSite)) continue;
                next.detachLine();
            }
            this.stackAnnotations.clear();
        }
    }

    public Validator getValidator() {
        return this.validator;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public abstract AbstractThread getCurrentThread();

    public abstract void setCurrentThread(AbstractThread var1);

    public boolean compile(DebuggerInfo info) {
        JavaDebuggerSettings jds = (JavaDebuggerSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$debugger$support$java$JavaDebuggerSettings == null ? (class$org$netbeans$modules$debugger$support$java$JavaDebuggerSettings = JavaDebugger.class$("org.netbeans.modules.debugger.support.java.JavaDebuggerSettings")) : class$org$netbeans$modules$debugger$support$java$JavaDebuggerSettings), (boolean)true);
        if (!jds.getRunCompilation()) {
            return true;
        }
        String className = info.getClassName();
        if (className == null) {
            return true;
        }
        ClassElement clsElement = ClassElement.forName((String)className);
        if (clsElement == null) {
            return true;
        }
        HashSet<CompilerCookie> compile = new HashSet<CompilerCookie>();
        CompilerCookie comp = (CompilerCookie)clsElement.getCookie(class$org$openide$cookies$CompilerCookie$Compile == null ? (class$org$openide$cookies$CompilerCookie$Compile = JavaDebugger.class$("org.openide.cookies.CompilerCookie$Compile")) : class$org$openide$cookies$CompilerCookie$Compile);
        if (comp == null) {
            return true;
        }
        compile.add(comp);
        return AbstractCompileAction.compile(Collections.enumeration(compile), (String)"");
    }

    protected void setState(int state) {
        if (this.getState() == state) {
            return;
        }
        super.setState(state);
        switch (state) {
            case 1: {
                this.setDebuggerState(SecondaryDebuggerSupport.STATE_NOT_RUNNING);
                break;
            }
            case 3: {
                this.updateRunningState();
                break;
            }
            case 2: {
                this.setDebuggerState(STATE_STARTING);
                break;
            }
            case 4: {
                this.updateStoppedState();
            }
        }
    }

    public String getProcessName(DebuggerInfo info) {
        String s;
        if (info instanceof AbstractDebuggerInfo && (s = ((AbstractDebuggerInfo)info).getProcessName()) != null) {
            return s;
        }
        return info.getStopClassName() != null ? info.getStopClassName() : info.getClassName();
    }

    public abstract String getLocationName(DebuggerInfo var1);

    protected void updateUI() {
        if (this.updateUITask != null) {
            this.updateUITask.cancel();
        }
        this.updateUITask = RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                JavaDebugger.this.updateUINow();
            }
        }, (int)500, (int)1);
    }

    protected void updateUINow() {
        if (this.getState() != 4) {
            return;
        }
        if (this.getCurrentThread() == null) {
            this.clearCallStackAnnotations();
        } else {
            this.annotateCallStack();
        }
        if (System.getProperty("netbeans.debug.step") != null) {
            System.err.println("JPDADebugger.updateUINow - 3) annotateCallStack () done");
        }
        if (this.getState() != 4) {
            return;
        }
        this.getValidator().validate();
        if (System.getProperty("netbeans.debug.step") != null) {
            System.err.println("JPDADebugger.updateUINow - 4) getValidator ().validate () done");
        }
    }

    public boolean canBeCurrent(Line l, boolean onBreakpoint) {
        return l.canBeMarkedCurrent(onBreakpoint ? 1 : this.getLastAction(), this.getCurrentLine());
    }

    public void setQuietMode(long quietMode) {
        this.quietMode = quietMode;
    }

    public long getQuietMode() {
        return this.quietMode;
    }

    public CallStackFilter getCallStackFilter() {
        if (this.csFilter != null) {
            return this.csFilter;
        }
        JavaProjectSettings jps = (JavaProjectSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$debugger$support$java$JavaProjectSettings == null ? (class$org$netbeans$modules$debugger$support$java$JavaProjectSettings = JavaDebugger.class$("org.netbeans.modules.debugger.support.java.JavaProjectSettings")) : class$org$netbeans$modules$debugger$support$java$JavaProjectSettings), (boolean)true);
        return jps.getCallStackFilter();
    }

    public void setCallStackFilter(CallStackFilter csFilter) {
        if (csFilter == this.csFilter) {
            return;
        }
        if (csFilter != null && csFilter.equals(this.csFilter)) {
            return;
        }
        CallStackFilter old = this.csFilter;
        this.csFilter = csFilter;
        this.firePropertyChange("callStackFilter", old, csFilter);
    }

    public VariablesFilter getVariablesFilter() {
        if (this.filter != null) {
            return this.filter;
        }
        JavaProjectSettings jps = (JavaProjectSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$debugger$support$java$JavaProjectSettings == null ? (class$org$netbeans$modules$debugger$support$java$JavaProjectSettings = JavaDebugger.class$("org.netbeans.modules.debugger.support.java.JavaProjectSettings")) : class$org$netbeans$modules$debugger$support$java$JavaProjectSettings), (boolean)true);
        return jps.getVariablesFilter();
    }

    public void setVariablesFilter(VariablesFilter filter) {
        if (filter == this.filter) {
            return;
        }
        if (filter != null && filter.equals(this.filter)) {
            return;
        }
        VariablesFilter old = this.filter;
        this.filter = filter;
        this.firePropertyChange("variablesFilter", old, filter);
    }

    public String getInfo() {
        return null;
    }

    protected void updateStoppedState() {
        int s = 64;
        JavaThread t = (JavaThread)this.getCurrentThread();
        if (this.suspendedPatch || t != null && t.isSuspended()) {
            int markedCallStackFrame = t.getCurrentCallStackFrameIndex();
            s |= 0x17;
            if (markedCallStackFrame > 0) {
                s |= 0x100;
            }
            if (markedCallStackFrame < t.getStackDepth() - 1) {
                s |= 0x80;
            }
        }
        if (this.getStoppedStateForFix()) {
            s |= 0x400;
        }
        if (this.getPopTopmostFrameState()) {
            s |= 0x200;
        }
        this.setDebuggerState(new StateSupport(s));
    }

    protected void updateRunningState() {
        this.setDebuggerState(STATE_RUNNING);
    }

    protected boolean getStoppedStateForFix() {
        return false;
    }

    protected boolean getPopTopmostFrameState() {
        return false;
    }

    public IOManager getIOManager() {
        return this.io;
    }

    private static void showCallStackLocation(Location loc) {
        Line line = loc.getLine();
        if (line != null) {
            line.show(1);
        } else {
            if (errMsgPattern == null) {
                errMsgPattern = NbBundle.getMessage((Class)(class$org$netbeans$modules$debugger$support$java$JavaDebugger == null ? (class$org$netbeans$modules$debugger$support$java$JavaDebugger = JavaDebugger.class$("org.netbeans.modules.debugger.support.java.JavaDebugger")) : class$org$netbeans$modules$debugger$support$java$JavaDebugger), (String)"MSG_Call_stack_location_not_available");
            }
            StatusDisplayer.getDefault().setStatusText(MessageFormat.format(errMsgPattern, loc.getLocationName()));
        }
    }

    public abstract ThreadsProducer getThreadsRoot();

    public abstract void setSuspended(boolean var1);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Listener
    implements PropertyChangeListener {
        private Listener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName() != "currentDebugger") {
                return;
            }
            if (JavaDebugger.this.coreDebugger.getCurrentDebugger() == JavaDebugger.this) {
                Line l = JavaDebugger.this.getCurrentLine();
                if (l != null) {
                    Utils.showInEditor(l);
                    JavaDebugger.this.currentPC.attachLine(l);
                }
            } else {
                JavaDebugger.this.currentPC.detachLine();
            }
        }
    }
}

