/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.java;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.debugger.support.java.ClassLookup;
import org.netbeans.modules.debugger.support.java.PackageClassHistory;
import org.netbeans.modules.debugger.support.util.AbstractHistory;
import org.netbeans.modules.debugger.support.util.HistoryEvent;
import org.netbeans.modules.debugger.support.util.HistoryListener;
import org.netbeans.modules.debugger.support.util.PackageListLoader;
import org.openide.modules.Dependency;
import org.openide.modules.SpecificationVersion;
import org.openide.src.ClassElement;
import org.openide.src.FieldElement;
import org.openide.src.InitializerElement;
import org.openide.src.MethodElement;
import org.openide.util.NbBundle;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public final class JavaElementSelector
implements Observer,
ActionListener {
    public static final int PACKAGE_ELEMENT = 1;
    public static final int CLASS_ELEMENT = 2;
    public static final int INIT_ELEMENT = 4;
    public static final int CLINIT_ELEMENT = 8;
    public static final int METHOD_ELEMENT = 16;
    public static final int FIELD_ELEMENT = 32;
    protected static final int MEMBER_ELEMENTS = 60;
    protected static final String LOADING_PACKAGE_NAMES = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$support$java$JavaElementSelector == null ? (class$org$netbeans$modules$debugger$support$java$JavaElementSelector = JavaElementSelector.class$("org.netbeans.modules.debugger.support.java.JavaElementSelector")) : class$org$netbeans$modules$debugger$support$java$JavaElementSelector)).getString("CTL_Loading_package_names");
    protected static final String SEARCHING = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$support$java$JavaElementSelector == null ? (class$org$netbeans$modules$debugger$support$java$JavaElementSelector = JavaElementSelector.class$("org.netbeans.modules.debugger.support.java.JavaElementSelector")) : class$org$netbeans$modules$debugger$support$java$JavaElementSelector)).getString("CTL_searching");
    protected static final String CLINIT_DESCRIPTION = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$support$java$JavaElementSelector == null ? (class$org$netbeans$modules$debugger$support$java$JavaElementSelector = JavaElementSelector.class$("org.netbeans.modules.debugger.support.java.JavaElementSelector")) : class$org$netbeans$modules$debugger$support$java$JavaElementSelector)).getString("CTL_clinit_description");
    protected static final String INIT_DESCRIPTION = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$support$java$JavaElementSelector == null ? (class$org$netbeans$modules$debugger$support$java$JavaElementSelector = JavaElementSelector.class$("org.netbeans.modules.debugger.support.java.JavaElementSelector")) : class$org$netbeans$modules$debugger$support$java$JavaElementSelector)).getString("CTL_init_description");
    protected static final JComponent SEPARATOR = new JSeparator();
    protected static final ListCellRenderer LIST_CELL_RENDERER = new ComboBoxItemRenderer();
    protected static final Collection STANDARD_JAVA_EXCEPTIONS;
    protected static final Object DUMMY_OBJECT;
    private List changeListeners;
    private boolean packageEdited;
    private boolean classEdited;
    private final boolean initElem;
    private final boolean clinitElem;
    private final boolean fieldElem;
    private final boolean methodElem;
    private final boolean lookForMembers;
    private String lastPackage;
    private Object lastClass;
    private AbstractHistory packageHistory;
    private PackageClassHistory classHistory;
    protected final Map classElementMap;
    protected final int elementsMask;
    protected JComboBox cboxPackage;
    protected JComboBox cboxClass;
    protected JComboBox cboxMember;
    protected MyMutableComboBoxModel cboxPackageModel;
    protected MyMutableComboBoxModel cboxClassModel;
    protected MyMutableComboBoxModel cboxMemberModel;
    protected ClassLookup classLookup;
    protected Thread classLookupThread;
    protected String needMembersForClassName;
    protected boolean exceptionFilter;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$java$JavaElementSelector;

    public JavaElementSelector(int elementsMask) {
        this.elementsMask = elementsMask;
        this.lookForMembers = (elementsMask & 0x3C) != 0;
        this.cboxPackageModel = new MyMutableComboBoxModel();
        this.cboxPackage = new JComboBox(this.cboxPackageModel);
        this.loadPackageNames();
        this.cboxClassModel = new MyMutableComboBoxModel();
        this.cboxClass = new JComboBox(this.cboxClassModel);
        this.cboxPackage.setEditable(true);
        this.cboxClass.setEditable(true);
        this.cboxPackage.setRenderer(LIST_CELL_RENDERER);
        this.cboxClass.setRenderer(LIST_CELL_RENDERER);
        this.classElementMap = new HashMap(26, 0.75f);
        if (this.lookForMembers) {
            this.cboxMemberModel = new MyMutableComboBoxModel();
            this.cboxMember = new JComboBox(this.cboxMemberModel);
            this.cboxMember.setEditable(true);
            this.initElem = (elementsMask & 4) != 0;
            this.clinitElem = (elementsMask & 8) != 0;
            this.methodElem = (elementsMask & 0x10) != 0;
            this.fieldElem = (elementsMask & 0x20) != 0;
        } else {
            this.initElem = false;
            this.clinitElem = false;
            this.methodElem = false;
            this.fieldElem = false;
        }
        this.cboxPackage.addActionListener(this);
        this.cboxClass.addActionListener(this);
        this.cboxPackage.getEditor().getEditorComponent().addFocusListener(new ComboBoxFocusListener(this.cboxPackage));
        this.cboxClass.getEditor().getEditorComponent().addFocusListener(new ComboBoxFocusListener(this.cboxClass));
        if (this.cboxMember != null) {
            this.cboxMember.getEditor().getEditorComponent().addFocusListener(new ComboBoxFocusListener(this.cboxMember));
        }
    }

    private void loadPackageNames() {
        List packageNames = PackageListLoader.getPackageNames();
        if (packageNames != null) {
            this.cboxPackageModel.setElements(packageNames);
        } else {
            this.cboxPackageModel.setSingleElement(LOADING_PACKAGE_NAMES);
            PackageListLoader.loadPackageNames(new TaskListener(){

                public void taskFinished(Task task) {
                    List packageNames2 = PackageListLoader.getPackageNames();
                    if (packageNames2 == null) {
                        throw new IllegalStateException("Could not load list of package names.");
                    }
                    JavaElementSelector.this.cboxPackageModel.setElements(packageNames2);
                }
            });
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JComboBox source = (JComboBox)actionEvent.getSource();
        if (source == this.cboxPackage) {
            this.packageEdited = true;
        } else if (source == this.cboxClass) {
            this.classEdited = true;
        }
    }

    public void setInitialSelection(String pkg, String cls) {
        this.setInitialSelection(pkg, cls, null);
    }

    public void setExceptionFilter(boolean on) {
        this.exceptionFilter = on;
    }

    public void setInitialSelection(String pkg, String cls, String member) {
        if (this.lookForMembers && member != null) {
            this.cboxMember.setSelectedItem(member);
        }
        if (cls != null) {
            this.cboxClass.setSelectedItem(cls);
            this.lastClass = cls;
            this.needMembersForClassName = cls;
        }
        if (pkg != null) {
            this.cboxPackage.setSelectedItem(pkg);
            this.loadClassList(pkg);
            this.lastPackage = pkg;
        }
        if (this.classHistory != null) {
            this.classHistory.setPackage(pkg != null ? pkg : "");
        }
    }

    public void setPackageHistory(AbstractHistory history) {
        if (history != this.packageHistory) {
            if (this.packageHistory != null) {
                this.packageHistory.removeHistoryListener(this.cboxPackageModel);
                this.cboxPackageModel.setHistory(null);
            }
            this.packageHistory = history;
            if (this.packageHistory != null) {
                this.cboxPackageModel.setHistory(this.packageHistory);
                this.packageHistory.addHistoryListener(this.cboxPackageModel);
            }
        }
    }

    public void setClassHistory(PackageClassHistory history) {
        if (history != this.classHistory) {
            if (this.classHistory != null) {
                this.classHistory.removeHistoryListener(this.cboxClassModel);
                this.cboxClassModel.setHistory(null);
            }
            this.classHistory = history;
            if (this.classHistory != null) {
                this.classHistory.setPackage((String)this.cboxClass.getEditor().getItem());
                this.cboxClassModel.setHistory(this.classHistory);
                this.classHistory.addHistoryListener(this.cboxClassModel);
            }
        }
    }

    public static final String getShortClassName(ClassElement clsElem) {
        if (clsElem.isInner()) {
            String vmName = clsElem.getVMName();
            return vmName.substring(vmName.lastIndexOf(46) + 1).replace('$', '.');
        }
        return clsElem.getName().getName();
    }

    public JComboBox getPackageSelector() {
        return this.cboxPackage;
    }

    public JComboBox getClassSelector() {
        return this.cboxClass;
    }

    public JComboBox getMemberSelector() {
        return this.cboxMember;
    }

    public String getSelectedPackage() {
        return ((String)this.cboxPackage.getEditor().getItem()).trim();
    }

    public String getSelectedClass() {
        return ((String)this.cboxClass.getEditor().getItem()).trim();
    }

    public String getSelectedMember() {
        return ((String)this.cboxMember.getEditor().getItem()).trim();
    }

    private void cboxPackageFocusLost() {
        String selectedPackage = ((String)this.cboxPackage.getEditor().getItem()).trim();
        if (this.packageEdited && !selectedPackage.equals(this.lastPackage)) {
            this.loadClassList(selectedPackage);
        }
        this.lastPackage = selectedPackage;
        this.packageEdited = false;
    }

    private void cboxClassFocusLost() {
        if (this.classEdited && this.lookForMembers) {
            String cls = ((String)this.cboxClass.getEditor().getItem()).trim();
            if (!cls.equals(this.lastClass)) {
                ClassElement clsElem = null;
                JavaElementSelector javaElementSelector = this;
                synchronized (javaElementSelector) {
                    if (cls.length() != 0 && (clsElem = (ClassElement)this.classElementMap.get(cls)) == null) {
                        this.needMembersForClassName = cls;
                    }
                    if (clsElem == null) {
                        this.cboxMemberModel.removeAllElements();
                    } else {
                        this.loadMemberList(clsElem);
                    }
                }
            }
            this.lastClass = cls;
            this.classEdited = false;
        }
    }

    private void loadClassList(String pkg) {
        if (this.exceptionFilter && pkg.equals("java.lang")) {
            this.waitForClassLookupThread();
            this.cboxClassModel.setElements(STANDARD_JAVA_EXCEPTIONS);
        } else {
            if (this.classLookup == null) {
                this.classLookup = new ClassLookup(this);
            }
            this.waitForClassLookupThread();
            this.classElementMap.clear();
            if (this.lookForMembers) {
                this.cboxMemberModel.removeAllElements();
                this.needMembersForClassName = ((String)this.cboxClass.getEditor().getItem()).trim();
            }
            this.cboxClassModel.setSingleElement(SEARCHING);
            this.classLookup.setPackage(pkg);
            this.classLookupThread = new Thread((Runnable)this.classLookup, "Debugger Class Lookup");
            this.classLookupThread.start();
        }
    }

    private void loadMemberList(ClassElement cls) {
        int i;
        int count;
        ArrayList<String> members = new ArrayList<String>(15);
        if (this.clinitElem) {
            InitializerElement[] initializers = cls.getInitializers();
            count = initializers.length;
            i = 0;
            while (i < count) {
                if (initializers[i].isStatic()) {
                    members.add(CLINIT_DESCRIPTION);
                    break;
                }
                ++i;
            }
        }
        if (this.initElem) {
            members.add(INIT_DESCRIPTION);
        }
        if (this.methodElem) {
            MethodElement[] methods = cls.getMethods();
            count = methods.length;
            i = 0;
            while (i < count) {
                members.add(methods[i].getName().getName());
                ++i;
            }
        }
        if (this.fieldElem) {
            FieldElement[] fields = cls.getFields();
            count = fields.length;
            i = 0;
            while (i < count) {
                members.add(fields[i].getName().getName());
                ++i;
            }
        }
        this.cboxMemberModel.setElements(members);
    }

    private void waitForClassLookupThread() {
        if (this.classLookupThread != null && this.classLookupThread.isAlive()) {
            this.classLookup.interrupt();
            try {
                this.classLookupThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void update(Observable o, Object arg) {
        int listSize = this.cboxClassModel.getSize();
        if (arg == null) {
            this.cboxClassModel.removeLastElement();
        } else {
            String clsName;
            boolean isNew;
            ClassElement clsElem = (ClassElement)arg;
            if (this.exceptionFilter) {
                int len;
                isNew = false;
                clsName = null;
                if (!clsElem.isInner() && (len = (clsName = clsElem.getName().getName()).length()) >= 5 && clsName.charAt(len - 2) == 'o' && (clsName.endsWith("Exception") || clsName.endsWith("Error"))) {
                    isNew = this.classElementMap.put(clsName, DUMMY_OBJECT) == null;
                }
            } else {
                clsName = JavaElementSelector.getShortClassName(clsElem);
                if (this.lookForMembers) {
                    JavaElementSelector javaElementSelector = this;
                    synchronized (javaElementSelector) {
                        boolean bl = isNew = this.classElementMap.put(clsName, clsElem) == null;
                        if (this.needMembersForClassName != null && clsName.equals(this.needMembersForClassName)) {
                            this.loadMemberList(clsElem);
                            this.needMembersForClassName = null;
                        }
                    }
                } else {
                    boolean bl = isNew = this.classElementMap.put(clsName, DUMMY_OBJECT) == null;
                }
            }
            if (isNew) {
                this.cboxClassModel.insertElementBeforeLast(clsName);
            }
        }
    }

    public void addChangeListener(ChangeListener l) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList(3);
        }
        this.changeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        if (this.changeListeners != null) {
            this.changeListeners.remove(l);
            if (this.changeListeners.size() == 0) {
                this.changeListeners = null;
            }
        }
    }

    protected void fireStateChanged(JComboBox cbox) {
        if (this.changeListeners != null) {
            ChangeEvent e = new ChangeEvent(cbox);
            Iterator i = this.changeListeners.iterator();
            while (i.hasNext()) {
                ((ChangeListener)i.next()).stateChanged(e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        DUMMY_OBJECT = new Object();
        boolean isMerlin = Dependency.JAVA_SPEC.compareTo((Object)new SpecificationVersion("1.4")) >= 0;
        STANDARD_JAVA_EXCEPTIONS = new ArrayList(isMerlin ? 47 : 46);
        STANDARD_JAVA_EXCEPTIONS.add("ArithmeticException");
        STANDARD_JAVA_EXCEPTIONS.add("ArrayIndexOutOfBoundsException");
        STANDARD_JAVA_EXCEPTIONS.add("ArrayStoreException");
        STANDARD_JAVA_EXCEPTIONS.add("ClassCastException");
        STANDARD_JAVA_EXCEPTIONS.add("ClassNotFoundException");
        STANDARD_JAVA_EXCEPTIONS.add("CloneNotSupportedException");
        STANDARD_JAVA_EXCEPTIONS.add("Exception");
        STANDARD_JAVA_EXCEPTIONS.add("IllegalAccessException");
        STANDARD_JAVA_EXCEPTIONS.add("IllegalArgumentException");
        STANDARD_JAVA_EXCEPTIONS.add("IllegalMonitorStateException");
        STANDARD_JAVA_EXCEPTIONS.add("IllegalStateException");
        STANDARD_JAVA_EXCEPTIONS.add("IllegalThreadStateException");
        STANDARD_JAVA_EXCEPTIONS.add("IndexOutOfBoundsException");
        STANDARD_JAVA_EXCEPTIONS.add("InstantiationException");
        STANDARD_JAVA_EXCEPTIONS.add("InterruptedException");
        STANDARD_JAVA_EXCEPTIONS.add("NegativeArraySizeException");
        STANDARD_JAVA_EXCEPTIONS.add("NoSuchFieldException");
        STANDARD_JAVA_EXCEPTIONS.add("NoSuchMethodException");
        STANDARD_JAVA_EXCEPTIONS.add("NullPointerException");
        STANDARD_JAVA_EXCEPTIONS.add("NumberFormatException");
        STANDARD_JAVA_EXCEPTIONS.add("RuntimeException");
        STANDARD_JAVA_EXCEPTIONS.add("SecurityException");
        STANDARD_JAVA_EXCEPTIONS.add("StringIndexOutOfBoundsException");
        STANDARD_JAVA_EXCEPTIONS.add("UnsupportedOperationException");
        STANDARD_JAVA_EXCEPTIONS.add("AbstractMethodError");
        if (isMerlin) {
            STANDARD_JAVA_EXCEPTIONS.add("AssertionError");
        }
        STANDARD_JAVA_EXCEPTIONS.add("ClassCircularityError");
        STANDARD_JAVA_EXCEPTIONS.add("ClassFormatError");
        STANDARD_JAVA_EXCEPTIONS.add("Error");
        STANDARD_JAVA_EXCEPTIONS.add("ExceptionInInitializerError");
        STANDARD_JAVA_EXCEPTIONS.add("IllegalAccessError");
        STANDARD_JAVA_EXCEPTIONS.add("IncompatibleClassChangeError");
        STANDARD_JAVA_EXCEPTIONS.add("InstantiationError");
        STANDARD_JAVA_EXCEPTIONS.add("InternalError");
        STANDARD_JAVA_EXCEPTIONS.add("LinkageError");
        STANDARD_JAVA_EXCEPTIONS.add("NoClassDefFoundError");
        STANDARD_JAVA_EXCEPTIONS.add("NoSuchFieldError");
        STANDARD_JAVA_EXCEPTIONS.add("NoSuchMethodError");
        STANDARD_JAVA_EXCEPTIONS.add("OutOfMemoryError");
        STANDARD_JAVA_EXCEPTIONS.add("StackOverflowError");
        STANDARD_JAVA_EXCEPTIONS.add("ThreadDeath");
        STANDARD_JAVA_EXCEPTIONS.add("UnknownError");
        STANDARD_JAVA_EXCEPTIONS.add("UnsatisfiedLinkError");
        STANDARD_JAVA_EXCEPTIONS.add("UnsupportedClassVersionError");
        STANDARD_JAVA_EXCEPTIONS.add("VerifyError");
        STANDARD_JAVA_EXCEPTIONS.add("VirtualMachineError");
        STANDARD_JAVA_EXCEPTIONS.add("Throwable");
    }

    private static final class ComboBoxItemRenderer
    implements ListCellRenderer {
        private static final ListCellRenderer DEFAULT = new JComboBox().getRenderer();

        private ComboBoxItemRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == SEPARATOR) {
                return SEPARATOR;
            }
            return DEFAULT.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
    }

    private final class ComboBoxFocusListener
    implements FocusListener {
        private JComboBox cbox;

        public ComboBoxFocusListener(JComboBox cbox) {
            this.cbox = cbox;
        }

        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                if (this.cbox == JavaElementSelector.this.cboxPackage) {
                    JavaElementSelector.this.cboxPackageFocusLost();
                } else if (this.cbox == JavaElementSelector.this.cboxClass) {
                    JavaElementSelector.this.cboxClassFocusLost();
                }
                JavaElementSelector.this.fireStateChanged(this.cbox);
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                this.cbox.getEditor().selectAll();
            }
        }
    }

    public static final class MyMutableComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    HistoryListener {
        protected static final int MIN_SIZE = 5;
        protected static final Object DUMMY = " ";
        protected Vector data = new Vector(20, 15);
        protected ArrayList historyData;
        protected boolean hasSeparator;
        protected Object selectedItem;
        protected AbstractHistory history;
        protected int dataSize;
        protected int historySize;
        protected int totalSize;
        protected int maxHistoryRows;

        public int getSize() {
            if (this.totalSize > 5) {
                return this.totalSize;
            }
            return 5;
        }

        public Object getElementAt(int index) {
            if (index < 0) {
                return null;
            }
            if (index < this.historySize) {
                return this.historyData.get(this.historySize - index - 1);
            }
            if (index < this.totalSize) {
                if (this.hasSeparator) {
                    if (index == this.historySize) {
                        return SEPARATOR;
                    }
                    return this.data.elementAt(index - this.historySize - 1);
                }
                return this.data.elementAt(index);
            }
            if (index < 5) {
                return DUMMY;
            }
            return null;
        }

        public void setSelectedItem(Object item) {
            if (item == DUMMY || item == SEARCHING || item == SEPARATOR) {
                return;
            }
            if (this.selectedItem == null && item != null || this.selectedItem != null && !this.selectedItem.equals(item)) {
                if (item != CLINIT_DESCRIPTION && item != INIT_DESCRIPTION) {
                    this.selectedItem = item;
                } else if (item == CLINIT_DESCRIPTION) {
                    this.selectedItem = "<clinit>";
                } else if (item == INIT_DESCRIPTION) {
                    this.selectedItem = "<init>";
                }
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public Object getSelectedItem() {
            return this.selectedItem;
        }

        public void insertElementBeforeLast(Object item) {
            int dataIndex = this.dataSize - 1;
            int totalIndex = this.totalSize - 1;
            int newDataSize = this.dataSize + 1;
            int newTotalSize = this.totalSize + 1;
            if (this.totalSize > 5) {
                this.data.insertElementAt(item, dataIndex);
                this.dataSize = newDataSize;
                this.totalSize = newTotalSize;
                this.fireIntervalAdded(this, totalIndex, totalIndex);
            } else {
                int lastIndex = totalIndex + 1;
                this.data.insertElementAt(item, dataIndex);
                this.dataSize = newDataSize;
                this.totalSize = newTotalSize;
                this.fireContentsChanged(this, totalIndex, lastIndex);
            }
        }

        public void removeLastElement() {
            if (this.dataSize == 1) {
                this.removeAllElements();
            } else {
                int newDataSize = this.dataSize - 1;
                int newTotalSize = this.totalSize - 1;
                boolean removed = this.dataSize > 5;
                this.data.removeElementAt(newDataSize);
                this.dataSize = newDataSize;
                this.totalSize = newTotalSize;
                if (removed) {
                    this.fireIntervalRemoved(this, newTotalSize, newTotalSize);
                } else {
                    this.fireContentsChanged(this, newTotalSize, newTotalSize);
                }
            }
        }

        public void setSingleElement(Object item) {
            if (this.dataSize == 0) {
                boolean added;
                boolean needSeparator;
                int lastIndex;
                int firstIndex;
                int newTotalSize;
                if (this.historySize == 0) {
                    newTotalSize = 1;
                    firstIndex = 0;
                    lastIndex = 0;
                    needSeparator = false;
                    added = false;
                } else {
                    newTotalSize = this.historySize + 2;
                    firstIndex = this.historySize;
                    lastIndex = firstIndex + 1;
                    needSeparator = true;
                    added = this.historySize >= 5;
                }
                this.data.add(item);
                this.dataSize = 1;
                this.totalSize = newTotalSize;
                this.hasSeparator = needSeparator;
                if (added) {
                    this.fireIntervalAdded(this, firstIndex, lastIndex);
                } else {
                    this.fireContentsChanged(this, firstIndex, lastIndex);
                }
            } else {
                int firstIndex = this.hasSeparator ? this.historySize + 1 : 0;
                int lastIndex = firstIndex + this.dataSize - 1;
                int newTotalSize = firstIndex + 1;
                this.data.clear();
                this.data.add(item);
                this.dataSize = 1;
                this.totalSize = newTotalSize;
                this.fireContentsChanged(this, firstIndex, lastIndex);
                this.data.trimToSize();
            }
        }

        public void removeAllElements() {
            if (this.dataSize != 0) {
                int lastIndex;
                int firstIndex;
                if (this.historySize == 0) {
                    firstIndex = 0;
                    lastIndex = this.dataSize - 1;
                } else {
                    firstIndex = this.historySize;
                    lastIndex = firstIndex + this.dataSize;
                }
                if (firstIndex < 5) {
                    this.data.removeAllElements();
                    this.dataSize = 0;
                    this.totalSize = this.historySize;
                    this.hasSeparator = false;
                    this.fireContentsChanged(this, firstIndex, lastIndex);
                } else {
                    this.data.removeAllElements();
                    this.dataSize = 0;
                    this.totalSize = this.historySize;
                    this.hasSeparator = false;
                    this.fireIntervalRemoved(this, firstIndex, lastIndex);
                }
            }
        }

        public void setElements(Collection items) {
            int newDataSize = items.size();
            if (newDataSize == 0) {
                this.removeAllElements();
                return;
            }
            if (this.dataSize == 0) {
                boolean added;
                boolean needSeparator;
                int lastIndex;
                int firstIndex;
                int newTotalSize;
                if (this.historySize == 0) {
                    newTotalSize = newDataSize;
                    firstIndex = 0;
                    lastIndex = newDataSize - 1;
                    needSeparator = false;
                    added = false;
                } else {
                    newTotalSize = this.historySize + newDataSize + 1;
                    firstIndex = this.historySize;
                    lastIndex = firstIndex + newDataSize;
                    needSeparator = true;
                    added = firstIndex >= 5;
                }
                this.data.clear();
                this.data.addAll(items);
                this.data.trimToSize();
                this.dataSize = newDataSize;
                this.totalSize = newTotalSize;
                this.hasSeparator = needSeparator;
                if (added) {
                    this.fireIntervalAdded(this, firstIndex, lastIndex);
                } else {
                    this.fireContentsChanged(this, firstIndex, lastIndex);
                }
            } else {
                int newTotalSize;
                int lastIndex;
                int firstIndex;
                int maxDataSize;
                int n = maxDataSize = newDataSize > this.dataSize ? newDataSize : this.dataSize;
                if (this.hasSeparator) {
                    firstIndex = this.historySize + 1;
                    lastIndex = firstIndex + maxDataSize;
                    newTotalSize = this.historySize + 1 + newDataSize;
                } else {
                    firstIndex = 0;
                    lastIndex = maxDataSize - 1;
                    newTotalSize = newDataSize;
                }
                this.data.clear();
                this.data.addAll(items);
                this.data.trimToSize();
                this.dataSize = newDataSize;
                this.totalSize = newTotalSize;
                this.fireContentsChanged(this, firstIndex, lastIndex);
            }
        }

        public void setHistory(AbstractHistory history) {
            this.historyData = history == null ? null : new ArrayList(history.getMaxSize());
            this.replaceHistoryData(0, history.getItems());
            this.history = history;
        }

        private void replaceHistoryData(int oldHistorySize, List newHistoryData) {
            int newHistorySize = newHistoryData.size();
            if (newHistorySize == oldHistorySize) {
                if (newHistorySize != 0) {
                    int lastIndex = this.historySize - 1;
                    this.historyData.clear();
                    this.historyData.addAll(newHistoryData);
                    this.fireContentsChanged(this, 0, lastIndex);
                }
            } else if (oldHistorySize == 0) {
                boolean added;
                boolean needSeparator;
                int newTotalSize;
                int lastIndex;
                if (this.dataSize == 0) {
                    lastIndex = newHistorySize - 1;
                    newTotalSize = newHistorySize;
                    needSeparator = false;
                    added = false;
                } else if (this.dataSize < 5) {
                    lastIndex = newHistorySize + this.dataSize;
                    newTotalSize = lastIndex + 1;
                    needSeparator = true;
                    added = false;
                } else {
                    lastIndex = newHistorySize;
                    newTotalSize = newHistorySize + 1 + this.dataSize;
                    needSeparator = true;
                    added = true;
                }
                this.historyData.addAll(newHistoryData);
                this.historySize = newHistorySize;
                this.hasSeparator = needSeparator;
                this.totalSize = newTotalSize;
                if (added) {
                    this.fireIntervalAdded(this, 0, lastIndex);
                } else {
                    this.fireContentsChanged(this, 0, lastIndex);
                }
            } else if (newHistorySize == 0) {
                boolean removed;
                int lastIndex;
                if (this.dataSize == 0) {
                    lastIndex = this.historySize - 1;
                    removed = false;
                } else if (this.dataSize < 5) {
                    lastIndex = this.historySize + this.dataSize;
                    removed = false;
                } else {
                    lastIndex = this.historySize;
                    removed = true;
                }
                this.hasSeparator = false;
                this.historyData.clear();
                this.historySize = 0;
                this.totalSize = this.dataSize;
                if (removed) {
                    this.fireIntervalRemoved(this, 0, lastIndex);
                } else {
                    this.fireContentsChanged(this, 0, lastIndex);
                }
            } else {
                int newTotalSize = this.totalSize + newHistorySize - oldHistorySize;
                int lastIndex = newTotalSize - 1;
                this.historyData.clear();
                this.historyData.addAll(newHistoryData);
                this.historySize = newHistorySize;
                this.totalSize = newTotalSize;
                this.fireContentsChanged(this, 0, lastIndex);
            }
        }

        public void historyListChanged(HistoryEvent e) {
            AbstractHistory history = (AbstractHistory)e.getSource();
            int eventType = e.getEventType();
            switch (eventType) {
                case 2: {
                    this.replaceHistoryData(this.historySize, history.getItems());
                    break;
                }
                case 0: {
                    int newTotalSize;
                    boolean needSeparator;
                    Object item = e.getAddedItem();
                    int newHistorySize = this.historySize + 1;
                    if (this.dataSize == 0) {
                        needSeparator = false;
                        newTotalSize = newHistorySize;
                    } else {
                        needSeparator = true;
                        newTotalSize = this.historySize + 2 + this.dataSize;
                    }
                    int firstIndex = this.historySize;
                    if (this.totalSize < 5) {
                        int lastIndex = newTotalSize - 1;
                        this.historyData.add(item);
                        this.historySize = newHistorySize;
                        this.totalSize = newTotalSize;
                        this.hasSeparator = needSeparator;
                        this.fireContentsChanged(this, 0, lastIndex);
                        break;
                    }
                    int lastIndex = needSeparator == this.hasSeparator ? 0 : 1;
                    this.historyData.add(item);
                    this.historySize = newHistorySize;
                    this.totalSize = newTotalSize;
                    this.hasSeparator = needSeparator;
                    this.fireIntervalAdded(this, 0, lastIndex);
                    break;
                }
                case 1: {
                    Object item = e.getAddedItem();
                    int lastIndex = this.historySize - 1;
                    this.historyData.remove(0);
                    this.historyData.add(item);
                    this.fireContentsChanged(this, 0, lastIndex);
                    break;
                }
            }
        }
    }
}

