/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.java;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.support.DebuggerAnnotation;
import org.netbeans.modules.debugger.support.LineBreakpointEvent;
import org.netbeans.modules.debugger.support.java.BreakpointUpdater;
import org.netbeans.modules.debugger.support.java.JUtils;
import org.netbeans.modules.debugger.support.java.JavaDebugger;
import org.netbeans.modules.debugger.support.java.JavaLineBreakpointPanel;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SourceCookie;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.nodes.Node;
import org.openide.text.Line;
import org.openide.text.NbDocument;

public abstract class JavaLineBreakpointEvent
extends LineBreakpointEvent
implements CoreBreakpoint.AnnotatableEvent,
CoreBreakpoint.SessionEvent {
    static final long serialVersionUID = 5611559342537392476L;
    public static final String PROP_SOURCE_NAME = "sourceName";
    public static final String PROP_LINE_NUMBER = "lineNumber";
    public static final String TYPE_NAME = "java-line";
    protected transient LineBreakpointUpdater updater;
    protected transient DebuggerAnnotation annotation;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$openide$cookies$SourceCookie$Editor;
    static /* synthetic */ Class class$org$openide$cookies$EditorCookie;

    public JavaLineBreakpointEvent() {
        this.init();
    }

    protected void init() {
        this.annotation = new DebuggerAnnotation.Breakpoint(this);
        this.updater = new LineBreakpointUpdater(this, this.getSourceName());
        JavaLineBreakpointEvent javaLineBreakpointEvent = this;
        synchronized (javaLineBreakpointEvent) {
            if (this.sourceName != null && this.sourceName.length() != 0 && this.lineNumber > 0) {
                this.line = JUtils.getLine(this.sourceName, this.lineNumber);
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
    }

    public Node.Property[] getProperties() {
        return new Node.Property[]{Utils.createProperty(this, class$java$lang$String == null ? (class$java$lang$String = JavaLineBreakpointEvent.class$("java.lang.String")) : class$java$lang$String, PROP_SOURCE_NAME, JavaDebugger.getString("PROP_breakpoint_source_name"), JavaDebugger.getString("HINT_breakpoint_source_name"), "getSourceName", "setSourceName"), Utils.createProperty(this, Integer.TYPE, PROP_LINE_NUMBER, JavaDebugger.getString("PROP_breakpoint_line_number"), JavaDebugger.getString("HINT_breakpoint_line_number"), "getLineNumber", "setLineNumber")};
    }

    public void dispose() {
        if (this.updater != null) {
            this.updater.dispose();
        }
        this.annotation.detachLine();
    }

    public boolean supportsMIMEType(String MIMEType) {
        return true;
    }

    public String getTypeName() {
        return TYPE_NAME;
    }

    public String getTypeDisplayName() {
        return JavaDebugger.getString("CTL_Line_event_type_name");
    }

    public String getCategoryDisplayName() {
        return JavaDebugger.getString("CTL_Java_breakpoint_events_cathegory_name");
    }

    public boolean isDefault() {
        return JUtils.getDefaultType() == TYPE_NAME;
    }

    public String getDisplayName() {
        if (this.line != null) {
            return new MessageFormat(JavaDebugger.getString("CTL_Line_event_name_Line")).format(new Object[]{this.line.getDisplayName()});
        }
        return new MessageFormat(JavaDebugger.getString("CTL_Line_event_name")).format(new Object[]{this.getSourceName(), new Integer(this.getLineNumber())});
    }

    public Line[] getLines() {
        if (this.line == null) {
            return null;
        }
        return new Line[]{this.line};
    }

    public JComponent getCustomizer() {
        this.setSourceName(JUtils.getCurrentClassName());
        this.setLineNumber(Utils.getCurrentLineNumber());
        return new JavaLineBreakpointPanel(this);
    }

    public void synchronizeWith(CoreBreakpoint.Event e) {
    }

    public void setSourceName(String cn) {
        if (cn != null) {
            cn = cn.trim();
        }
        if (cn == this.sourceName || cn != null && this.sourceName != null && this.sourceName.equals(cn)) {
            return;
        }
        String old = this.sourceName;
        this.sourceName = cn;
        int ln = this.getLineNumber();
        this.line = null;
        if (this.sourceName != null && this.sourceName.length() > 0 && ln > 0) {
            this.line = JUtils.getLine(this.sourceName, ln);
            this.lineNumber = this.line != null ? -1 : ln;
        }
        this.updater.setClassName(this.sourceName);
        this.firePropertyChange(PROP_SOURCE_NAME, old, this.sourceName);
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public void setsourceName(String cn) {
        if (cn == this.sourceName || cn != null && this.sourceName != null && this.sourceName.equals(cn)) {
            return;
        }
        String old = this.sourceName;
        this.sourceName = cn;
        this.firePropertyChange(PROP_SOURCE_NAME, old, this.sourceName);
    }

    public int getLineNumber() {
        if (this.line != null) {
            this.lineNumber = this.line.getLineNumber() + 1;
        }
        return this.lineNumber;
    }

    public void setLineNumber(int ln) {
        if (ln == this.lineNumber) {
            return;
        }
        int old = this.lineNumber;
        if (ln > 0) {
            this.line = JUtils.getLine(this.sourceName, ln);
            this.lineNumber = ln;
        } else {
            this.line = null;
            this.lineNumber = 0;
        }
        this.updater.setClassName(this.sourceName);
        this.firePropertyChange(PROP_LINE_NUMBER, new Integer(old), new Integer(this.getLineNumber()));
    }

    public Line getLine() {
        return this.line;
    }

    public final void setLine(Line l) {
        this.setLine(l, true);
    }

    void setLine(Line l, boolean notifyUpdater) {
        if (this.line == l) {
            return;
        }
        Line old = this.line;
        this.line = l;
        if (this.line != null) {
            this.lineNumber = this.line.getLineNumber() + 1;
            SourceCookie.Editor sourceCookie = (SourceCookie.Editor)this.line.getDataObject().getCookie(class$org$openide$cookies$SourceCookie$Editor == null ? (class$org$openide$cookies$SourceCookie$Editor = JavaLineBreakpointEvent.class$("org.openide.cookies.SourceCookie$Editor")) : class$org$openide$cookies$SourceCookie$Editor);
            EditorCookie editorCookie = (EditorCookie)this.line.getDataObject().getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = JavaLineBreakpointEvent.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
            this.sourceName = null;
            if (sourceCookie != null && editorCookie != null) {
                try {
                    int offset = NbDocument.findLineOffset((StyledDocument)editorCookie.openDocument(), (int)(this.lineNumber - 1));
                    this.sourceName = JUtils.getClassNameForElement(sourceCookie.findElement(offset));
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (this.sourceName == null || this.sourceName.length() < 1) {
                this.sourceName = this.line.getDataObject().getPrimaryFile().getPackageName('.');
            }
        }
        if (notifyUpdater) {
            this.updater.setClassName(this.sourceName);
        }
        this.firePropertyChange(PROP_LINE_NUMBER, old, this.line);
    }

    final synchronized Line updateLine() {
        Line old = this.line;
        this.line = this.sourceName != null && this.sourceName.length() != 0 && this.lineNumber > 0 ? JUtils.getLine(this.sourceName, this.lineNumber) : null;
        if (this.line != old) {
            this.annotate();
            if (this.line != null) {
                this.lineNumber = this.line.getLineNumber() + 1;
            } else if (old != null) {
                this.lineNumber = old.getLineNumber() + 1;
            }
            this.firePropertyChange(PROP_LINE_NUMBER, old, this.line);
        }
        return this.line;
    }

    protected void sourceRenamed(String sourceName) {
        if (sourceName.equals(this.sourceName)) {
            return;
        }
        String old = this.sourceName;
        this.sourceName = sourceName;
        this.firePropertyChange(PROP_SOURCE_NAME, old, sourceName);
    }

    protected void sourceModified() {
        Line l = this.line;
        if (l != null) {
            this.lineNumber = l.getLineNumber() + 1;
        }
        this.firePropertyChange(PROP_LINE_NUMBER, null, null);
    }

    public String toString() {
        String n = this.getClass().getName();
        int i = n.lastIndexOf(46);
        if (i > 0) {
            n = n.substring(i + 1);
        }
        return n + this.hashCode() + "[src " + this.getSourceName() + " :ln " + this.getLineNumber() + " :line " + this.getLine() + "]";
    }

    protected String getAnnotationType() {
        return this.getBreakpoint().isEnabled() ? DebuggerAnnotation.Breakpoint.TYPE_NORMAL : DebuggerAnnotation.Breakpoint.TYPE_DISABLED;
    }

    public synchronized void annotate() {
        boolean hidden = this.getBreakpoint().isHidden();
        if (hidden || this.line == null) {
            if (this.annotation != null) {
                this.annotation.detachLine();
            }
        } else {
            if (this.annotation == null) {
                this.annotation = new DebuggerAnnotation.Breakpoint(this);
            }
            this.annotation.attachLine(this.line, this.getAnnotationType());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class LineBreakpointUpdater
    extends BreakpointUpdater {
        protected void init() {
            BreakpointUpdater.repListener.register(this);
            ((JavaLineBreakpointEvent)this.breakpoint).updateLine();
        }

        public LineBreakpointUpdater(JavaLineBreakpointEvent breakpoint, String className) {
            super(breakpoint, null, className);
        }

        private FileObject getFileObjectOfLine(Line line) {
            int fLen;
            int cLen;
            if (line == null) {
                return null;
            }
            FileObject fileObject = line.getDataObject().getPrimaryFile();
            String fileName = fileObject.getPackageName('.');
            if (this.className.indexOf(36) == -1 ? !fileName.equals(this.className) : (cLen = this.className.length()) < (fLen = fileName.length()) + 2 || this.className.charAt(fLen) != '$' || !this.className.startsWith(fileName)) {
                return null;
            }
            return fileObject;
        }

        protected synchronized void refreshFileObjectListener() {
            FileObject old = this.fileObject;
            Line line = ((JavaLineBreakpointEvent)this.breakpoint).getLine();
            this.fileObject = this.getFileObjectOfLine(line);
            this.refreshFileObjectListener(old, this.fileObject);
        }

        protected void updateBreakpoint() {
            ((JavaLineBreakpointEvent)this.breakpoint).sourceRenamed(this.className);
        }

        public void fileChanged(FileEvent e) {
            super.fileChanged(e);
            ((JavaLineBreakpointEvent)this.breakpoint).sourceModified();
        }

        public void fileDeleted(FileEvent e) {
            ((JavaLineBreakpointEvent)this.breakpoint).updateLine();
            super.fileDeleted(e);
        }

        protected void fileSystemsAdded(List fileSystems) {
            Line line;
            if (this.fileObject == null && (line = ((JavaLineBreakpointEvent)this.breakpoint).updateLine()) != null) {
                this.fileObject = line.getDataObject().getPrimaryFile();
                this.refreshFileObjectListener(null, this.fileObject);
                this.listenOnClass = this.onNestedClass;
                if (this.listenOnClass) {
                    this.refreshClsElementListener();
                }
            }
        }

        protected void fileSystemsRemoved(List fileSystems) {
            if (this.fileObject != null) {
                boolean removed = false;
                try {
                    Iterator i = fileSystems.iterator();
                    while (i.hasNext()) {
                        if ((FileSystem)i.next() != this.fileObject.getFileSystem()) continue;
                        removed = true;
                        break;
                    }
                }
                catch (FileStateInvalidException ex) {
                    removed = true;
                }
                if (removed) {
                    ((JavaLineBreakpointEvent)this.breakpoint).updateLine();
                    this.fileObject = null;
                    this.refreshFileObjectListener(this.fileObject, null);
                    if (this.listenOnClass) {
                        this.refreshClsElementListener(this.getClsElement(), this.setClsElement(null));
                        this.listenOnClass = false;
                    }
                }
            }
        }

        protected void fileSystemsChanged(List addedFS, List removedFS) {
            Line oldLine = ((JavaLineBreakpointEvent)this.breakpoint).getLine();
            Line line = ((JavaLineBreakpointEvent)this.breakpoint).updateLine();
            if (line == oldLine) {
                return;
            }
            FileObject oldFileObject = this.fileObject;
            this.fileObject = this.getFileObjectOfLine(line);
            if (this.fileObject == oldFileObject) {
                return;
            }
            this.refreshFileObjectListener(null, this.fileObject);
            boolean bl = this.listenOnClass = this.fileObject != null && this.onNestedClass;
            if (this.listenOnClass) {
                this.refreshClsElementListener();
            }
        }
    }
}

