/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.java;

import org.netbeans.modules.debugger.AbstractVariable;
import org.netbeans.modules.debugger.CallStackFilter;
import org.netbeans.modules.debugger.VariablesFilter;
import org.netbeans.modules.debugger.support.java.CompactCallStackFilter;
import org.netbeans.modules.debugger.support.java.DNFilter;
import org.netbeans.modules.debugger.support.java.HashSetFilter;
import org.netbeans.modules.debugger.support.java.HashtableFilter;
import org.netbeans.modules.debugger.support.java.IntFilter;
import org.netbeans.modules.debugger.support.java.JavaDebugger;
import org.netbeans.modules.debugger.support.java.JavaVariable;
import org.netbeans.modules.debugger.support.java.JavaVariablesFilter;
import org.netbeans.modules.debugger.support.java.LinkedListFilter;
import org.netbeans.modules.debugger.support.java.ListFilter;
import org.netbeans.modules.debugger.support.java.ModifiersFilter;
import org.openide.options.ContextSystemOption;
import org.openide.util.HelpCtx;

public class JavaProjectSettings
extends ContextSystemOption {
    static final long serialVersionUID = 811103321325025600L;
    public static final String PROP_VARIABLES_FILTER = "variablesFilter";
    public static final String PROP_CALL_STACK_FILTER = "callStackFilter";
    public static final String PROP_VARIABLES_NAME_RESOLVER = "variablesNameResolver";
    private static VariablesFilter vf;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$java$JavaProjectSettings;

    public String displayName() {
        return JavaDebugger.getString("CTL_JavaProjectSettings");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$modules$debugger$support$java$JavaProjectSettings == null ? (class$org$netbeans$modules$debugger$support$java$JavaProjectSettings = JavaProjectSettings.class$("org.netbeans.modules.debugger.support.java.JavaProjectSettings")) : class$org$netbeans$modules$debugger$support$java$JavaProjectSettings);
    }

    public boolean isGlobal() {
        return false;
    }

    public VariablesFilter getVariablesFilter() {
        if (vf == null) {
            vf = JavaProjectSettings.createDefaultFilter();
        }
        return vf;
    }

    public void setVariablesFilter(VariablesFilter filter) {
    }

    public CallStackFilter getCallStackFilter() {
        CallStackFilter csf = (CallStackFilter)this.getProperty(PROP_CALL_STACK_FILTER);
        if (csf == null) {
            csf = JavaProjectSettings.createDefaultCSFilter();
        }
        this.putProperty(PROP_CALL_STACK_FILTER, csf, false);
        return csf;
    }

    public void setCallStackFilter(CallStackFilter filter) {
        this.putProperty(PROP_CALL_STACK_FILTER, filter, true);
    }

    private static CallStackFilter createDefaultCSFilter() {
        return new CompactCallStackFilter();
    }

    private static VariablesFilter createDefaultFilter() {
        ModifiersFilter mf = new ModifiersFilter("{value}");
        JavaVariablesFilter jvf = new JavaVariablesFilter(mf);
        jvf.registerTag("name", new JavaVariablesFilter.Tag(){
            static final long serialVersionUID = 6196237682769007810L;

            public String resolve(AbstractVariable av) {
                if (av == null) {
                    return "?";
                }
                return av.getVariableName();
            }
        });
        jvf.registerTag("value", new JavaVariablesFilter.Tag(){
            static final long serialVersionUID = -6543236533654358077L;

            public String resolve(AbstractVariable av) {
                if (av == null) {
                    return "null";
                }
                return av.getAsText();
            }
        });
        jvf.registerTag("type", new JavaVariablesFilter.Tag(){
            static final long serialVersionUID = 8599811372521647355L;

            public String resolve(AbstractVariable av) {
                if (av == null) {
                    return "";
                }
                return ((JavaVariable)av).getInnerType();
            }
        });
        jvf.registerTag("stype", new JavaVariablesFilter.Tag(){
            static final long serialVersionUID = -2283968919278295226L;

            public String resolve(AbstractVariable av) {
                if (av == null) {
                    return "";
                }
                String s = ((JavaVariable)av).getInnerType();
                if (s == null) {
                    return "";
                }
                int i = s.lastIndexOf(46);
                if (i < 0) {
                    return s;
                }
                return s.substring(i + 1);
            }
        });
        jvf.registerTag("fieldType", new JavaVariablesFilter.Tag(){
            static final long serialVersionUID = 8711487137836659574L;

            public String resolve(AbstractVariable av) {
                if (av == null) {
                    return "";
                }
                return av.getType();
            }
        });
        jvf.registerTag("sFieldType", new JavaVariablesFilter.Tag(){
            static final long serialVersionUID = 1121035879829872469L;

            public String resolve(AbstractVariable av) {
                if (av == null) {
                    return "";
                }
                String s = av.getType();
                if (s == null) {
                    return "";
                }
                int i = s.lastIndexOf(46);
                if (i < 0) {
                    return s;
                }
                return s.substring(i + 1);
            }
        });
        jvf.registerTag("toString", new JavaVariablesFilter.Tag(){
            static final long serialVersionUID = 7036768814835670393L;

            public String resolve(AbstractVariable av) {
                if (av == null) {
                    return "null";
                }
                return ((JavaVariable)av).toStringValue();
            }
        });
        jvf.registerTag("arrayLength", new JavaVariablesFilter.Tag(){
            static final long serialVersionUID = -1064948502033927341L;

            public String resolve(AbstractVariable av) {
                return "Length=" + ((JavaVariable)av).getSize();
            }
        });
        jvf.register("int", new IntFilter("{value}"));
        jvf.register("long", new IntFilter("{value}"));
        jvf.register("short", new IntFilter("{value}"));
        jvf.register("byte", new IntFilter("{value}"));
        jvf.register("java.lang.String", new DNFilter("{value}"));
        jvf.register("java.lang.StringBuffer", new DNFilter("{toString}"));
        jvf.register("java.lang.Integer", new DNFilter("{toString}"));
        jvf.register("java.lang.Char", new DNFilter("{toString}"));
        jvf.register("java.lang.Boolean", new DNFilter("{toString}"));
        jvf.register("java.lang.Double", new DNFilter("{toString}"));
        jvf.register("java.lang.Short", new DNFilter("{toString}"));
        jvf.register("java.lang.Float", new DNFilter("{toString}"));
        jvf.register("java.lang.Byte", new DNFilter("{toString}"));
        jvf.register("java.lang.Long", new DNFilter("{toString}"));
        jvf.register("java.lang.Class", new DNFilter("{value}"));
        jvf.register("java.util.HashMap$Entry", new DNFilter("({key.stype}) {key.value} => ({value.stype}) {value.value}"));
        jvf.register("java.util.Hashtable$Entry", new DNFilter("({key.stype}) {key.value} => ({value.stype}) {value.value}"));
        jvf.register("java.util.Vector", new ListFilter("{value}", new String[]{"elementData"}, true, false, true));
        jvf.register("java.util.Stack", new ListFilter("{value}", new String[]{"elementData"}, true, false, false));
        jvf.register("java.util.ArrayList", new ListFilter("{value}", new String[]{"elementData"}, true, false, true));
        jvf.register("java.beans.PropertyChangeSupport", new ListFilter("{value}", new String[]{"listeners", "elementData"}, true, true, false));
        jvf.register("java.util.HashMap", new HashtableFilter("{value}"));
        jvf.register("java.util.Hashtable", new HashtableFilter("{value}"));
        jvf.register("java.util.HashSet", new HashSetFilter("{value}"));
        jvf.register("java.util.LinkedList", new LinkedListFilter("{value}"));
        return jvf;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

