/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.java;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.SwingUtilities;
import org.netbeans.modules.debugger.AbstractThread;
import org.netbeans.modules.debugger.AbstractVariable;
import org.netbeans.modules.debugger.CallStackFilter;
import org.netbeans.modules.debugger.CallStackProducer;
import org.netbeans.modules.debugger.Location;
import org.netbeans.modules.debugger.VariablesFilter;
import org.netbeans.modules.debugger.VariablesProducer;
import org.netbeans.modules.debugger.support.java.CallStackFrame;
import org.netbeans.modules.debugger.support.java.JUtils;
import org.netbeans.modules.debugger.support.java.JavaDebugger;
import org.netbeans.modules.debugger.support.java.JavaThreadGroup;
import org.netbeans.modules.debugger.support.java.JavaVariable;
import org.netbeans.modules.debugger.support.java.ModifiersFilter;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.debugger.DebuggerException;
import org.openide.text.Line;

public abstract class JavaThread
extends AbstractThread
implements Location,
VariablesProducer,
CallStackProducer,
ModifiersFilter.Filterable {
    public static final String PROP_ADITIONAL_THREAD_INFO = "aditionalThreadInfo";
    public static final String PROP_CALL_STACK = "callStack";
    protected JavaDebugger debugger;
    private boolean current = false;
    private PropertyChangeSupport pcs;
    private JavaThreadGroup parentThreadGroup;
    protected VariablesFilter filter;
    protected CallStackFilter csFilter;
    private int currentCallStackFrameIndex = 0;

    protected JavaThread(JavaDebugger debugger, JavaThreadGroup parentThreadGroup) {
        this.parentThreadGroup = parentThreadGroup;
        this.debugger = debugger;
        this.pcs = new PropertyChangeSupport(this);
    }

    public final JavaDebugger getDebugger() {
        return this.debugger;
    }

    public boolean isCurrent() {
        return this.current;
    }

    public void setCurrent(boolean current) {
        if (current == this.isCurrent()) {
            return;
        }
        AbstractThread tt = this.debugger.getCurrentThread();
        if (!current) {
            if (tt != null && tt.equals(this)) {
                this.debugger.setCurrentThread(null);
            }
            this.makeNotCurrent();
            return;
        }
        if (tt != null && tt != this) {
            tt.setCurrent(false);
        }
        this.debugger.setCurrentThread(this);
        this.makeCurrent();
    }

    public void makeCurrent() {
        if (this.current) {
            return;
        }
        this.current = true;
        if (this.getParentThreadGroup() != null) {
            this.getParentThreadGroup().setCurrent(true);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JavaThread.this.pcs.firePropertyChange("current", null, null);
            }
        });
    }

    public void makeNotCurrent() {
        if (!this.current) {
            return;
        }
        this.current = false;
        if (this.getParentThreadGroup() != null) {
            this.getParentThreadGroup().setCurrent(false);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JavaThread.this.pcs.firePropertyChange("current", null, null);
            }
        });
    }

    protected void updateAnnotationsAndDisplayLocation() {
        this.debugger.setCurrentLine(null);
        this.debugger.annotateCallStack();
        int ln = this.getLineNumber();
        if (ln >= 0) {
            Line l = this.getLine();
            if (l != null) {
                this.debugger.setCurrentLine(l);
            }
        } else {
            Location[] stack = this.getCallStack();
            int k = stack.length;
            int i = 1;
            while (i < k) {
                if (Utils.showInEditor(stack[i].getLine()) != null) break;
                ++i;
            }
        }
    }

    public int getCurrentCallStackFrameIndex() {
        return this.currentCallStackFrameIndex;
    }

    public void setCurrentCallStackFrameIndex(int index) {
        if (index != this.currentCallStackFrameIndex) {
            int old = this.currentCallStackFrameIndex;
            this.currentCallStackFrameIndex = index;
            this.debugger.getValidator().validate();
            this.firePropertyChange("currentCallstackFrameIndex", new Integer(old), new Integer(this.currentCallStackFrameIndex));
        }
    }

    public Line getLine() {
        String sn = this.getSourceName();
        if (sn != null) {
            return JUtils.getLineForSource(this.getClassName(), this.getSourceName(), this.getLineNumber());
        }
        return JUtils.getLine(this.getClassName(), this.getLineNumber());
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    public abstract boolean isSuspended();

    public void setSuspended(boolean suspend) throws DebuggerException {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JavaThread.this.firePropertyChange(JavaThread.PROP_CALL_STACK, null, null);
            }
        });
    }

    public abstract void refreshStack();

    public JavaThreadGroup getParentThreadGroup() {
        return this.parentThreadGroup;
    }

    public abstract int getLineNumber();

    public abstract String getState();

    public abstract String getClassName();

    public abstract String getMethod();

    public abstract int getStackDepth();

    public abstract void stop() throws DebuggerException;

    public abstract String getSourceName();

    protected void firePropertyChange(String s, Object o, Object n) {
        this.pcs.firePropertyChange(s, o, n);
    }

    public boolean isLeaf() {
        return false;
    }

    public VariablesFilter getVariablesFilter() {
        if (this.filter != null) {
            return this.filter;
        }
        return this.debugger.getVariablesFilter();
    }

    public void setVariablesFilter(VariablesFilter filter) {
        if (filter == this.filter) {
            return;
        }
        if (filter != null && filter.equals(this.filter)) {
            return;
        }
        VariablesFilter old = this.filter;
        this.filter = filter;
        this.pcs.firePropertyChange("variablesFilter", old, filter);
    }

    public CallStackFilter getCallStackFilter() {
        if (this.csFilter != null) {
            return this.csFilter;
        }
        return this.debugger.getCallStackFilter();
    }

    public void setCallStackFilter(CallStackFilter csFilter) {
        if (csFilter == this.csFilter) {
            return;
        }
        if (csFilter != null && csFilter.equals(this.csFilter)) {
            return;
        }
        CallStackFilter old = this.csFilter;
        this.csFilter = csFilter;
        this.pcs.firePropertyChange("callStackFilter", old, csFilter);
    }

    public String getLocationName() {
        CallStackFrame[] ls = (CallStackFrame[])this.getCallStack();
        if (ls.length < 1) {
            return "";
        }
        return ls[0].getClassName() + '.' + ls[0].getMethodName() + " : " + ls[0].getLineNumber();
    }

    public String toString() {
        try {
            return "The Thread: " + this.getName() + " (" + super.toString() + ")";
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    public abstract AbstractVariable[] getVariables();

    public abstract String getInfo();

    public abstract Location[] getCallStack();

    public abstract JavaVariable[] filterVariables(ModifiersFilter var1, int var2, int var3);
}

