/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.java;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Vector;
import org.netbeans.modules.debugger.AbstractThread;
import org.netbeans.modules.debugger.ThreadListener;
import org.netbeans.modules.debugger.ThreadsProducer;
import org.netbeans.modules.debugger.support.ThreadPAdapter;
import org.netbeans.modules.debugger.support.java.JavaThread;
import org.openide.debugger.DebuggerException;

public abstract class JavaThreadGroup
extends AbstractThread
implements ThreadsProducer {
    public static final String PROP_CURRENT = "current";
    private boolean current = false;
    private Vector threadGroups = new Vector();
    private Vector threads = new Vector();
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private JavaThreadGroup parentThreadGroup;
    private ThreadPAdapter threadProducer = new ThreadPAdapter();

    protected JavaThreadGroup(JavaThreadGroup parentThreadGroup) {
        this.parentThreadGroup = parentThreadGroup;
    }

    public boolean isCurrent() {
        return this.current;
    }

    public void setCurrent(boolean current) {
        if (this.current == current) {
            return;
        }
        this.current = current;
        this.firePropertyChange(PROP_CURRENT, !current ? Boolean.TRUE : Boolean.FALSE, current ? Boolean.TRUE : Boolean.FALSE);
        JavaThreadGroup ttg = this.getParentThreadGroup();
        if (ttg == null) {
            return;
        }
        ttg.setCurrent(current);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    public JavaThread[] getJavaThreads() {
        return this.threads.toArray(new JavaThread[this.threads.size()]);
    }

    public JavaThreadGroup[] getThreadGroups() {
        return this.threadGroups.toArray(new JavaThreadGroup[this.threadGroups.size()]);
    }

    public JavaThreadGroup getParentThreadGroup() {
        return this.parentThreadGroup;
    }

    public void setSuspended(boolean suspended) {
        JavaThread[] threads = this.getJavaThreads();
        int k = threads.length;
        int i = 0;
        while (i < k) {
            try {
                threads[i].setSuspended(suspended);
            }
            catch (DebuggerException e) {
                // empty catch block
            }
            ++i;
        }
        JavaThreadGroup[] groups = this.getThreadGroups();
        k = groups.length;
        i = 0;
        while (i < k) {
            groups[i].setSuspended(suspended);
            ++i;
        }
    }

    public void refreshStacks() {
        JavaThread[] t = this.getJavaThreads();
        int x = 0;
        while (x < t.length) {
            t[x].refreshStack();
            ++x;
        }
        JavaThreadGroup[] tg = this.getThreadGroups();
        int x2 = 0;
        while (x2 < tg.length) {
            tg[x2].refreshStacks();
            ++x2;
        }
    }

    protected void addThreadGroup(JavaThreadGroup threadGroup) {
        this.threadGroups.add(threadGroup);
        this.threadProducer.addThread(threadGroup);
    }

    protected void removeThreadGroup(JavaThreadGroup threadGroup) {
        this.threadGroups.remove(threadGroup);
        this.threadProducer.removeThread(threadGroup);
    }

    protected void addThread(JavaThread thread) {
        this.threads.add(thread);
        this.threadProducer.addThread(thread);
    }

    protected void removeThread(JavaThread thread) {
        this.threads.remove(thread);
        this.threadProducer.removeThread(thread);
    }

    protected void removeAll() {
        int i = this.threadGroups.size() - 1;
        while (i >= 0) {
            this.removeThreadGroup((JavaThreadGroup)this.threadGroups.get(i));
            --i;
        }
        i = this.threads.size() - 1;
        while (i >= 0) {
            this.removeThread((JavaThread)this.threads.get(i));
            --i;
        }
    }

    protected void firePropertyChange(String name, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(name, oldValue, newValue);
    }

    public AbstractThread[] getThreads() {
        return this.threadProducer.getThreads();
    }

    public void addThreadListener(ThreadListener l) {
        this.threadProducer.addThreadListener(l);
    }

    public void removeThreadListener(ThreadListener l) {
        this.threadProducer.removeThreadListener(l);
    }
}

