/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.java;

import java.io.Serializable;
import java.util.HashMap;
import org.netbeans.modules.debugger.AbstractVariable;
import org.netbeans.modules.debugger.VariablesFilter;
import org.netbeans.modules.debugger.VariablesProducer;
import org.netbeans.modules.debugger.support.DelegatingFilter;
import org.netbeans.modules.debugger.support.java.ArrayFilter;
import org.netbeans.modules.debugger.support.java.DNFilter;
import org.netbeans.modules.debugger.support.java.JavaVariable;
import org.openide.nodes.Node;

public class JavaVariablesFilter
extends DelegatingFilter {
    static final long serialVersionUID = -1262100084467089119L;
    private HashMap register = new HashMap();
    private ArrayFilter arrayFilter = new ArrayFilter("{value} ({arrayLength})");

    public JavaVariablesFilter(VariablesFilter innerFilter) {
        super(innerFilter);
    }

    public String getDisplayName(AbstractVariable v) {
        VariablesFilter vf = this.getFilter(v.getType());
        if (vf == null) {
            return null;
        }
        return this.resolve((JavaVariable)v, vf.getDisplayName(v));
    }

    public VariablesFilter getFilter(String type) {
        if (type == null) {
            return super.getFilter(type);
        }
        if (type.endsWith("[]")) {
            return this.arrayFilter;
        }
        return super.getFilter(type);
    }

    public AbstractVariable[] getVariables(VariablesProducer v) {
        if (!(v instanceof AbstractVariable)) {
            return this.innerFilter.getVariables(v);
        }
        VariablesFilter vf = this.getFilter(((JavaVariable)v).getInnerType());
        if (vf == null) {
            return v.getVariables();
        }
        return vf.getVariables(v);
    }

    public Node.Property[] getProperties(AbstractVariable v) {
        String type = ((JavaVariable)v).getInnerType();
        if (type == null) {
            return new Node.Property[0];
        }
        VariablesFilter vf = this.getFilter(type);
        if (vf == null) {
            return new Node.Property[0];
        }
        return vf.getProperties(v);
    }

    public boolean elementsSorted(AbstractVariable v) {
        VariablesFilter vf = this.getFilter(((JavaVariable)v).getInnerType());
        if (!(vf instanceof DNFilter)) {
            return false;
        }
        return ((DNFilter)vf).elementsSorted();
    }

    public void registerTag(String tagName, Tag tag) {
        this.register.put(tagName, tag);
    }

    public String resolve(JavaVariable v, String pat) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int n = pat.length();
        while (i < n) {
            Tag t;
            int j = pat.indexOf(123, i);
            if (j < 0) {
                sb.append(pat.substring(i));
                break;
            }
            if (j > i) {
                sb.append(pat.substring(i, j));
            }
            if ((j = pat.indexOf(125, i = j + 1)) < 0) {
                sb.append(pat.substring(i));
                break;
            }
            String tag = pat.substring(i, j);
            i = j + 1;
            int ii = 0;
            int jj = tag.indexOf(46);
            JavaVariable vv = v;
            while (jj > ii) {
                if (vv != null) {
                    vv = (JavaVariable)vv.getVariable(tag.substring(ii, jj));
                }
                ii = jj + 1;
                jj = tag.indexOf(46, ii);
            }
            if (ii > 0) {
                tag = tag.substring(ii);
            }
            ii = tag.indexOf(58);
            String displayFormat = null;
            if (ii >= 0) {
                displayFormat = tag.substring(ii + 1);
                tag = tag.substring(0, ii);
            }
            if ((t = (Tag)this.register.get(tag)) == null) {
                sb.append(tag);
                continue;
            }
            String val = t.resolve(vv);
            if (displayFormat != null) {
                if (displayFormat.equals("HEX")) {
                    val = "0x" + Integer.toHexString(Integer.parseInt(val));
                } else if (displayFormat.equals("BIN")) {
                    val = Integer.toBinaryString(Integer.parseInt(val)) + "B";
                } else if (displayFormat.equals("OCT")) {
                    val = "0" + Integer.toOctalString(Integer.parseInt(val));
                }
            }
            sb.append(val);
        }
        return new String(sb);
    }

    public static interface Tag
    extends Serializable {
        public String resolve(AbstractVariable var1);
    }
}

