/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.java;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.SwingUtilities;
import org.netbeans.modules.debugger.AbstractVariable;
import org.netbeans.modules.debugger.AbstractWatch;
import org.netbeans.modules.debugger.Validator;
import org.netbeans.modules.debugger.VariablesFilter;
import org.netbeans.modules.debugger.support.java.JavaDebugger;
import org.netbeans.modules.debugger.support.java.JavaThread;
import org.netbeans.modules.debugger.support.java.JavaVariable;
import org.netbeans.modules.debugger.support.java.ModifiersFilter;

public abstract class JavaWatch
extends AbstractWatch
implements JavaVariable,
Validator.Object {
    static final long serialVersionUID = 3439367157517814302L;
    public static final String PROP_IN_SCOPE = "inScope";
    private transient PropertyChangeSupport pcs;
    protected String displayName;
    private boolean isHidden = false;
    protected JavaDebugger debugger;
    protected transient Validator validator;
    protected transient VariablesFilter filter;

    protected JavaWatch(JavaDebugger debugger, boolean hidden) {
        this.debugger = debugger;
        this.isHidden = hidden;
        this.validator = debugger.getValidator();
        if (this.validator != null) {
            this.validator.add(this);
        }
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getVariableName() {
        return this.displayName;
    }

    public void setVariableName(String displayName) {
        String old = this.displayName;
        this.displayName = displayName;
        this.validate();
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public void remove() {
        this.debugger.removeWatch(this);
        this.validator.remove(this);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public String getInfo() {
        return null;
    }

    public VariablesFilter getVariablesFilter() {
        if (this.filter != null) {
            return this.filter;
        }
        return this.debugger.getVariablesFilter();
    }

    public void setVariablesFilter(VariablesFilter filter) {
        if (filter == this.filter) {
            return;
        }
        if (filter != null && filter.equals(this.filter)) {
            return;
        }
        VariablesFilter old = this.filter;
        this.filter = filter;
        this.pcs.firePropertyChange("variablesFilter", old, filter);
    }

    protected abstract void refreshValue(JavaThread var1);

    public abstract boolean isInScope();

    public abstract AbstractVariable getVariable();

    public abstract String getErrorMessage();

    protected void firePropertyChange(final String s, final Object o, final Object n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JavaWatch.this.pcs.firePropertyChange(s, o, n);
            }
        });
    }

    public abstract Object getSpecialVariable(String var1);

    public abstract void setSpecialVariable(String var1, Object var2);

    public abstract String toStringValue();

    public abstract boolean isFixedVariable();

    public abstract JavaVariable createFixedVariable();

    public abstract int getVariablesNumber();

    public abstract AbstractVariable getVariable(String var1);

    public abstract String getModifiers();

    public abstract int getSize();

    public abstract void setLength(int var1);

    public abstract int getLength();

    public abstract void setStartIndex(int var1);

    public abstract int getStartIndex();

    public abstract boolean isArray();

    public abstract boolean isObject();

    public abstract String getInnerType();

    public abstract boolean canRemove();

    public abstract AbstractVariable[] getVariables();

    public abstract boolean isLeaf();

    public abstract JavaVariable[] filterVariables(ModifiersFilter var1, int var2, int var3);

    public static interface Fixed {
    }
}

