/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.java;

import org.netbeans.modules.debugger.AbstractVariable;
import org.netbeans.modules.debugger.VariablesProducer;
import org.netbeans.modules.debugger.support.java.ArrayFilter;
import org.netbeans.modules.debugger.support.java.JavaVariable;

public class LinkedListFilter
extends ArrayFilter {
    static final long serialVersionUID = 7592069698478681945L;

    public LinkedListFilter(String pattern) {
        super(pattern);
    }

    public AbstractVariable[] getVariables(VariablesProducer variable) {
        try {
            AbstractVariable h;
            JavaVariable jv = (JavaVariable)variable;
            int baseIndex = jv.getStartIndex();
            int length = jv.getLength();
            AbstractVariable s = jv.getVariable("size");
            if (s == null) {
                return jv.getVariables();
            }
            int k = Math.min(Integer.parseInt(s.getAsText()) - baseIndex, length);
            if (k < 0) {
                k = 0;
            }
            if ((h = jv.getVariable("header")) == null) {
                return jv.getVariables();
            }
            int i = 0;
            while (i < baseIndex) {
                if ((h = ((JavaVariable)h).getVariable("next")) == null) {
                    return jv.getVariables();
                }
                ++i;
            }
            AbstractVariable[] vs = new AbstractVariable[k];
            i = 0;
            while (i < k) {
                if ((h = ((JavaVariable)h).getVariable("next")) == null) {
                    return jv.getVariables();
                }
                vs[i] = ((JavaVariable)h).getVariable("element");
                if (vs[i] == null) {
                    return jv.getVariables();
                }
                ++i;
            }
            return vs;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return new AbstractVariable[0];
        }
    }

    public boolean elementsSorted() {
        return true;
    }
}

